/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowVisibleKeeper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowVisibleKeeper.class);
    private final Window window;

    public static void keepFrameVisibleOnDeviceChanges(Window window) {
        new WindowVisibleKeeper(window);
    }

    private WindowVisibleKeeper(Window window) {
        this.window = window;
        GUIUtil.addGraphicsDeviceChangedListener(window, this::handleDeviceChangedEvent);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WindowVisibleKeeper.this.ensureFrameIsVisible();
            }
        });
    }

    private void handleDeviceChangedEvent(PropertyChangeEvent evt) throws HeadlessException {
        log.debug("Display configuration changed.");
        GraphicsConfiguration gcOld = (GraphicsConfiguration)evt.getOldValue();
        GraphicsDevice devOld = gcOld.getDevice();
        GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        boolean deviceRemoved = Arrays.stream(screenDevices).noneMatch(d -> d == devOld && d.getDefaultConfiguration() == gcOld);
        if (deviceRemoved) {
            log.info("New or changed display device detected. Trying to fit window {} into new device bounds.", (Object)this.window.getName());
            this.ensureFrameIsVisible();
        }
    }

    private void ensureFrameIsVisible() {
        SwingUtilities.invokeLater(() -> {
            if (this.windowIsMaximized()) {
                return;
            }
            GraphicsConfiguration graphicsConfiguration = this.window.getGraphicsConfiguration();
            Rectangle bounds = graphicsConfiguration.getBounds();
            Dimension dimWMFrame = this.window.getSize();
            dimWMFrame.setSize(Math.min(bounds.getWidth(), dimWMFrame.getWidth()), Math.min(bounds.getHeight(), dimWMFrame.getHeight()));
            Point ptWMFrame = this.evaluateFrameStartPositionBasedOnScreens(graphicsConfiguration);
            this.window.setSize(dimWMFrame);
            this.window.setLocation(ptWMFrame);
        });
    }

    private boolean windowIsMaximized() {
        return this.window instanceof JFrame && (((JFrame)this.window).getExtendedState() & 6) != 0;
    }

    private Point evaluateFrameStartPositionBasedOnScreens(GraphicsConfiguration deviceConfiguration) {
        Point location = this.window.getLocation();
        Rectangle screenBounds = deviceConfiguration.getBounds();
        int delta = 50;
        Rectangle biggerScreenBounds = new Rectangle(screenBounds.x, screenBounds.y, screenBounds.width - delta, screenBounds.height - delta);
        if (!biggerScreenBounds.contains(location)) {
            location = new Point(screenBounds.x, screenBounds.y);
        }
        return location;
    }
}

