/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.ZoomHistory;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import com.vividsolutions.jump.workbench.ui.tools.ScreenScale;
import de.riwagis.unit.DrawingUnit;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public class Viewport
implements Java2DConverter.PointConverter,
WithScale {
    public static final RenderingHints.Key KEY_IS4PRINT = new RenderingHints.Key(50000){

        @Override
        public boolean isCompatibleValue(Object val) {
            return val == null || val instanceof Boolean;
        }
    };
    public static final Object VALUE_IS4PRINT = true;
    private final transient Collection<ViewportListener> listeners = new ArrayList<ViewportListener>();
    private final transient Java2DConverter java2DConverter;
    private final Component panel;
    private final transient ReadWriteLock zoomLock = new ReentrantReadWriteLock();
    private final transient Point2D viewOriginAsPerceivedByModel = new Point2D.Double(0.0, 0.0);
    private final transient ZoomHistory zoomHistory = new ZoomHistory();
    private double scale = 1.0;
    private AffineTransform modelToViewTransform;
    private double pixelScale = 1.3333333333333333;
    private double pixelScale4LineWidth = 1.0;

    public Viewport(Component panel, boolean printOnly) {
        this.panel = panel;
        this.java2DConverter = new Java2DConverter(this, printOnly);
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Viewport.this.fireZoomChanged();
            }
        });
    }

    public Component getPanel() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ViewportListener l) {
        Collection<ViewportListener> collection = this.listeners;
        synchronized (collection) {
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ViewportListener l) {
        Collection<ViewportListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    public Java2DConverter getJava2DConverter() {
        return this.java2DConverter;
    }

    public ZoomHistory getZoomHistory() {
        return this.zoomHistory;
    }

    public void setPixelScale(double pixelScale) {
        this.pixelScale = pixelScale;
    }

    public double getPixelScale() {
        return this.pixelScale;
    }

    public void setPixelScale4LineWidth(double pixelScale4LineWidth) {
        this.pixelScale4LineWidth = pixelScale4LineWidth;
    }

    public double getPixelScale4LineWidth() {
        return this.pixelScale4LineWidth;
    }

    public void update() {
        this.zoomLock.writeLock().lock();
        try {
            this.modelToViewTransform = this.modelToViewTransform(this.scale, this.viewOriginAsPerceivedByModel, this.panel.getWidth(), this.panel.getHeight());
        }
        finally {
            this.zoomLock.writeLock().unlock();
        }
    }

    private double getMinZoomWidth() {
        return this.panel != null && this.panel instanceof LayerViewPanel ? ((LayerViewPanel)this.panel).getLayerManager().getTask().getMinZoom() : Double.MIN_VALUE;
    }

    private AffineTransform modelToViewTransform(double scale, Point2D viewOriginAsPerceivedByModel, double panelWidth, double panelHeight) {
        double centerOffsetX = panelWidth / scale * 0.5;
        double centerOffsetY = panelHeight / scale * 0.5;
        AffineTransform newModelToViewTransform = new AffineTransform();
        newModelToViewTransform.translate(0.0, panelHeight);
        newModelToViewTransform.scale(1.0, -1.0);
        newModelToViewTransform.scale(scale, scale);
        newModelToViewTransform.translate(-viewOriginAsPerceivedByModel.getX() + centerOffsetX, -viewOriginAsPerceivedByModel.getY() + centerOffsetY);
        return newModelToViewTransform;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public void initialize(double newScale, Point2D newViewOriginAsPerceivedByModel) {
        this.setScaleInternalNoZoom(newScale);
        this.viewOriginAsPerceivedByModel.setLocation(newViewOriginAsPerceivedByModel);
    }

    public Point2D getOriginInModelCoordinates() {
        try {
            this.zoomLock.readLock().lock();
            Point2D point2D = this.viewOriginAsPerceivedByModel;
            return point2D;
        }
        finally {
            this.zoomLock.readLock().unlock();
        }
    }

    public void zoom(Point2D centreOfNewViewAsPerceivedByOldView, double widthOfNewViewAsPerceivedByOldView, double heightOfNewViewAsPerceivedByOldView) throws NoninvertibleTransformException {
        double zoomFactor = Math.min((double)this.panel.getWidth() / widthOfNewViewAsPerceivedByOldView, (double)this.panel.getHeight() / heightOfNewViewAsPerceivedByOldView);
        double realWidthOfNewViewAsPerceivedByOldView = (double)this.panel.getWidth() / zoomFactor;
        double realHeightOfNewViewAsPerceivedByOldView = (double)this.panel.getHeight() / zoomFactor;
        this.zoom(this.toModelEnvelope(centreOfNewViewAsPerceivedByOldView.getX() - 0.5 * realWidthOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getX() + 0.5 * realWidthOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getY() - 0.5 * realHeightOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getY() + 0.5 * realHeightOfNewViewAsPerceivedByOldView));
    }

    public Point2D toModelPoint(Point2D viewPoint) throws NoninvertibleTransformException {
        return this.toModelPoint(viewPoint, this.getModelToViewTransform());
    }

    public Point2D toModelPoint(Point2D viewPoint, AffineTransform model2ViewTransform) throws NoninvertibleTransformException {
        return model2ViewTransform.inverseTransform(this.toPoint2DDouble(viewPoint), null);
    }

    private Point2D.Double toPoint2DDouble(Point2D p) {
        if (p instanceof Point2D.Double) {
            return (Point2D.Double)p;
        }
        return new Point2D.Double(p.getX(), p.getY());
    }

    public Coordinate toModelCoordinate(Point2D viewPoint) throws NoninvertibleTransformException {
        return CoordUtil.toCoordinate(this.toModelPoint(viewPoint));
    }

    public Coordinate toModelCoordinate(Point2D viewPoint, AffineTransform model2ViewTransform) throws NoninvertibleTransformException {
        return CoordUtil.toCoordinate(this.toModelPoint(viewPoint, model2ViewTransform));
    }

    public Point2D toViewPoint(Point2D modelPoint) {
        return this.getModelToViewTransform().transform(this.toPoint2DDouble(modelPoint), null);
    }

    @Override
    public Point2D toViewPoint(Coordinate modelCoordinate) {
        return this.toViewPoint(modelCoordinate, this.getModelToViewTransform());
    }

    public Point2D toViewPoint(Coordinate modelCoordinate, AffineTransform model2ViewTransform) {
        Point2D.Double pt = new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
        return model2ViewTransform.transform(pt, pt);
    }

    public Envelope toModelEnvelope(double x1, double x2, double y1, double y2) throws NoninvertibleTransformException {
        Coordinate c1 = this.toModelCoordinate(new Point2D.Double(x1, y1));
        Coordinate c2 = this.toModelCoordinate(new Point2D.Double(x2, y2));
        return new Envelope(c1, c2);
    }

    public AffineTransform getModelToViewTransform() {
        if (this.modelToViewTransform == null) {
            this.update();
        }
        return this.modelToViewTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Envelope getEnvelopeInModelCoordinates() {
        try {
            this.zoomLock.readLock().lock();
            double widthAsPerceivedByModel = (double)this.panel.getWidth() / this.scale * 0.5;
            double heightAsPerceivedByModel = (double)this.panel.getHeight() / this.scale * 0.5;
            Envelope envelope = new Envelope(this.viewOriginAsPerceivedByModel.getX() - widthAsPerceivedByModel, this.viewOriginAsPerceivedByModel.getX() + widthAsPerceivedByModel, this.viewOriginAsPerceivedByModel.getY() - heightAsPerceivedByModel, this.viewOriginAsPerceivedByModel.getY() + heightAsPerceivedByModel);
            return envelope;
        }
        finally {
            this.zoomLock.readLock().unlock();
        }
    }

    public void zoom(Coordinate coord, double dblMapScale, DrawingUnit du) {
        Envelope env4Scale = ScreenScale.getEnvelope4MapScale(this, dblMapScale, du);
        Envelope env = new Envelope(coord.x - env4Scale.getWidth() / 2.0, coord.x + env4Scale.getWidth() / 2.0, coord.y - env4Scale.getHeight() / 2.0, coord.y + env4Scale.getHeight() / 2.0);
        this.zoom(env);
    }

    public void zoom(Envelope modelEnvelope) {
        this.zoom(modelEnvelope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(Envelope modelEnvelope, boolean fireEvent) {
        try {
            this.zoomLock.writeLock().lock();
            if (modelEnvelope.isNull()) {
                return;
            }
            double minZoomWidth = this.getMinZoomWidth();
            if (modelEnvelope.getWidth() < minZoomWidth) {
                modelEnvelope.expandBy(minZoomWidth - modelEnvelope.getWidth(), 0.0);
            }
            if (modelEnvelope.getHeight() < minZoomWidth) {
                modelEnvelope.expandBy(0.0, minZoomWidth - modelEnvelope.getHeight());
            }
            if (!this.zoomHistory.hasNext() && !this.zoomHistory.hasPrev()) {
                this.zoomHistory.add(this.getEnvelopeInModelCoordinates());
            }
            double pnlWidth = Math.max(this.panel.getWidth(), 1);
            double pnlHeight = Math.max(this.panel.getHeight(), 1);
            double envWidth = modelEnvelope.getWidth();
            double envHeight = modelEnvelope.getHeight();
            this.setScaleInternalNoZoom(Math.min(pnlWidth / envWidth, pnlHeight / envHeight));
            double xCenteringOffset = modelEnvelope.getWidth() / 2.0;
            double yCenteringOffset = modelEnvelope.getHeight() / 2.0;
            this.viewOriginAsPerceivedByModel.setLocation(modelEnvelope.getMinX() + xCenteringOffset, modelEnvelope.getMinY() + yCenteringOffset);
            this.update();
        }
        finally {
            this.zoomLock.writeLock().unlock();
        }
        if (fireEvent) {
            this.zoomHistory.add(modelEnvelope);
            this.fireZoomChanged();
        } else if (this.panel instanceof LayerViewPanel) {
            ((LayerViewPanel)this.panel).copyTo();
        } else {
            this.panel.repaint();
        }
    }

    public void setScaleInternalNoZoom(double scale) {
        if (scale == 0.0) {
            Assert.shouldNeverReachHere((String)"Scale in Viewport is not allowed to be zero.");
        }
        this.scale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireZoomChanged() {
        Collection<ViewportListener> collection = this.listeners;
        synchronized (collection) {
            for (ViewportListener l : this.listeners) {
                l.zoomChanged(this);
            }
            this.panel.repaint();
        }
    }

    public void zoomToViewPoint(Point2D centreOfNewViewAsPerceivedByOldView, double zoomFactor) throws NoninvertibleTransformException {
        double widthOfNewViewAsPerceivedByOldView = (double)this.panel.getWidth() / zoomFactor;
        double heightOfNewViewAsPerceivedByOldView = (double)this.panel.getHeight() / zoomFactor;
        this.zoom(centreOfNewViewAsPerceivedByOldView, widthOfNewViewAsPerceivedByOldView, heightOfNewViewAsPerceivedByOldView);
    }

    public Collection<Point2D> toViewPoints(Collection<Coordinate> modelCoordinates) {
        ArrayList<Point2D> viewPoints = new ArrayList<Point2D>();
        for (Coordinate modelCoordinate : modelCoordinates) {
            viewPoints.add(this.toViewPoint(modelCoordinate));
        }
        return viewPoints;
    }

    public Rectangle2D toViewRectangle(Envelope envelope) {
        Point2D p1 = this.toViewPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        Point2D p2 = this.toViewPoint(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        return new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
    }

    @Override
    public int getScaleType() {
        return 2;
    }
}

