/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;

public class ToolTipWriter {
    public static final String WRITER_SHOWALL = String.valueOf(ToolTipWriter.class) + "_SHOWALL";
    private static boolean enabled = true;
    private final Blackboard blackboard;
    private final FeatureFinder featureFinder;

    public ToolTipWriter(LayerViewPanel panel) {
        this.featureFinder = (location, pixelBuffer) -> this.findFeaturesAtCoordinate(panel, location, pixelBuffer);
        this.blackboard = PersistentBlackboardPlugIn.get();
    }

    ToolTipWriter(Blackboard blackboard, FeatureFinder featureFinder) {
        this.blackboard = blackboard;
        this.featureFinder = featureFinder;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        ToolTipWriter.enabled = enabled;
    }

    public String write(Point2D mouseLocation) {
        Map<Layer, Collection<SimpleFeature>> featuresAtCoordinate;
        int pixelBuffer = 2;
        if (!enabled) {
            return null;
        }
        try {
            featuresAtCoordinate = this.featureFinder.findAtCoordinate(mouseLocation, pixelBuffer);
        }
        catch (NoninvertibleTransformException e) {
            return "";
        }
        if (featuresAtCoordinate.isEmpty()) {
            return null;
        }
        return this.writeDefaultToolTip(featuresAtCoordinate, true, true);
    }

    private void appendTooltip(StringBuilder sbToolTip, String strTooltip, Layer layer, SimpleFeature f, int countFeatLayer, boolean printHeaders) {
        if (sbToolTip.length() > 0) {
            if (countFeatLayer == 0) {
                sbToolTip.append("<br><br>");
            } else {
                sbToolTip.append("<hr>");
            }
        }
        if (printHeaders && countFeatLayer == 0) {
            String strTheme;
            sbToolTip.append("<b>").append(layer.getName());
            if (layer instanceof AbstractCadLayer && f != null && !(strTheme = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.toString()), "")).isEmpty()) {
                sbToolTip.append(" / ").append(strTheme);
            }
            sbToolTip.append("</b><br>");
        }
        sbToolTip.append(strTooltip.replace("\n", "<br>"));
    }

    public String getTooltipForFeature(Layer layer, SimpleFeature feature, boolean enclosingHtml) {
        return Objects.toString(this.writeDefaultToolTip(Map.of(layer, List.of(feature)), false, enclosingHtml), "");
    }

    private String writeDefaultToolTip(Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap, boolean printHeaders, boolean enclosingHtml) {
        List tooltipLayers = layerToSpecifiedFeaturesMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        if (tooltipLayers.isEmpty()) {
            return null;
        }
        StringBuilder sbToolTip = new StringBuilder();
        for (Layer layer : tooltipLayers) {
            LayerStyleCollection sCol = layer.getValidLayerStyleCollection();
            if (sCol == null) continue;
            if (layer instanceof AbstractCadLayer) {
                AbstractCadStyleModel cadStyle = sCol.getStyle(AbstractCadStyleModel.class);
                if (cadStyle.isShowTooltips()) {
                    Collection<SimpleFeature> features = layerToSpecifiedFeaturesMap.get(layer);
                    Map<String, List<SimpleFeature>> groupedByTheme = this.groupAndSortFeaturesByTheme(features);
                    for (List<SimpleFeature> featuresForTheme : groupedByTheme.values()) {
                        int countFeatLayer = 0;
                        for (SimpleFeature feature : featuresForTheme) {
                            String tooltip = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.NAME.getName()), "");
                            if (!StringUtils.isNotBlank((CharSequence)tooltip)) continue;
                            this.appendTooltip(sbToolTip, tooltip, layer, feature, countFeatLayer, printHeaders);
                            ++countFeatLayer;
                        }
                    }
                }
            } else {
                TextStyleModel tStyle;
                BasicStyleModel bStyle = sCol.getBasicStyle();
                if (bStyle != null && bStyle.isShowTooltips() && (tStyle = bStyle.getTooltipStyle()) != null) {
                    int countFeatLayer = 0;
                    for (SimpleFeature feature : layerToSpecifiedFeaturesMap.get(layer)) {
                        String strTmp = ((TextRenderer)tStyle.getIntelligence()).getTextForFeature(feature);
                        if (!StringUtils.isNotBlank((CharSequence)strTmp)) continue;
                        this.appendTooltip(sbToolTip, strTmp, layer, feature, countFeatLayer, printHeaders);
                        ++countFeatLayer;
                    }
                }
            }
            if (this.blackboard.get(WRITER_SHOWALL, true)) continue;
            break;
        }
        if (sbToolTip.toString().trim().length() == 0) {
            return null;
        }
        if (enclosingHtml) {
            sbToolTip.insert(0, "<html>");
            sbToolTip.append("</html>");
        }
        return sbToolTip.toString();
    }

    private Map<String, List<SimpleFeature>> groupAndSortFeaturesByTheme(Collection<SimpleFeature> features) {
        return features.stream().collect(Collectors.groupingBy(f -> Objects.toString(FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.getName()), ""), () -> new TreeMap(Comparator.naturalOrder()), Collectors.toList()));
    }

    private Map<Layer, Collection<SimpleFeature>> findFeaturesAtCoordinate(LayerViewPanel panel, Point2D mouseLocation, int pixelBuffer) throws NoninvertibleTransformException {
        Collection<Layer> layers = panel.getLayerManager().getLayers();
        Viewport viewport = panel.getViewport();
        return SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(layers, EnvelopeUtil.expand(new Envelope(viewport.toModelCoordinate(mouseLocation)), (double)pixelBuffer / viewport.getScale()));
    }

    @FunctionalInterface
    static interface FeatureFinder {
        public Map<Layer, Collection<SimpleFeature>> findAtCoordinate(Point2D var1, int var2) throws NoninvertibleTransformException;
    }
}

