/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.DummyLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.LoadTaskTransferHandler;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.components.ErrorListDialog;
import com.vividsolutions.jump.workbench.ui.cursortool.DummyTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModel;
import com.vividsolutions.jump.workbench.ui.layertree.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.InfoPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractSaveTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.tools.ScreenScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFrame
extends JInternalFrame
implements TaskFrameProxy,
LayerViewPanelProxy,
LayerNamePanelProxy,
LayerManagerProxy,
SelectionManagerProxy,
Task.PropertiesChangedListener,
ViewportListener {
    private static final String PBB_DIVIDER_LOCATION = TaskFrame.class.getName() + "_DIVIDER_LOCATION";
    public static final int LAYERCOUNT_TO_SHOW_DETAILS = 4;
    private static final Logger LOG = LoggerFactory.getLogger(TaskFrame.class);
    private LayerNamePanel layerNamePanel = new DummyLayerNamePanel();
    private LayerViewPanel layerViewPanel;
    private final Task task;
    private WorkbenchContext workbenchContext;
    private JSplitPane splitPane = new JSplitPane();
    private InfoPanel infoPanel = null;

    public TaskFrame(Task task, WorkbenchContext workbenchContext) {
        this.setDefaultCloseOperation(0);
        this.task = task;
        this.workbenchContext = workbenchContext;
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.addPropertyChangeListener("dividerLocation", evt -> PersistentBlackboardPlugIn.get().put(PBB_DIVIDER_LOCATION, this.splitPane.getDividerLocation()));
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (TaskFrame.this.layerViewPanel != null) {
                    TaskFrame.this.layerViewPanel.setCurrentCursorTool(new DummyTool());
                }
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                JInternalFrame selectedFrame = WorkbenchContext.getFrame().getActiveInternalFrame();
                if (selectedFrame == null) {
                    EditingPanel.instanceOf().initWithTaskFrame(null);
                }
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                TaskFrame.this.closeTaskFrame(false);
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                TaskFrame.this.splitPane.remove((Component)((Object)TaskFrame.this.layerNamePanel));
                TaskFrame.this.layerNamePanel = TaskFrame.this.createLayerNamePanel();
                TaskFrame.this.splitPane.add((Component)((Object)TaskFrame.this.layerNamePanel), "left");
                TaskFrame.this.layerNamePanel.addListener(JUMPWorkbench.getFrame().getLayerNamePanelListener());
            }
        });
        this.layerViewPanel = new LayerViewPanel(task.getLayerManager(), JUMPWorkbench.getFrame());
        this.layerViewPanel.setRepaint(false);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LOG.warn("Error executing jbInit()", (Throwable)e);
        }
        this.layerViewPanel.addListener(JUMPWorkbench.getFrame().getLayerViewPanelListener());
        this.layerViewPanel.getSelectionManager().addSelectionListener(JUMPWorkbench.getFrame().getSelectionListener());
        this.layerViewPanel.getViewport().addListener(JUMPWorkbench.getFrame());
        this.layerViewPanel.getViewport().addListener(this);
        task.addPropertiesChangedListener(this);
        Gis3DContextImpl.getInstance().registerSelectionManager(this.layerViewPanel.getSelectionManager());
    }

    public boolean closeTaskFrame(boolean askIfNoChanges) {
        LayerManager layerManager = this.getLayerManager();
        Collection<Layer> modifiedLayers = layerManager.getModifiedLayers();
        if (modifiedLayers.size() > 4) {
            if (!this.confirmCloseErrorList(modifiedLayers)) {
                return false;
            }
        } else if (!modifiedLayers.isEmpty()) {
            StringBuilder sbLyNames = new StringBuilder();
            for (Layer ly : modifiedLayers) {
                if (sbLyNames.length() > 0) {
                    sbLyNames.append(", ");
                }
                sbLyNames.append(ly.getName());
            }
            if (!this.confirmClose(I18N.get("ui.WorkbenchFrame.close-task"), I18N.getMessage("ui.WorkbenchFrame.data-has-been-modified", sbLyNames.toString()))) {
                return false;
            }
        }
        if (layerManager.getTask().isModified() && !COpt.VIEWER) {
            int intOpt = this.confirmCloseSave(I18N.get("ui.WorkbenchFrame.close-task-save"), I18N.get("ui.WorkbenchFrame.close-task"), I18N.getMessage("ui.WorkbenchFrame.project-has-been-modified", layerManager.getTask().getName()));
            if (intOpt == 2) {
                return false;
            }
            if (intOpt == 0 && !AbstractSaveTaskPlugIn.saveTask(layerManager.getTask())) {
                return false;
            }
        } else if (askIfNoChanges && !this.confirmClose(I18N.get("ui.WorkbenchFrame.close-task"), I18N.getMessage("ui.WorkbenchFrame.close-task-question", layerManager.getTask().getName()))) {
            return false;
        }
        layerManager.setFiringEvents(false);
        this.disposeAndCleanup();
        SwingUtilities.invokeLater(() -> {
            System.runFinalization();
            System.gc();
        });
        return true;
    }

    private boolean confirmClose(String action, String message) {
        JOptionPane pane = new JOptionPane(message, 2);
        pane.setOptions(new String[]{action, I18N.get("ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, I18N.get("common.alert")).setVisible(true);
        return pane.getValue().equals(action);
    }

    private boolean confirmCloseErrorList(Collection<Layer> modifiedLayers) {
        List<String> layerNames = TaskFrame.toSortedStringList(modifiedLayers, AbstractLayerable::getName);
        Object confirmCloseResult = ErrorListDialog.show(this, I18N.get("common.error"), I18N.get("ui.WorkbenchFrame.close-task"), I18N.get("ui.WorkbenchFrame.data-has-been-modified-list-message"), layerNames, true);
        return confirmCloseResult != null && !Objects.equals(ErrorListDialog.CANCEL, confirmCloseResult.toString()) && !Objects.equals(-1, confirmCloseResult);
    }

    public static <T> List<String> toSortedStringList(Collection<T> modifiedLayers, Function<T, String> toStringFunction) {
        return modifiedLayers.stream().map(toStringFunction).filter(Objects::nonNull).sorted(String::compareToIgnoreCase).toList();
    }

    private int confirmCloseSave(String actionSave, String action, String message) {
        JOptionPane pane = new JOptionPane(message, 2);
        pane.setOptions(new String[]{actionSave, action, I18N.get("ui.WorkbenchFrame.cancel")});
        pane.createDialog(this, I18N.get("common.alert")).setVisible(true);
        if (pane.getValue().equals(actionSave)) {
            return 0;
        }
        if (pane.getValue().equals(action)) {
            return 1;
        }
        return 2;
    }

    @Override
    public TaskFrame getTaskFrame() {
        return this;
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.getLayerViewPanel().getSelectionManager();
    }

    @Override
    public boolean hasFocus() {
        return this.layerViewPanel.hasFocus();
    }

    @Override
    public void zoomChanged(Viewport vPort) {
        this.task.setScale(ScreenScale.getHorizontalMapScale(vPort, this.task.getDrawingUnit()));
        Gis3DContextImpl.getInstance().autoSync3DPosition();
    }

    protected LayerNamePanel createLayerNamePanel() {
        TreeLayerNamePanel treeLayerNamePanel = new TreeLayerNamePanel(this.workbenchContext, this, new LayerTreeModel(this), this.layerViewPanel.getRenderingManager());
        Map<Class<?>, Object> nodeClassToPopupMenuMap = JUMPWorkbench.getFrame().getNodeClassToPopupMenuMap(false);
        for (Class<?> nodeClass : nodeClassToPopupMenuMap.keySet()) {
            treeLayerNamePanel.addPopupMenu(nodeClass, (JPopupMenu)nodeClassToPopupMenuMap.get(nodeClass), false);
        }
        Map<Class<?>, Object> nodeClassToPopupMenuMapBuildIn = JUMPWorkbench.getFrame().getNodeClassToPopupMenuMap(true);
        for (Class<?> nodeClass : nodeClassToPopupMenuMapBuildIn.keySet()) {
            treeLayerNamePanel.addPopupMenu(nodeClass, (JPopupMenu)nodeClassToPopupMenuMapBuildIn.get(nodeClass), true);
        }
        return treeLayerNamePanel;
    }

    private void disposeAndCleanup() {
        Gis3DContextImpl.getInstance().unregisterSelectionManager(this.getLayerViewPanel().getSelectionManager());
        this.layerViewPanel.dispose();
        this.layerNamePanel.dispose();
        GUIUtil.dispose(this, this.getDesktopPane());
        if (this.infoPanel != null) {
            this.infoPanel.getModel().dispose();
            this.infoPanel = null;
        }
        this.layerViewPanel = null;
        this.layerNamePanel = null;
        this.task.dispose();
        this.workbenchContext = null;
        this.splitPane = null;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.task.getLayerManager();
    }

    public InfoPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new InfoPanel(this.workbenchContext, this);
        }
        return this.infoPanel;
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.layerViewPanel;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public void propertiesChanged(Task tempTask) {
        this.updateTitle();
        WorkbenchFrame wf = JUMPWorkbench.getFrame();
        wf.setCoordinateInfo();
        wf.displayProjectionReductionLabel(tempTask.isProjectionReductionActive());
    }

    private void jbInit() {
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setSize(680, 380);
        this.getContentPane().setLayout(new BorderLayout());
        this.splitPane.setBorder(null);
        int dividerLocation = PersistentBlackboardPlugIn.get().get(PBB_DIVIDER_LOCATION, 150);
        dividerLocation = Math.min(this.getWidth() - 10, dividerLocation);
        dividerLocation = Math.max(10, dividerLocation);
        this.splitPane.setDividerLocation(dividerLocation);
        this.splitPane.add((Component)((Object)this.layerNamePanel), "left");
        this.splitPane.add((Component)this.layerViewPanel, "right");
        this.setContent(null);
        this.updateTitle();
        this.setTransferHandler(new LoadTaskTransferHandler());
    }

    public void setContent(JComponent component) {
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        if (component == null) {
            contentPane.add((Component)this.splitPane, "Center");
        } else {
            contentPane.add((Component)component, "Center");
        }
        this.getContentPane().validate();
    }

    private void updateTitle() {
        Object titleInt = this.task.getName();
        if (this.task.getProjectFile() != null) {
            titleInt = (String)titleInt + " - " + this.task.getProjectFile().getName();
        }
        this.setTitle((String)titleInt);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }
}

