/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInputDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(MultiInputDialog.class);
    private static final int SIDEBAR_WIDTH = 150;
    private final HashMap<String, JComponent> fieldNameToComponentMap = new HashMap();
    private final HashMap<String, JComponent> fieldNameToLabelMap = new HashMap();
    private int rowCount = 0;
    private final LayerNameRenderer layerListCellRenderer = new LayerNameRenderer(LayerNameRenderer.Style.SINGLE_ROW_PREVIEW_LEFT);
    private final CollectionMap<String, EnableCheck> fieldNameToEnableCheckListMap = new CollectionMap();
    private final JPanel outerMainPanel = new JPanel();
    private final OKCancelPanel okCancelPanel = new OKCancelPanel();
    private final GridBagLayout gridBagLayout5 = new GridBagLayout();
    private final GridBagLayout gridBagLayout7 = new GridBagLayout();
    private final GridBagLayout gridBagLayout6 = new GridBagLayout();
    private final BorderLayout borderLayout2 = new BorderLayout();
    private final JPanel imagePanel = new JPanel();
    private final GridBagLayout gridBagLayout3 = new GridBagLayout();
    private final JLabel imageLabel = new JLabel();
    private final JPanel mainPanel = new JPanel();
    private final GridBagLayout mainPanelGridBagLayout = new GridBagLayout();
    private final JPanel innerMainPanel = new JPanel();
    private final JPanel innerMainPanel2 = new JPanel();
    private final JTextArea descriptionTextArea = new JTextArea();
    private final JPanel strutPanel = new JPanel();
    private JPanel currentMainPanel = this.innerMainPanel;
    private final JPanel verticalSeparatorPanel = new JPanel();
    private final ArrayList<ActionListener> lstApplyListeners = new ArrayList();

    public MultiInputDialog(Window window, String title, boolean modal) {
        super(window);
        this.setTitle(title);
        this.setModal(modal);
        this.init();
    }

    public MultiInputDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.init();
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error at initializing MultiInputDialog.", (Throwable)ex);
        }
        this.imagePanel.setVisible(false);
        this.descriptionTextArea.setText("");
        this.imageLabel.setText("");
        this.innerMainPanel2.setVisible(false);
        this.verticalSeparatorPanel.setVisible(false);
    }

    public MultiInputDialog() {
        this((Frame)null, "", false);
    }

    public void setApplyVisible(boolean applyVisible) {
        this.okCancelPanel.setApplyVisible(applyVisible);
    }

    public void addOkApplyCancelListener(ActionListener l) {
        this.lstApplyListeners.add(l);
    }

    public void removeOKApplyCancelListener(ActionListener l) {
        this.lstApplyListeners.remove(l);
    }

    public void removeAllOKApplyCancelListener() {
        this.lstApplyListeners.clear();
    }

    private void fireOKApplyCancelPerformed() {
        for (ActionListener l : this.lstApplyListeners) {
            l.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    private <T extends JComponent> T getComponent(String fieldName) {
        return (T)this.fieldNameToComponentMap.get(fieldName);
    }

    public <T> JComboBox<T> getComboBox(String fieldName) {
        return (JComboBox)this.getComponent(fieldName);
    }

    public JCheckBox getCheckBox(String fieldName) {
        return (JCheckBox)this.getComponent(fieldName);
    }

    public JComponent getLabel(String fieldName) {
        return this.fieldNameToLabelMap.get(fieldName);
    }

    public String getText(String fieldName) {
        if (this.fieldNameToComponentMap.get(fieldName) instanceof JTextField) {
            return ((JTextField)this.fieldNameToComponentMap.get(fieldName)).getText();
        }
        if (this.fieldNameToComponentMap.get(fieldName) instanceof JComboBox) {
            return ((JComboBox)this.fieldNameToComponentMap.get(fieldName)).getSelectedItem().toString();
        }
        Assert.shouldNeverReachHere((String)fieldName);
        return null;
    }

    public void setOKPressed(boolean bolOKPressed) {
        this.okCancelPanel.setOKPressed(bolOKPressed);
    }

    public boolean getBoolean(String fieldName) {
        JCheckBox checkbox = (JCheckBox)this.fieldNameToComponentMap.get(fieldName);
        return checkbox.isSelected();
    }

    public double getDouble(String fieldName) {
        return Double.parseDouble(this.getText(fieldName).trim());
    }

    public int getInteger(String fieldName) {
        return Integer.parseInt(this.getText(fieldName).trim());
    }

    public Layer getLayer(String fieldName) {
        JComboBox comboBox = this.getComboBox(fieldName);
        return (Layer)comboBox.getSelectedItem();
    }

    public JTextField addTextField(String fieldName, String initialValue, int approxWidthInChars, EnableCheck[] enableChecks, String toolTipText) {
        JTextField textField = new JTextField(initialValue, approxWidthInChars);
        this.addRow(fieldName, new JLabel(fieldName), textField, 1, 2, enableChecks, toolTipText);
        return textField;
    }

    public <T> JComboBox<T> addComboBox(String fieldName, Object selectedItem, Collection<T> items, String toolTipText) {
        JComboBox<T> comboBox = new JComboBox<T>(new Vector<T>(items));
        comboBox.setSelectedItem(selectedItem);
        this.addRow(fieldName, new JLabel(fieldName), comboBox, 1, 2, null, toolTipText);
        return comboBox;
    }

    public JLabel addLabel(String text) {
        JLabel lbl = new JLabel(text);
        this.addRow(lbl);
        return lbl;
    }

    public void addRow(JComponent c) {
        this.addRow("DUMMY", new JLabel(""), c, null, null);
    }

    public void addSeparator() {
        JPanel separator = new JPanel();
        separator.setBackground(Color.black);
        separator.setPreferredSize(new Dimension(1, 1));
        this.addRow(separator);
    }

    private JTextField addNumericField(String fieldName, String initialValue, int approxWidthInChars, EnableCheck[] enableChecks, String toolTipText) {
        JTextField fld = this.addTextField(fieldName, initialValue, approxWidthInChars, enableChecks, toolTipText);
        fld.setHorizontalAlignment(4);
        return fld;
    }

    public JTextField addIntegerField(String fieldName, int initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createIntegerCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveIntegerField(String fieldName, int initialValue, int approxWidthInChars) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createIntegerCheck(fieldName), this.createPositiveCheck(fieldName)}, null);
    }

    public JTextField addDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName)}, null);
    }

    public JTextField addDoubleField(String fieldName, double initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName), this.createPositiveCheck(fieldName)}, null);
    }

    public JTextField addNonNegativeDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName), this.createNonNegativeCheck(fieldName)}, null);
    }

    public static void main(String[] args) {
        MultiInputDialog d = new MultiInputDialog(null, "Title!", true);
        d.addLabel("Yay!");
        d.addLayerComboBox("LayerField", null, "ToolTip", new LayerManager());
        d.setVisible(true);
        System.out.println(d.getLayer("LayerField"));
        System.exit(0);
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, null, layerManager);
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, String toolTipText, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, toolTipText, layerManager.getLayers());
    }

    public JComboBox<Layer> addEditableLayerComboBox(String fieldName, Layer initialValue, String toolTipText, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, toolTipText, layerManager.getEditableLayers());
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, String toolTipText, Collection<Layer> layers) {
        this.addComboBox(fieldName, initialValue, layers, toolTipText);
        JComboBox<Layer> comboBox = this.getComboBox(fieldName);
        comboBox.setRenderer(this.layerListCellRenderer);
        return comboBox;
    }

    public JCheckBox addCheckBox(String fieldName, boolean initialValue) {
        return this.addCheckBox(fieldName, initialValue, null);
    }

    public JCheckBox addCheckBox(String fieldName, boolean initialValue, String toolTipText) {
        JCheckBox checkBox = new JCheckBox(fieldName, initialValue);
        this.addRow(fieldName, new JLabel(""), checkBox, null, toolTipText);
        return checkBox;
    }

    public void setSideBarImage(Icon icon) {
        this.imagePanel.add((Component)this.imageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.imagePanel.setVisible(true);
        this.imageLabel.setIcon(icon);
    }

    public void setSideBarDescription(String description) {
        this.imagePanel.setVisible(true);
        this.descriptionTextArea.setText(description);
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public boolean wasApplyPressed() {
        return this.okCancelPanel.wasApplyPressed();
    }

    final void jbInit() {
        this.verticalSeparatorPanel.setBackground(Color.black);
        this.imageLabel.setText(I18N.get("ui.MultiInputDialog.images-goes-here"));
        this.descriptionTextArea.setOpaque(false);
        this.okCancelPanel.addActionListener(this::okCancelPanelActionPerformed);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MultiInputDialog.this.componentShow();
            }
        });
        this.outerMainPanel.setLayout(this.gridBagLayout6);
        this.outerMainPanel.setAlignmentX(0.7f);
        this.setResizable(true);
        this.getContentPane().setLayout(this.borderLayout2);
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.imagePanel.setLayout(this.gridBagLayout3);
        this.mainPanel.setLayout(this.mainPanelGridBagLayout);
        this.innerMainPanel.setLayout(this.gridBagLayout5);
        this.innerMainPanel2.setLayout(this.gridBagLayout7);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setText(I18N.get("ui.MultiInputDialog.description-goes-here"));
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.strutPanel.setMaximumSize(new Dimension(150, 1));
        this.strutPanel.setMinimumSize(new Dimension(150, 1));
        this.strutPanel.setPreferredSize(new Dimension(150, 1));
        this.verticalSeparatorPanel.setPreferredSize(new Dimension(1, 1));
        this.getContentPane().add((Component)this.okCancelPanel, "South");
        this.getContentPane().add((Component)this.outerMainPanel, "Center");
        this.imagePanel.add((Component)this.descriptionTextArea, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.imagePanel.add((Component)this.strutPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.outerMainPanel.add((Component)this.mainPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.innerMainPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.innerMainPanel2, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.verticalSeparatorPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.outerMainPanel.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.descriptionTextArea.setFont(this.imageLabel.getFont());
        this.descriptionTextArea.setDisabledTextColor(this.imageLabel.getForeground());
    }

    public void setInset(int inset) {
        this.setInset(inset, this.innerMainPanel);
        this.setInset(inset, this.innerMainPanel2);
    }

    private void setInset(int inset, JComponent component) {
        GridBagLayout layout = (GridBagLayout)component.getParent().getLayout();
        GridBagConstraints constraints = layout.getConstraints(component);
        constraints.insets = new Insets(inset, inset, inset, inset);
        layout.setConstraints(component, constraints);
    }

    void okCancelPanelActionPerformed(ActionEvent e) {
        if (!this.okCancelPanel.wasOKPressed() && !this.okCancelPanel.wasApplyPressed()) {
            this.fireOKApplyCancelPerformed();
            SwingUtilities.invokeLater(() -> this.setVisible(false));
            return;
        }
        if (!this.isInputValid()) {
            this.reportValidationError(this.firstValidationErrorMessage());
            return;
        }
        this.fireOKApplyCancelPerformed();
        if (this.okCancelPanel.wasOKPressed()) {
            SwingUtilities.invokeLater(() -> this.setVisible(false));
        }
    }

    void componentShow() {
        this.okCancelPanel.setOKPressed(false);
    }

    private boolean isInputValid() {
        return this.firstValidationErrorMessage() == null;
    }

    private void reportValidationError(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, I18N.get("ui.MultiInputDialog.validation-error-title"), 0);
    }

    private String firstValidationErrorMessage() {
        for (String fieldName : this.fieldNameToEnableCheckListMap.keySet()) {
            for (EnableCheck enableCheck : this.fieldNameToEnableCheckListMap.getItems(fieldName)) {
                String message = enableCheck.check(null);
                if (message == null) continue;
                return message;
            }
        }
        return null;
    }

    public void startNewColumn() {
        if (this.innerMainPanel2.isVisible()) {
            Assert.shouldNeverReachHere((String)"#startNewColumn can be called once only");
        }
        this.currentMainPanel = this.innerMainPanel2;
        this.innerMainPanel2.setVisible(true);
        this.verticalSeparatorPanel.setVisible(true);
    }

    public void addRow(String fieldName, JComponent label, JComponent component, EnableCheck[] enableChecks, String toolTipText) {
        this.addRow(fieldName, label, component, 0, 0, enableChecks, toolTipText);
    }

    public void addRow(String fieldName, JComponent label, JComponent component, int weightXComponent, int fillComponent, EnableCheck[] enableChecks, String toolTipText) {
        int labelWidth;
        int labelX;
        int componentWidth;
        int componentX;
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
        }
        this.fieldNameToLabelMap.put(fieldName, label);
        this.fieldNameToComponentMap.put(fieldName, component);
        if (enableChecks != null) {
            this.addEnableChecks(fieldName, Arrays.asList(enableChecks));
        }
        if (component instanceof JCheckBox || component instanceof JLabel || component instanceof JPanel) {
            componentX = 1;
            componentWidth = 3;
            labelX = 4;
            labelWidth = 1;
            if (toolTipText != null) {
                component.setToolTipText(toolTipText);
            }
        } else {
            labelX = 1;
            labelWidth = 1;
            componentX = 2;
            componentWidth = 1;
        }
        this.currentMainPanel.add((Component)label, new GridBagConstraints(labelX, this.rowCount, labelWidth, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 10), 0, 0));
        this.currentMainPanel.add((Component)component, new GridBagConstraints(componentX, this.rowCount, componentWidth, 1, weightXComponent, 1.0, 17, component instanceof JPanel ? 2 : fillComponent, new Insets(0, 0, 5, 0), 0, 0));
        ++this.rowCount;
        this.pack();
        this.doNotAllowDialogSizesBelowMinimum();
    }

    public void indentLabel(String comboBoxFieldName) {
        this.getLabel(comboBoxFieldName).setBorder(BorderFactory.createMatteBorder(0, (int)new JCheckBox().getPreferredSize().getWidth(), 0, 0, this.getLabel(comboBoxFieldName).getBackground()));
    }

    public void addEnableChecks(String fieldName, Collection<EnableCheck> enableChecks) {
        this.fieldNameToEnableCheckListMap.addItems(fieldName, enableChecks);
    }

    public EnableCheck createDoubleCheck(String fieldName) {
        return component -> {
            try {
                Double.parseDouble(this.getText(fieldName).trim());
                return null;
            }
            catch (NumberFormatException e) {
                return "\"" + this.getText(fieldName).trim() + "\" " + I18N.get("ui.MultiInputDialog.is-an-invalid-double") + " (" + fieldName + ")";
            }
        };
    }

    public EnableCheck createIntegerCheck(String fieldName) {
        return component -> {
            try {
                Integer.parseInt(this.getText(fieldName).trim());
                return null;
            }
            catch (NumberFormatException e) {
                return "\"" + this.getText(fieldName).trim() + "\" " + I18N.get("ui.MultiInputDialog.is-an-invalid-integer") + " (" + fieldName + ")";
            }
        };
    }

    public EnableCheck createPositiveCheck(String fieldName) {
        return component -> {
            if (Double.parseDouble(this.getText(fieldName).trim()) > 0.0) {
                return null;
            }
            return "\"" + this.getText(fieldName).trim() + "\" " + I18N.get("ui.MultiInputDialog.must-be") + " > 0 (" + fieldName + ")";
        };
    }

    public EnableCheck createNonNegativeCheck(String fieldName) {
        return component -> {
            if (Double.parseDouble(this.getText(fieldName).trim()) >= 0.0) {
                return null;
            }
            return "\"" + this.getText(fieldName).trim() + "\" " + I18N.get("ui.MultiInputDialog.must-be") + " >= 0 (" + fieldName + ")";
        };
    }

    public static void fitDialogToContent(Window dialog) {
        if (dialog == null) {
            return;
        }
        dialog.setMinimumSize(null);
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
    }

    private void doNotAllowDialogSizesBelowMinimum() {
        this.setMinimumSize(this.getSize());
    }
}

