/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.LoadLayerFromFilePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.GeoPackageImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.ImportTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.OpenTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.SaveTaskAsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.LoadRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import de.riwagis.riwajump.workbench.ui.plugin.dwg.ConvertDwgToGeoPackagePlugIn;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.TransferHandler;
import org.apache.commons.lang3.StringUtils;

public class LoadTaskTransferHandler
extends TransferHandler {
    private static final EnableCheck TASK_WINDOW_MUST_BE_ACTIVE_CHECK = EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck();

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        try {
            Transferable transferable = support.getTransferable();
            if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (files == null || files.isEmpty()) {
                return false;
            }
            boolean hasActiveTaskFrame = support.getComponent() instanceof TaskFrame && StringUtils.isEmpty((CharSequence)TASK_WINDOW_MUST_BE_ACTIVE_CHECK.check(null));
            boolean isGisContextAvailable = JUMPWorkbench.GIS_CONTEXT != null;
            boolean isAuthor = !COpt.VIEWER;
            for (File file : files) {
                if (file.isDirectory() || !file.exists()) {
                    return false;
                }
                if (SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER.accept(file) || hasActiveTaskFrame && (RedlineLayerUtils.RLY_FILE_FILTER.accept(file) || ConvertDwgToGeoPackagePlugIn.CAD_FILE_FILTER.accept(file) || isAuthor && isGisContextAvailable && ConvertDwgToGeoPackagePlugIn.DWG_FILE_FILTER.accept(file) || isAuthor && ShapefileUtils.SHP_FILE_FILTER.accept(file) || isAuthor && GeoPackageImportFormat.FILE_FILTER.accept(file))) continue;
                return false;
            }
            if (support.getDropAction() == 2) {
                return true;
            }
            if (support.getDropAction() == 0x40000000) {
                return hasActiveTaskFrame;
            }
            return false;
        }
        catch (InvalidDnDOperationException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
        try {
            List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : files) {
                Runnable work = () -> {
                    try {
                        if (SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER.accept(file)) {
                            if (support.getDropAction() == 2) {
                                dlgWait.setMessage(I18N.get("ui.plugin.OpenProjectPlugIn.loading"));
                                OpenTaskPlugIn.open(file, JUMPWorkbench.getFrame(), false);
                            } else if (support.getDropAction() == 0x40000000) {
                                dlgWait.setMessage(I18N.get("ui.plugin.ImportTaskPlugIn.loading"));
                                boolean bolBuildIn = !GUISupport.yesnobox((Component)JUMPWorkbench.getFrame(), (String)I18N.get("ui.plugin.ImportTaskPlugIn.union-project"), (String)I18N.get("common.message"));
                                Task task = JUMPWorkbench.getContext().getLayerManager().getTask();
                                ImportTaskPlugIn.open(file, task, bolBuildIn);
                            }
                        } else if (ShapefileUtils.SHP_FILE_FILTER.accept(file)) {
                            ShapefileUtils.addShapeFiles(JUMPWorkbench.getContext().createPlugInContext(), Collections.singletonList(file), "ISO-8859-1").displayMessageOrThrow();
                        } else if (RedlineLayerUtils.RLY_FILE_FILTER.accept(file)) {
                            LoadRedlineLayerPlugIn.loadRedlineLayers(JUMPWorkbench.getContext().createPlugInContext(), new File[]{file});
                        } else if (ConvertDwgToGeoPackagePlugIn.CAD_FILE_FILTER.accept(file) || ConvertDwgToGeoPackagePlugIn.DWG_FILE_FILTER.accept(file)) {
                            ConvertDwgToGeoPackagePlugIn plugin = new ConvertDwgToGeoPackagePlugIn();
                            plugin.loadFromFile(JUMPWorkbench.getContext().createPlugInContext(), file);
                        } else if (GeoPackageImportFormat.FILE_FILTER.accept(file)) {
                            LoadLayerFromFilePlugIn.loadFromFile(JUMPWorkbench.getContext().createPlugInContext(), file, new GeoPackageImportFormat());
                        }
                    }
                    catch (Exception e) {
                        dlgWait.setError(e);
                    }
                };
                dlgWait.addWorkToDo(work);
            }
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ErrorBox.showException((Window)JUMPWorkbench.getFrame(), (String)I18N.get("common.error"), (Throwable)dlgWait.getError());
        }
        return true;
    }
}

