/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.ImageUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.FlashOptions;
import com.vividsolutions.jump.workbench.ui.FlashStyle;
import com.vividsolutions.jump.workbench.ui.Flasher;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.ToolTipWriter;
import com.vividsolutions.jump.workbench.ui.TrackedPopupMenu;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DummyTool;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.RenderHints;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingSupport;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import com.vividsolutions.jump.workbench.ui.renderer.style.PinEqualCoordinatesStyle;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.util.gui.highdpi.HighDpiSupport;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.LayerUI;
import lombok.Generated;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerViewPanel
extends JPanel
implements LayerView,
LayerListener,
LayerManagerProxy,
SelectionManagerProxy,
RenderContext,
SelectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayerViewPanel.class);
    public static final int DELAYED_REPAINT = 500;
    private static final JPopupMenu popupMenu = new TrackedPopupMenu();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final transient LayerManager layerManager;
    private final Point lastClickedPoint = new Point();
    private final transient Collection<LayerViewPanelListener> listeners = new ArrayList<LayerViewPanelListener>();
    private final transient LayerViewPanelContext context;
    private final transient SelectionManager selectionManager;
    private final Blackboard blackboard = new Blackboard();
    private final transient Collection<ActionListener> lstCursorChange = new ArrayList<ActionListener>();
    private final transient ReadWriteLock lockSetImg4Paint = new ReentrantReadWriteLock();
    private final transient Lock lockCopyTo = new ReentrantLock();
    private final transient Lock lockRepaint = new ReentrantLock();
    private final transient Flasher flasher = new Flasher(this::copyTo);
    private final transient RenderingManager renderingManager = new RenderingManager(this);
    private final transient ToolTipWriter toolTipWriter = new ToolTipWriter(this);
    private final Viewport viewport;
    private boolean viewportInitialized = false;
    private transient ThreadSafeImage img4Paint = null;
    private long lngLastRepaint = 0L;
    private transient CursorTool currentCursorTool = new DummyTool();
    private final boolean bolRender4Print;
    private transient RenderHints renderHints = RenderingSupport.RENDERHINTS_DEFAULT;
    private boolean repaint = true;
    private final JLayer<JComponent> glassLayer;
    private final transient PopupMenuListener popupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.activateGlassPane();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.deactivateGlassPane();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.deactivateGlassPane();
        }

        private void deactivateGlassPane() {
            LayerViewPanel.this.getRootPane().getGlassPane().setVisible(false);
            popupMenu.removePopupMenuListener(this.getPopupMenuListener());
        }

        private void activateGlassPane() {
            LayerViewPanel.this.getCurrentCursorTool().cancelGesture();
            this.forceMouseRelease();
            if (LayerViewPanel.this.getRootPane().getGlassPane() != LayerViewPanel.this.glassLayer) {
                LayerViewPanel.this.getRootPane().setGlassPane(LayerViewPanel.this.glassLayer);
            }
            LayerViewPanel.this.getRootPane().getGlassPane().setVisible(true);
        }

        private void forceMouseRelease() {
            Point point = new Point(LayerViewPanel.this.getLastClickedPoint());
            Point pointAbs = LayerViewPanel.this.getLocationOnScreen();
            pointAbs.translate(point.x, point.y);
            LayerViewPanel.this.dispatchEvent(new MouseEvent(LayerViewPanel.this, 502, System.currentTimeMillis(), 0, point.x, point.y, pointAbs.x, pointAbs.y, 1, false, 1));
        }

        private PopupMenuListener getPopupMenuListener() {
            return LayerViewPanel.this.popupMenuListener;
        }
    };
    private final Timer delayedRepaintTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                LayerViewPanel.this.renderingManager.renderAll();
                LayerViewPanel.this.delayedRepaintTimer.stop();
            }
            catch (Exception ex) {
                LayerViewPanel.this.context.handleThrowable(ex);
            }
        }
    });

    public LayerViewPanel(LayerManager layerManager, LayerViewPanelContext context) {
        this(layerManager, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerViewPanel(LayerManager layerManager, LayerViewPanelContext context, boolean printOnly) {
        this.setRepaint(false);
        this.bolRender4Print = printOnly;
        this.delayedRepaintTimer.setRepeats(false);
        this.delayedRepaintTimer.setInitialDelay(500);
        this.setMinimumSize(new Dimension(100, 100));
        this.setToolTipText("");
        this.context = context;
        this.layerManager = layerManager;
        this.selectionManager = new SelectionManager(this);
        this.selectionManager.addSelectionListener(this);
        this.viewport = new Viewport(this, printOnly);
        try {
            layerManager.addLayerListener(this);
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                log.error("Error in LayerViewPanels jbInit()", (Throwable)ex);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    LayerViewPanel.this.requestFocusInWindow();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                private void mouseLocationChanged(MouseEvent e) {
                    try {
                        Point2D p = LayerViewPanel.this.getViewport().toModelPoint(e.getPoint());
                        LayerViewPanel.this.fireCursorPositionChanged(LayerViewPanel.this.format(p.getX()), LayerViewPanel.this.format(p.getY()));
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.context.handleThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            context.handleThrowable(t);
        }
        finally {
            this.setRepaint(true);
        }
        this.glassLayer = this.createGlassPane();
    }

    private JLayer<JComponent> createGlassPane() {
        LayerUI<JComponent> layerUI = new LayerUI<JComponent>(){

            @Override
            protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> l) {
                e.consume();
            }

            @Override
            protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends JComponent> l) {
                e.consume();
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JComponent> l) {
                e.consume();
            }
        };
        JComponent glassPane = new JComponent(){

            @Override
            public void paint(Graphics g) {
            }
        };
        JLayer<JComponent> layer = new JLayer<JComponent>(glassPane, layerUI);
        layer.setLayerEventMask(131120L);
        return layer;
    }

    public boolean getRender4Print() {
        return this.bolRender4Print;
    }

    @Override
    public RenderHints getRenderHints() {
        return this.renderHints;
    }

    public void setRenderHints(RenderHints renderHints) {
        this.renderHints = renderHints;
    }

    public ToolTipWriter getToolTipWriter() {
        return this.toolTipWriter;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String toolTip = this.currentCursorTool.useTooltip() ? this.currentCursorTool.getTooltip(event.getPoint()) : this.toolTipWriter.write(event.getPoint());
        super.setToolTipText(toolTip);
        return toolTip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.getToolTipText() == null) {
            return null;
        }
        return new Point(event.getX(), event.getY() + 20);
    }

    public final void setRepaint(boolean repaint) {
        this.repaint = repaint;
    }

    public boolean isRepainting() {
        return this.repaint;
    }

    public static Collection<Geometry> components(Geometry g) {
        if (!(g instanceof GeometryCollection)) {
            return Collections.singletonList(g);
        }
        GeometryCollection c = (GeometryCollection)g;
        ArrayList<Geometry> components = new ArrayList<Geometry>();
        for (int i = 0; i < c.getNumGeometries(); ++i) {
            components.addAll(LayerViewPanel.components(c.getGeometryN(i)));
        }
        return components;
    }

    public static boolean intersects(Geometry a, Geometry b) {
        GeometryFactory factory = new GeometryFactory(a.getPrecisionModel(), a.getSRID());
        Collection<Geometry> aComponents = LayerViewPanel.components(a);
        Collection<Geometry> bComponents = LayerViewPanel.components(b);
        for (Geometry aComponent : aComponents) {
            Assert.isTrue((!(aComponent instanceof GeometryCollection) ? 1 : 0) != 0);
            Geometry aComponentTmp = LayerViewPanel.collapseToPointIfPossible(aComponent, factory);
            for (Geometry bComponent : bComponents) {
                Assert.isTrue((!(bComponent instanceof GeometryCollection) ? 1 : 0) != 0);
                Geometry bComponentTmp = LayerViewPanel.collapseToPointIfPossible(bComponent, factory);
                if (!aComponentTmp.intersects(bComponentTmp)) continue;
                return true;
            }
        }
        return false;
    }

    private static Geometry collapseToPointIfPossible(Geometry g, GeometryFactory factory) {
        if (!g.isEmpty() && PinEqualCoordinatesStyle.coordinatesEqual(g)) {
            return factory.createPoint(g.getCoordinate());
        }
        return g;
    }

    public Map<Layer, Collection<SimpleFeature>> visibleLayerToFeaturesInFenceMap(Geometry fence) {
        HashMap<Layer, Collection<SimpleFeature>> map = new HashMap<Layer, Collection<SimpleFeature>>();
        try {
            for (Layer layer : this.getLayerManager().getLayers()) {
                if (!layer.isVisibleOnScreen()) continue;
                HashSet<SimpleFeature> features = new HashSet<SimpleFeature>();
                try (FeatureIterator<SimpleFeature> fi = layer.getLastFeatureIterator(fence.getEnvelopeInternal());){
                    while (fi.hasNext()) {
                        SimpleFeature candidate = (SimpleFeature)fi.next();
                        if (!LayerViewPanel.intersects((Geometry)candidate.getDefaultGeometry(), fence)) continue;
                        features.add(candidate);
                    }
                }
                if (features.isEmpty()) continue;
                map.put(layer, features);
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
        return map;
    }

    public static JPopupMenu popupMenu() {
        return popupMenu;
    }

    public void setCurrentCursorTool(CursorTool currentCursorTool) {
        try {
            GUIUtil.invokeOnEventThread(() -> {
                if (this.currentCursorTool == currentCursorTool) {
                    return;
                }
                this.currentCursorTool.deactivate();
                this.removeMouseListener(this.currentCursorTool);
                this.removeMouseMotionListener(this.currentCursorTool);
                this.removeMouseWheelListener(this.currentCursorTool);
                if (this.currentCursorTool.getKeyListener() != null) {
                    WorkbenchContext.getFrame().removeEasyKeyListener(this.currentCursorTool.getKeyListener());
                }
                this.currentCursorTool = currentCursorTool;
                currentCursorTool.activate(this);
                this.setCursor(currentCursorTool.getCursor());
                this.addMouseListener(currentCursorTool);
                this.addMouseMotionListener(currentCursorTool);
                this.addMouseWheelListener(currentCursorTool);
                if (currentCursorTool.getKeyListener() != null) {
                    WorkbenchContext.getFrame().addEasyKeyListener(currentCursorTool.getKeyListener());
                }
                this.fireCursorToolChanged(currentCursorTool);
            });
        }
        catch (InterruptedException ex) {
            log.error("LayerViewPanel.setCurrentCursorTool was interupted", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException ex) {
            log.error("LayerViewPanel.setCurrentCursorTool unknown exception", (Throwable)ex);
        }
    }

    public void addCursorToolChangedListener(ActionListener listenCTChange) {
        if (this.lstCursorChange.contains(listenCTChange)) {
            return;
        }
        this.lstCursorChange.add(listenCTChange);
    }

    public void removeCursorToolChangedListener(ActionListener listenCTChange) {
        this.lstCursorChange.remove(listenCTChange);
    }

    private void fireCursorToolChanged(CursorTool cursorTool) {
        ActionEvent evt = new ActionEvent(cursorTool, 0, "ctChange");
        for (ActionListener listenCTChange : this.lstCursorChange) {
            listenCTChange.actionPerformed(evt);
        }
    }

    public void setViewportInitialized(boolean viewportInitialized) {
        this.viewportInitialized = viewportInitialized;
    }

    public CursorTool getCurrentCursorTool() {
        return this.currentCursorTool;
    }

    public Point getLastClickedPoint() {
        return this.lastClickedPoint;
    }

    @Override
    public Viewport getViewport() {
        return this.viewport;
    }

    public Java2DConverter getJava2DConverter() {
        return this.viewport.getJava2DConverter();
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
        this.renderingManager.render(e.getLayer());
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
        if (e.getType() == CategoryEventType.VISIBILITY_CHANGED || e.getType() == CategoryEventType.ADDED) {
            List<Layerable> lstLayers = e.getCategory().getAllLayerables();
            this.renderingManager.render(lstLayers.iterator());
        }
    }

    @Override
    public void layerChanged(LayerEvent e) {
        try {
            if (e.getType() == LayerEventType.METADATA_CHANGED || e.getType() == LayerEventType.TABLE_DATA_CHANGED) {
                return;
            }
            if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.APPEARANCE_CHANGED) {
                this.renderingManager.render(e.getLayerable());
            } else if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                this.renderingManager.render(e.getLayerable(), false);
            } else {
                Assert.shouldNeverReachHere();
            }
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public Image createBlankPanelImage() {
        return ImageUtil.createBlankPanelImage(this.getWidth(), this.getHeight());
    }

    public Image createVolatilePanelImage() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        VolatileImage image = gc.createCompatibleVolatileImage(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()), 3);
        if (image.validate(gc) == 2) {
            return this.createVolatileImage(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()));
        }
        Graphics2D g = image.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        return image;
    }

    @Override
    public void repaint() {
        if (this.lockRepaint == null) {
            return;
        }
        try {
            this.lockRepaint.lock();
            if (!this.repaint) {
                return;
            }
            if (this.renderingManager == null) {
                return;
            }
            long time = System.currentTimeMillis();
            if (time - this.lngLastRepaint > 500L || this.bolRender4Print) {
                this.renderingManager.renderAll();
            } else {
                this.delayedRepaintTimer.stop();
                this.delayedRepaintTimer.restart();
            }
            this.lngLastRepaint = time;
        }
        finally {
            this.lockRepaint.unlock();
        }
    }

    public Image getImage4Paint() {
        return this.img4Paint.getImage();
    }

    public boolean superRepaint() {
        if (this.lockCopyTo.tryLock()) {
            try {
                try {
                    GUIUtil.invokeOnEventThread(() -> LayerViewPanel.super.repaint());
                }
                catch (Exception eatit) {
                    log.error("Error in superRepaint", (Throwable)eatit);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lockCopyTo.unlock();
            }
        }
        return false;
    }

    public Thread copyTo() {
        if (!this.repaint) {
            return null;
        }
        Runnable rSuperRepaint = () -> {
            this.lockCopyTo.lock();
            try {
                ThreadSafeImage img4PaintTmp = this.renderingManager.copyTo();
                this.lockSetImg4Paint.writeLock().lock();
                try {
                    this.img4Paint = img4PaintTmp;
                }
                finally {
                    this.lockSetImg4Paint.writeLock().unlock();
                }
                this.superRepaint();
            }
            finally {
                this.lockCopyTo.unlock();
            }
        };
        Thread thCopyTo = new Thread(rSuperRepaint, "LayerViewPanel - copyTo");
        thCopyTo.start();
        return thCopyTo;
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            RenderingSupport.setRenderingHints((Graphics2D)g, this.renderHints);
            this.setBackground(GUIUtil.alphaColor(Color.WHITE, 255));
            super.paintComponent(g);
            this.paintRenderedElements(g);
            this.firePainted(g);
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    private void paintRenderedElements(Graphics g) {
        if (this.img4Paint != null) {
            this.lockSetImg4Paint.readLock().lock();
            try {
                this.img4Paint.copyTo((Graphics2D)g, null);
            }
            finally {
                this.lockSetImg4Paint.readLock().unlock();
            }
        }
        if (this.renderingManager != null) {
            this.renderingManager.copyToOverlay((Graphics2D)g);
        }
    }

    public void erase(Graphics2D g) {
        this.fill(g, this.getBackground());
    }

    public void fill(Graphics2D g, Color color) {
        g.setColor(color);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(r);
    }

    private void jbInit() {
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                LayerViewPanel.this.handleMouseRelease(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LayerViewPanel.this.updateViewportAndRepaint();
            }
        });
        this.setLayout(this.borderLayout1);
    }

    private void updateViewportAndRepaint() {
        try {
            this.viewport.update();
            this.repaint();
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    @Override
    public LayerViewPanelContext getContext() {
        return this.context;
    }

    private void handleMouseRelease(MouseEvent e) {
        this.lastClickedPoint.setLocation(e.getPoint());
        if (this.currentCursorTool.isRightMouseButtonUsed()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (popupMenu.getSubElements().length == 0) {
                return;
            }
            popupMenu.addPopupMenuListener(this.popupMenuListener);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
        this.requestFocusInWindow();
    }

    public boolean isInitialized() {
        return this.viewportInitialized;
    }

    public void addListener(LayerViewPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LayerViewPanelListener listener) {
        this.listeners.remove(listener);
    }

    public String format(double d) {
        double pixelWidthInModelUnits = this.viewport.getEnvelopeInModelCoordinates().getWidth() / (double)this.getWidth();
        return this.format(d, pixelWidthInModelUnits);
    }

    protected String format(double d, double pixelWidthInModelUnits) {
        int precisionInDecimalPlaces = (int)Math.max(0L, Math.round(-Math.log(pixelWidthInModelUnits) / Math.log(10.0)));
        String format = "#." + "#".repeat(Math.max(0, ++precisionInDecimalPlaces));
        return new DecimalFormat(format).format(d);
    }

    private void firePainted(Graphics graphics) {
        for (LayerViewPanelListener l : this.listeners) {
            l.painted(graphics);
        }
    }

    @Override
    public void selectionChanged() {
        this.superRepaint();
    }

    private void fireCursorPositionChanged(String x, String y) {
        for (LayerViewPanelListener l : this.listeners) {
            l.cursorPositionChanged(x, y);
        }
    }

    public RenderingManager getRenderingManager() {
        return this.renderingManager;
    }

    @Override
    public void dispose() {
        this.setRepaint(false);
        this.renderingManager.dispose();
        this.selectionManager.dispose();
        this.layerManager.removeLayerListener(this);
        this.listeners.clear();
    }

    @Override
    public double getScale() {
        return HighDpiSupport.getDisplayScaleFactorForDevice((GraphicsConfiguration)this.getGraphicsConfiguration());
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public void flash(GeometryCollection geometryCollection) {
        this.flash(geometryCollection, FlashStyle.DEFAULT_COLOR, FlashStyle.DEFAULT_STROKE, 200);
    }

    public void flash(GeometryCollection geometryCollection, Color color, int intDelay) {
        this.flash(geometryCollection, color, FlashStyle.DEFAULT_STROKE, intDelay);
    }

    public void flash(GeometryCollection geometryCollection, Color color, Stroke stroke, int millisecondDelay) {
        FlashStyle style = new FlashStyle(geometryCollection, color, stroke);
        this.flasher.flash(FlashOptions.createSingleFlash(millisecondDelay, style));
    }

    public void flash(FlashOptions options) {
        this.flasher.flash(options);
    }

    public void zoomToFullExtent() {
        Envelope env = this.fullExtent();
        this.setViewportInitialized(true);
        this.getViewport().zoom(env);
    }

    public Envelope fullExtent() {
        Envelope env = this.getLayerManager().getTask().getInitialView();
        if (env == null) {
            env = this.getLayerManager().getEnvelopeOfAllLayers(true);
            env = EnvelopeUtil.bufferByFraction(env, 0.03);
            this.getLayerManager().getTask().getBlackboard().put("INITIAL_VIEW", env);
            this.getLayerManager().getTask().getBlackboard().put("INITIAL_VIEW", env);
        }
        return env;
    }
}

