/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryTreeLogic {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryTreeLogic.class);
    private final Geometry emptyGeometry = new GeometryFactory().createPoint((Coordinate)null);

    public Set<Geometry> getTransitiveSelectionForFeature(List<Geometry> selections, Geometry sourceGeometry) {
        Map<Geometry, Geometry> geometryTree = this.traverse(sourceGeometry).collect(Collectors.toMap(NodeRelation::node, NodeRelation::parent));
        Set selectedItems = selections.stream().filter(this::isCollectionType).flatMap(this::traverse).map(NodeRelation::node).collect(Collectors.toSet());
        selectedItems.addAll(selections);
        return selectedItems.stream().flatMap(r -> this.backtrack(geometryTree, (Geometry)r)).collect(Collectors.toSet());
    }

    public Stream<NodeRelation<Geometry>> traverse(Geometry srcGeometry) {
        final ArrayDeque<ImmutableNodeRelation<Geometry>> stack = new ArrayDeque<ImmutableNodeRelation<Geometry>>();
        stack.add(new ImmutableNodeRelation<Geometry>(srcGeometry, this.emptyGeometry));
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<NodeRelation<Geometry>>(){

            @Override
            public boolean hasNext() {
                return !stack.isEmpty();
            }

            @Override
            public NodeRelation<Geometry> next() {
                NodeRelation el = (NodeRelation)stack.pop();
                Geometry node = (Geometry)el.node();
                Geometry parent = (Geometry)el.parent();
                if (node != null) {
                    if (node instanceof GeometryCollection) {
                        return GeometryTreeLogic.this.traverseCollection((GeometryCollection)node, parent, stack);
                    }
                    if (node instanceof Polygon) {
                        return GeometryTreeLogic.this.traversePolygon((Polygon)node, parent, stack);
                    }
                    if (node instanceof Point) {
                        return new ImmutableNodeRelation<Geometry>(node, parent);
                    }
                    if (node instanceof LineString) {
                        return new ImmutableNodeRelation<Geometry>(node, parent);
                    }
                    Assert.shouldNeverReachHere((String)I18N.get("ui.GeometryEditor.unsupported-geometry-classes-should-be-caught-in-the-GeometryEditorOperation"));
                }
                return null;
            }
        }, 1281), false);
    }

    private Stream<Geometry> backtrack(final Map<Geometry, Geometry> geometryTree, Geometry srcGeometry) {
        final Geometry[] currNode = new Geometry[]{srcGeometry};
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Geometry>(){

            @Override
            public boolean hasNext() {
                return currNode[0] != null && currNode[0] != GeometryTreeLogic.this.emptyGeometry;
            }

            @Override
            public Geometry next() {
                Geometry node = currNode[0];
                currNode[0] = (Geometry)geometryTree.get(currNode[0]);
                return node;
            }
        }, 1281), false);
    }

    private boolean isCollectionType(Geometry geometry) {
        return geometry instanceof GeometryCollection || geometry instanceof Polygon;
    }

    private NodeRelation<Geometry> traverseCollection(GeometryCollection geometryCollection, Geometry parent, Deque<NodeRelation<Geometry>> stack) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            stack.push(new ImmutableNodeRelation<GeometryCollection>((GeometryCollection)geometryCollection.getGeometryN(i), geometryCollection));
        }
        return new ImmutableNodeRelation<Geometry>((Geometry)geometryCollection, parent);
    }

    private NodeRelation<Geometry> traversePolygon(Polygon polygon, Geometry parent, Deque<NodeRelation<Geometry>> stack) {
        stack.push(new ImmutableNodeRelation<Polygon>((Polygon)polygon.getExteriorRing(), polygon));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            stack.push(new ImmutableNodeRelation<Polygon>((Polygon)polygon.getInteriorRingN(i), polygon));
        }
        return new ImmutableNodeRelation<Geometry>((Geometry)polygon, parent);
    }

    public static class ImmutableNodeRelation<T>
    implements NodeRelation<T> {
        private final T node;
        private final T parent;

        public ImmutableNodeRelation(T node, T parent) {
            Objects.requireNonNull(node);
            Objects.requireNonNull(parent);
            this.node = node;
            this.parent = parent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableNodeRelation that = (ImmutableNodeRelation)o;
            return Objects.equals(this.node, that.node) && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.parent);
        }

        @Override
        public T node() {
            return this.node;
        }

        @Override
        public T parent() {
            return this.parent;
        }
    }

    public static interface NodeRelation<T> {
        public T node();

        public T parent();
    }
}

