/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GeometryTreeLogic;
import de.riwagis.util.jts.CoordinateArraySupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class GeometryEditor {
    private final GeometryFactory factory = new GeometryFactory();
    private final GeometryTreeLogic geometryTreeLogic = new GeometryTreeLogic();

    public Geometry edit(Geometry geometry, GeometryEditorOperation operation) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, operation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, operation);
        }
        if (geometry instanceof Point) {
            return operation.edit(geometry);
        }
        if (geometry instanceof LineString) {
            return operation.edit(geometry);
        }
        Assert.shouldNeverReachHere((String)I18N.get("ui.GeometryEditor.unsupported-geometry-classes-should-be-caught-in-the-GeometryEditorOperation"));
        return null;
    }

    private Geometry editPolygon(Polygon polygon, GeometryEditorOperation operation) {
        Geometry newGeometry = operation.edit((Geometry)polygon);
        if (newGeometry.isEmpty() || !(newGeometry instanceof Polygon)) {
            return newGeometry;
        }
        Polygon newPolygon = (Polygon)newGeometry;
        LinearRing shell = (LinearRing)this.edit((Geometry)newPolygon.getExteriorRing(), operation);
        boolean hasChanged = shell != newPolygon.getExteriorRing();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < newPolygon.getNumInteriorRing(); ++i) {
            LinearRing hole;
            LinearRing srcHole = newPolygon.getInteriorRingN(i);
            if (srcHole != (hole = (LinearRing)this.edit((Geometry)srcHole, operation))) {
                hasChanged = true;
            }
            if (hole.isEmpty()) continue;
            holes.add(hole);
        }
        if (shell.isEmpty()) {
            if (holes.isEmpty()) {
                return this.factory.createPolygon(null, null);
            }
            return this.factory.createMultiLineString(holes.toArray(new LineString[0]));
        }
        if (!hasChanged) {
            return newPolygon;
        }
        return this.factory.createPolygon(shell, holes.toArray(new LinearRing[0]));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection collection, GeometryEditorOperation operation) {
        GeometryCollection newCollection = (GeometryCollection)operation.edit((Geometry)collection);
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        boolean hasChanged = newCollection != collection;
        for (int i = 0; i < newCollection.getNumGeometries(); ++i) {
            Geometry geometryN = newCollection.getGeometryN(i);
            Geometry geometry = this.edit(geometryN, operation);
            if (geometry != geometryN) {
                hasChanged = true;
            }
            if (geometry.isEmpty()) continue;
            geometries.add(geometry);
        }
        if (!hasChanged) {
            return collection;
        }
        if (newCollection.getClass() == MultiPoint.class) {
            return this.factory.createMultiPoint(geometries.toArray(new Point[0]));
        }
        if (newCollection.getClass() == MultiLineString.class) {
            return this.factory.createMultiLineString(geometries.toArray(new LineString[0]));
        }
        if (newCollection.getClass() == MultiPolygon.class) {
            return this.factory.createMultiPolygon(geometries.toArray(new Polygon[0]));
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public Geometry removeRepeatedPoints(Geometry geometry) {
        if (geometry == null || geometry.isEmpty()) {
            return geometry;
        }
        return this.edit(geometry, new CoordinateOperation(this){

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                return CoordinateArrays.removeRepeatedPoints((Coordinate[])coordinates);
            }
        });
    }

    public Geometry remove(Geometry g, Geometry itemToRemove) {
        return this.edit(g, geometry -> geometry == itemToRemove ? this.createNullGeometry(geometry) : geometry);
    }

    public Geometry filter(Geometry sourceGeometry, List<Geometry> itemsToKeep) {
        Set<Geometry> expanded = this.geometryTreeLogic.getTransitiveSelectionForFeature(itemsToKeep, sourceGeometry);
        return this.edit(sourceGeometry, geometry -> expanded.contains(geometry) ? geometry : this.createNullGeometry(geometry));
    }

    public Geometry selectiveEdit(Geometry sourceGeometry, List<Geometry> itemsToTraverse, GeometryEditorOperation operation) {
        Set<Geometry> expanded = this.geometryTreeLogic.getTransitiveSelectionForFeature(itemsToTraverse, sourceGeometry);
        return this.edit(sourceGeometry, geometry -> {
            if (expanded.contains(geometry)) {
                return operation.edit(geometry);
            }
            return geometry;
        });
    }

    public List<Geometry> flatten(Geometry sourceGeometry) {
        return this.geometryTreeLogic.traverse(sourceGeometry).filter(relation -> !(relation.node() instanceof GeometryCollection) && !(relation.parent() instanceof Polygon)).map(GeometryTreeLogic.NodeRelation::node).collect(Collectors.toList());
    }

    public Geometry simplify(Geometry sourceGeometry) {
        if (!this.isGeometryCollection(sourceGeometry) || sourceGeometry instanceof MultiPolygon || sourceGeometry instanceof MultiLineString) {
            return sourceGeometry;
        }
        List<Geometry> geometries = this.flatten(sourceGeometry);
        boolean hasLines = geometries.stream().anyMatch(g -> g instanceof LineString);
        boolean hasPolygons = geometries.stream().anyMatch(g -> g instanceof Polygon);
        boolean hasAnythingElse = geometries.stream().anyMatch(g -> !(g instanceof Polygon) && !(g instanceof LineString));
        if (hasLines && !hasPolygons && !hasAnythingElse) {
            return this.factory.createMultiLineString(geometries.toArray(new LineString[0]));
        }
        if (!hasLines && hasPolygons && !hasAnythingElse) {
            return this.factory.createMultiPolygon(geometries.toArray(new Polygon[0]));
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    private boolean isGeometryCollection(Geometry geomSelected) {
        return geomSelected.getClass().getSimpleName().equals("GeometryCollection");
    }

    private Geometry createNullGeometry(Geometry geometry) {
        Objects.requireNonNull(geometry);
        Class<?> geometryClass = geometry.getClass();
        if (geometryClass == MultiPolygon.class) {
            return this.factory.createMultiPolygon(null);
        }
        if (geometryClass == MultiLineString.class) {
            return this.factory.createMultiLineString(null);
        }
        if (geometryClass == MultiPoint.class) {
            return this.factory.createMultiPointFromCoords(null);
        }
        if (geometryClass == GeometryCollection.class) {
            return this.factory.createGeometryCollection(null);
        }
        if (geometryClass == Polygon.class) {
            return this.factory.createPolygon(null, null);
        }
        if (geometryClass == LinearRing.class) {
            return this.factory.createLinearRing((Coordinate[])null);
        }
        if (geometryClass == LineString.class) {
            return this.factory.createLineString((Coordinate[])null);
        }
        if (geometryClass == Point.class) {
            return this.factory.createPoint((Coordinate)null);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public Geometry insertVertex(Geometry geometry, Coordinate target, Geometry ignoreSegmentsOutside) {
        LineString closestSegment = null;
        Point targetPoint = this.factory.createPoint(target);
        for (Coordinate[] coordinates : CoordinateArraySupport.toCoordinateArrays((Geometry)geometry, (boolean)false)) {
            if (coordinates.length < 2) continue;
            for (int j = 1; j < coordinates.length; ++j) {
                LineString candidate = this.factory.createLineString(new Coordinate[]{coordinates[j], coordinates[j - 1]});
                if (!candidate.intersects(ignoreSegmentsOutside) || closestSegment != null && !(candidate.distance((Geometry)targetPoint) < closestSegment.distance((Geometry)targetPoint))) continue;
                closestSegment = candidate;
            }
        }
        if (closestSegment == null) {
            return null;
        }
        return this.insertVertex(geometry, closestSegment.getCoordinateN(0), closestSegment.getCoordinateN(1), new LineSegment(closestSegment.getCoordinateN(0), closestSegment.getCoordinateN(1)).closestPoint(target));
    }

    public Geometry insertVertex(Geometry geometry, final Coordinate existing1, final Coordinate existing2, final Coordinate v) {
        if (geometry.isEmpty()) {
            return geometry;
        }
        return this.edit(geometry, new CoordinateOperation(this){
            private boolean vertexInserted = false;

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                if (this.vertexInserted) {
                    return coordinates;
                }
                for (int i = 1; i < coordinates.length; ++i) {
                    if ((!coordinates[i - 1].equals((Object)existing1) || !coordinates[i].equals((Object)existing2)) && (!coordinates[i - 1].equals((Object)existing2) || !coordinates[i].equals((Object)existing1))) continue;
                    Coordinate[] newCoordinates = new Coordinate[coordinates.length + 1];
                    System.arraycopy(coordinates, 0, newCoordinates, 0, i);
                    newCoordinates[i] = v;
                    System.arraycopy(coordinates, i, newCoordinates, i + 1, coordinates.length - i);
                    this.vertexInserted = true;
                    return newCoordinates;
                }
                return coordinates;
            }
        });
    }

    public Geometry deleteVertices(Geometry geometry, final Collection<Coordinate> vertices) {
        return this.edit(geometry, new CoordinateOperation(){

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                ArrayList<Coordinate> newCoordinates = new ArrayList<Coordinate>(Arrays.asList(coordinates));
                boolean firstCoordinateDeleted = false;
                int j = -1;
                Iterator i = newCoordinates.iterator();
                while (i.hasNext()) {
                    Coordinate c = (Coordinate)i.next();
                    ++j;
                    if (!GeometryEditor.this.containsReference(vertices, c)) continue;
                    i.remove();
                    if (j != 0) continue;
                    firstCoordinateDeleted = true;
                }
                if (linearRing && firstCoordinateDeleted) {
                    newCoordinates.remove(newCoordinates.size() - 1);
                }
                if (linearRing && firstCoordinateDeleted && !newCoordinates.isEmpty() && !((Coordinate)newCoordinates.get(0)).equals(newCoordinates.get(newCoordinates.size() - 1))) {
                    newCoordinates.add(new Coordinate((Coordinate)newCoordinates.get(0)));
                }
                return newCoordinates.toArray(new Coordinate[0]);
            }
        });
    }

    public <T> boolean containsReference(Collection<T> collection, Object o) {
        return collection.stream().anyMatch(item -> item == o);
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1);
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        private final GeometryFactory factory = new GeometryFactory();

        private Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
            return c.length >= n ? c : new Coordinate[]{};
        }

        @Override
        public Geometry edit(Geometry geometry) {
            if (geometry instanceof LinearRing) {
                return this.factory.createLinearRing(this.atLeastNCoordinatesOrNothing(4, this.edit(geometry.getCoordinates(), true)));
            }
            if (geometry instanceof LineString) {
                return this.factory.createLineString(this.atLeastNCoordinatesOrNothing(2, this.edit(geometry.getCoordinates(), false)));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(geometry.getCoordinates(), false);
                Assert.isTrue((newCoordinates.length < 2 ? 1 : 0) != 0);
                return this.factory.createPoint(newCoordinates.length > 0 ? newCoordinates[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, boolean var2);
    }
}

