/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.components.ValidatingTextField;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.util.gui.highdpi.HighDpiCursorSupport;
import de.riwagis.util.gui.highdpi.HighDpiSupport;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GUIUtil.class);
    public static final double ROUND_TOLERANCE = 1.0E-8;
    public static final String dbf = "dbf";
    public static final String dbfDesc = "DBF";
    public static final String fme = "fme";
    public static final String fmeDesc = "FME GML";
    public static final String gml = "gml";
    public static final String gmlDesc = "GML";
    public static final String jml = "jml";
    public static final String jmlDesc = "JCS GML";
    public static final String shp = "shp";
    public static final String shpDesc = "ESRI Shapefile";
    public static final String shx = "shx";
    public static final String shxDesc = "SHX";
    public static final String wkt = "wkt";
    public static final String wktDesc = "Well Known Text";
    public static final String wktaDesc = "Well Known Text (Show Attribute)";
    public static final String xml = "xml";
    public static final String xmlDesc = "XML";
    public static final FileFilter ALL_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return I18N.get("ui.GUIUtil.all-files");
        }
    };

    public static final String escapeHTML(String value, boolean escapeSpaces, boolean escapeNewlines) {
        if (value == null) {
            return null;
        }
        char[] content = new char[value.length()];
        value.getChars(0, value.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block36: for (char c : content) {
            switch (c) {
                case ' ': {
                    result.append(escapeSpaces ? "&#32;" : " ");
                    continue block36;
                }
                case '\n': {
                    result.append(escapeNewlines ? "<BR>" : "\n");
                    continue block36;
                }
                case '!': {
                    result.append("&#33;");
                    continue block36;
                }
                case '\"': {
                    result.append("&#34;");
                    continue block36;
                }
                case '#': {
                    result.append("&#35;");
                    continue block36;
                }
                case '$': {
                    result.append("&#36;");
                    continue block36;
                }
                case '%': {
                    result.append("&#37;");
                    continue block36;
                }
                case '&': {
                    result.append("&#38;");
                    continue block36;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block36;
                }
                case '(': {
                    result.append("&#40;");
                    continue block36;
                }
                case ')': {
                    result.append("&#41;");
                    continue block36;
                }
                case '*': {
                    result.append("&#42;");
                    continue block36;
                }
                case '+': {
                    result.append("&#43;");
                    continue block36;
                }
                case ',': {
                    result.append("&#44;");
                    continue block36;
                }
                case '-': {
                    result.append("&#45;");
                    continue block36;
                }
                case '.': {
                    result.append("&#46;");
                    continue block36;
                }
                case '/': {
                    result.append("&#47;");
                    continue block36;
                }
                case ':': {
                    result.append("&#58;");
                    continue block36;
                }
                case ';': {
                    result.append("&#59;");
                    continue block36;
                }
                case '<': {
                    result.append("&#60;");
                    continue block36;
                }
                case '=': {
                    result.append("&#61;");
                    continue block36;
                }
                case '>': {
                    result.append("&#62;");
                    continue block36;
                }
                case '?': {
                    result.append("&#63;");
                    continue block36;
                }
                case '@': {
                    result.append("&#64;");
                    continue block36;
                }
                case '[': {
                    result.append("&#91;");
                    continue block36;
                }
                case '\\': {
                    result.append("&#92;");
                    continue block36;
                }
                case ']': {
                    result.append("&#93;");
                    continue block36;
                }
                case '^': {
                    result.append("&#94;");
                    continue block36;
                }
                case '_': {
                    result.append("&#95;");
                    continue block36;
                }
                case '`': {
                    result.append("&#96;");
                    continue block36;
                }
                case '{': {
                    result.append("&#123;");
                    continue block36;
                }
                case '|': {
                    result.append("&#124;");
                    continue block36;
                }
                case '}': {
                    result.append("&#125;");
                    continue block36;
                }
                case '~': {
                    result.append("&#126;");
                    continue block36;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension(f);
    }

    public static Color alphaColor(ColorModel colorModel, int alpha) {
        return GUIUtil.alphaColor(RiwaJumpModelUtilities.colorByColorModel(colorModel), alpha);
    }

    public static Color alphaColor(Color color, int alpha) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void centre(Component componentToMove, Component componentToCentreOn) {
        Dimension componentToCentreOnSize = componentToCentreOn.getSize();
        int x = componentToCentreOn.getX() + (componentToCentreOnSize.width - componentToMove.getWidth()) / 2;
        int y = componentToCentreOn.getY() + (componentToCentreOnSize.height - componentToMove.getHeight()) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        componentToMove.setLocation(x, y);
    }

    @Deprecated
    public static void centreOnScreen(Component componentToMove) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - componentToMove.getWidth()) / 2;
        int y = (screenSize.height - componentToMove.getHeight()) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        componentToMove.setLocation(x, y);
    }

    public static void centreOnWindow(Component componentToMove) {
        GUIUtil.centre(componentToMove, SwingUtilities.windowForComponent(componentToMove));
    }

    public static void chooseGoodColumnWidths(JTable table) {
        int PADDING = 5;
        if (table.getModel().getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            double headerWidth = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, table.getModel().getColumnName(i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            double valueWidth = 10.0;
            try {
                valueWidth = table.getCellRenderer(0, i).getTableCellRendererComponent(table, table.getModel().getValueAt(0, i), false, false, 0, i).getPreferredSize().getWidth() + 5.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int width = Math.min(200, Math.max((int)headerWidth, (int)valueWidth));
            column.setPreferredWidth(width);
            column.setWidth(width);
        }
    }

    public static JFileChooser createJFileChooserWithExistenceChecking() {
        return new JFileChooser(){

            @Override
            public void approveSelection() {
                File[] files = GUIUtil.selectedFiles(this);
                if (files.length == 0) {
                    return;
                }
                for (File file : files) {
                    if (file.exists() || file.isFile()) continue;
                    return;
                }
                super.approveSelection();
            }
        };
    }

    public static JFileChooser createJFileChooserWithOverwritePrompting() {
        return new FileChooserWithOverwritePrompting();
    }

    public static void addGraphicsDeviceChangedListener(Container container, PropertyChangeListener listener) {
        container.addPropertyChangeListener("graphicsConfiguration", listener);
    }

    public static void handleThrowable(final Throwable t, final Component parent) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.error(t.getMessage(), t);
                    JOptionPane.showMessageDialog(parent, StringUtil.split(t.toString(), 80), "Exception", 0);
                }
            });
        }
        catch (Throwable t2) {
            LOG.error(t2.getMessage(), t2);
        }
    }

    public static void invokeOnEventThread(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
    }

    public static void invokeOnEventThreadLater(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    public static String nameWithoutExtension(File file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        return dotPosition < 0 ? name : name.substring(0, dotPosition);
    }

    public static void removeChoosableFileFilters(JFileChooser fc) {
        FileFilter[] filters;
        for (FileFilter filter : filters = fc.getChoosableFileFilters()) {
            fc.removeChoosableFileFilter(filter);
        }
    }

    public static FileFilter createFileFilter(final String description, final String[] extensions) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (String extension : extensions) {
                    if (!GUIUtil.getExtension(f).equalsIgnoreCase(extension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                ArrayList<CallSite> extensionStrings = new ArrayList<CallSite>();
                for (String extension : extensions) {
                    extensionStrings.add((CallSite)((Object)("*." + extension)));
                }
                return description + " (" + StringUtils.join(extensionStrings, (String)";") + ")";
            }
        };
    }

    public static Color toSimulatedTransparency(Color color) {
        return new Color(color.getRed() + (int)((double)((255 - color.getRed()) * (255 - color.getAlpha())) / 255.0), color.getGreen() + (int)((double)((255 - color.getGreen()) * (255 - color.getAlpha())) / 255.0), color.getBlue() + (int)((double)((255 - color.getBlue()) * (255 - color.getAlpha())) / 255.0));
    }

    public static String truncateString(String s, int maxLength) {
        if (s.length() < maxLength) {
            return s;
        }
        return s.substring(0, maxLength - 3) + "...";
    }

    public static Point2D subtract(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D multiply(Point2D v, double x) {
        return new Point2D.Double(v.getX() * x, v.getY() * x);
    }

    public static Transferable getContents(Clipboard clipboard) {
        try {
            return clipboard.getContents(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static double trueAscent(TextLayout layout) {
        return -layout.getBounds().getY();
    }

    public static ImageIcon resize(ImageIcon icon, int extent) {
        return HighDpiSupport.resizeImage((ImageIcon)icon, (int)extent, (int)extent);
    }

    public static ImageIcon createBlankImage(int width, int height) {
        return new ImageIcon(new BufferedImage(width, height, 2));
    }

    public static ImageIcon createSmallBlankImage() {
        return GUIUtil.createBlankImage(16, 16);
    }

    public static ImageIcon toSmallIcon(ImageIcon icon) {
        return GUIUtil.resize(icon, 16);
    }

    public static int swingThreadPriority() {
        int[] i = new int[1];
        try {
            GUIUtil.invokeOnEventThread(() -> {
                i[0] = Thread.currentThread().getPriority();
            });
        }
        catch (InvocationTargetException e) {
            Assert.shouldNeverReachHere();
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
            Thread.currentThread().interrupt();
        }
        return i[0];
    }

    public static void addInternalFrameListener(JDesktopPane pane, final InternalFrameListener listener) {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = pane.getAllFrames()) {
            frame.addInternalFrameListener(listener);
        }
        pane.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    ((JInternalFrame)e.getChild()).removeInternalFrameListener(listener);
                    ((JInternalFrame)e.getChild()).addInternalFrameListener(listener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    ((JInternalFrame)e.getChild()).removeInternalFrameListener(listener);
                }
            }
        });
    }

    public static DocumentListener toDocumentListener(final ActionListener listener) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                listener.actionPerformed(new ActionEvent(e, 0, e.toString()));
            }
        };
    }

    public static ListDataListener toListDataListener(final ActionListener listener) {
        return new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), 0, e.toString()));
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                listener.actionPerformed(null);
            }
        };
    }

    public static InternalFrameListener toInternalFrameListener(final ActionListener listener) {
        return new InternalFrameListener(){

            private void fireActionPerformed(InternalFrameEvent e) {
                listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.toString()));
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                this.fireActionPerformed(e);
            }
        };
    }

    public static Timer createRestartableSingleEventTimer(int delay, ActionListener listener) {
        Timer timer = new Timer(delay, listener);
        timer.setCoalesce(true);
        timer.setInitialDelay(delay);
        timer.setRepeats(false);
        return timer;
    }

    public static ValidatingTextField createSyncdTextField(JSlider s) {
        int columns = (int)Math.ceil(Math.log(s.getMaximum()) / Math.log(10.0));
        return GUIUtil.createSyncdTextField(s, columns);
    }

    public static ValidatingTextField createSyncdTextField(JSlider s, int columns) {
        ValidatingTextField t = new ValidatingTextField("" + s.getValue(), columns, 4, ValidatingTextField.INTEGER_VALIDATOR, new ValidatingTextField.CompositeCleaner(new ValidatingTextField.Cleaner[]{new ValidatingTextField.BlankCleaner("" + s.getMinimum()), new ValidatingTextField.MinIntCleaner(s.getMinimum()), new ValidatingTextField.MaxIntCleaner(s.getMaximum())}));
        GUIUtil.sync(s, t);
        GUIUtil.syncEnabledStates(s, t);
        return t;
    }

    public static void sync(final JSlider s, final ValidatingTextField t) {
        t.setText("" + s.getValue());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Boolean.TRUE.equals(changing[0])) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    t.setText("" + s.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        t.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                if (Boolean.TRUE.equals(changing[0])) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s.setValue(t.getInteger());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }
        });
    }

    public static void syncEnabledStates(final JComponent c1, final JComponent c2) {
        c2.setEnabled(c1.isEnabled());
        c1.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c2.setEnabled(c1.isEnabled());
            }
        });
        c2.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (c1.isEnabled() == c2.isEnabled()) {
                    return;
                }
                c1.setEnabled(c2.isEnabled());
            }
        });
    }

    public static void sync(final JSlider s1, final JSlider s2) {
        s2.setValue(s1.getValue());
        Assert.isTrue((s1.getMinimum() == s2.getMinimum() ? 1 : 0) != 0);
        Assert.isTrue((s1.getMaximum() == s2.getMaximum() ? 1 : 0) != 0);
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        s1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Boolean.TRUE.equals(changing[0])) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s2.setValue(s1.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        s2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Boolean.TRUE.equals(changing[0])) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    s1.setValue(s2.getValue());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static void sync(final JCheckBox c1, final JCheckBox c2) {
        c2.setSelected(c1.isSelected());
        final Boolean[] changing = new Boolean[]{Boolean.FALSE};
        c1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Boolean.TRUE.equals(changing[0])) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c2.setSelected(c1.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
        c2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changing[0] == Boolean.TRUE) {
                    return;
                }
                changing[0] = Boolean.TRUE;
                try {
                    c1.setSelected(c2.isSelected());
                }
                finally {
                    changing[0] = Boolean.FALSE;
                }
            }
        });
    }

    public static <E> List<E> items(JComboBox<E> comboBox) {
        ArrayList<E> items = new ArrayList<E>();
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            items.add(comboBox.getItemAt(i));
        }
        return items;
    }

    public static void setSelectedWithClick(JCheckBox checkBox, boolean selected) {
        checkBox.setSelected(!selected);
        checkBox.doClick();
    }

    public static void setLocation(Component componentToMove, Location location, Component other) {
        int deltaX = location.isFromRight() ? other.getWidth() - componentToMove.getWidth() - location.getX() : location.getX();
        int deltaY = location.isFromBottom() ? other.getHeight() - componentToMove.getHeight() - location.getY() : location.getY();
        Point p = new Point((int)other.getLocationOnScreen().getX() + deltaX, (int)other.getLocationOnScreen().getY() + deltaY);
        if (!(componentToMove instanceof Window)) {
            SwingUtilities.convertPointFromScreen(p, componentToMove.getParent());
        }
        componentToMove.setLocation(p);
    }

    public static void highlightForDebugging(JComponent component, Color color) {
        component.setBackground(color);
        component.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, color));
    }

    public static Component topCard(Container c) {
        Component[] components;
        Assert.isTrue((boolean)(c.getLayout() instanceof CardLayout));
        for (Component component : components = c.getComponents()) {
            if (!component.isVisible()) continue;
            return component;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static File[] selectedFiles(JFileChooser chooser) {
        File[] fileArray;
        if (chooser.getSelectedFiles().length == 0 && chooser.getSelectedFile() != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = chooser.getSelectedFile();
        } else {
            fileArray = chooser.getSelectedFiles();
        }
        return fileArray;
    }

    public static ImageIcon toDisabledIcon(ImageIcon icon) {
        return new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
    }

    public static Component getDescendantOfClass(Class<?> c, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component descendant;
            if (c.isInstance(container.getComponent(i))) {
                return container.getComponent(i);
            }
            if (!(container.getComponent(i) instanceof Container) || (descendant = GUIUtil.getDescendantOfClass(c, (Container)container.getComponent(i))) == null) continue;
            return descendant;
        }
        return null;
    }

    public static void dispose(JInternalFrame internalFrame, JDesktopPane desktopPane) {
        desktopPane.getDesktopManager().closeFrame(internalFrame);
        internalFrame.dispose();
    }

    public static Cursor createCursorFromIcon(Image iconImage) {
        ImageIcon icon = new ImageIcon(iconImage.getScaledInstance(HighDpiCursorSupport.I12, HighDpiCursorSupport.I12, 8));
        ImageIcon basicCursor = IconLoader.cursor((String)"basic-cursor.png");
        BufferedImage image = new BufferedImage(basicCursor.getIconWidth(), basicCursor.getIconHeight(), 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(basicCursor.getImage(), 0, 0, null);
        graphics.drawImage(icon.getImage(), HighDpiCursorSupport.I10, HighDpiCursorSupport.I10, null);
        return GUIUtil.createCursor(image, HighDpiCursorSupport.getMouseSize32HotSpot((int)0, (int)15));
    }

    public static Cursor createCursor(Image image, Point hotSpot) {
        return GUIUtil.createCursor(image, hotSpot, I18N.get("ui.GUIUtil.jump-workbench-custom-cursor"));
    }

    public static Cursor createCursor(Image image, Point hotSpot, String name) {
        if (null == image) {
            return Cursor.getDefaultCursor();
        }
        try {
            double scale = GUIUtil.getCursorReScale(image.getWidth(null));
            if (scale == 0.0) {
                return Cursor.getDefaultCursor();
            }
            if (scale == 1.0) {
                return Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, name);
            }
            LOG.warn("Attention. Cursor \"" + name + "\" is getting rescaled by factor " + scale + ". This leads to ugly mouse cursors.");
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point((int)Math.floor((double)hotSpot.x * scale), (int)Math.floor((double)hotSpot.y * scale)), name);
        }
        catch (Exception e) {
            LOG.error(String.format("cant create cursor %s, use default instead", name), (Throwable)e);
            return Cursor.getDefaultCursor();
        }
    }

    private static double getCursorReScale(int srcSize) {
        int _32pxScaled = srcSize;
        Dimension defaultScaledSize = new Dimension(_32pxScaled, _32pxScaled);
        Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(defaultScaledSize.width, defaultScaledSize.height);
        if (bestCursorSize.equals(new Dimension(0, 0))) {
            return 0.0;
        }
        double scale = (double)bestCursorSize.width / (double)defaultScaledSize.width;
        return scale;
    }

    public static JTextArea makeTabMoveFocus(JTextArea textArea) {
        textArea.setFocusTraversalKeys(0, new HashSet<KeyStroke>(Collections.singletonList(KeyStroke.getKeyStroke("TAB"))));
        textArea.setFocusTraversalKeys(1, new HashSet<KeyStroke>(Collections.singletonList(KeyStroke.getKeyStroke("shift TAB"))));
        return textArea;
    }

    public static void shrinkFont(JComponent component) {
        component.setFont(component.getFont().deriveFont((float)component.getFont().getSize() - 2.0f));
    }

    public static GridBagConstraints addGridBagComponent(Container cont, Component comp, GridBagLayout gbl, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        return GUIUtil.addGridBagComponent(cont, comp, gbl, gbc, gridx, gridy, gridwidth, gridheight, anchor, fill, insets);
    }

    public static GridBagConstraints addGridBagComponent(Container cont, Component comp, GridBagLayout gbl, GridBagConstraints gbc, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill, Insets insets) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.anchor = anchor;
        gbc.fill = fill;
        gbc.insets = insets;
        gbl.setConstraints(comp, gbc);
        cont.add(comp);
        return gbc;
    }

    public static DefaultFormatterFactory getNumberFormat(NumberFormat nformat) {
        NumberFormatter nf = new NumberFormatter(nformat);
        return new DefaultFormatterFactory(nf);
    }

    public static InputVerifier getTextLengthVerifier(final int length) {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JTextComponent tf = (JTextComponent)input;
                String str = tf.getText();
                return str.length() >= length;
            }
        };
    }

    public static class FileChooserWithOverwritePrompting
    extends JFileChooser {
        @Override
        public void approveSelection() {
            int response;
            if (GUIUtil.selectedFiles(this).length != 1) {
                return;
            }
            File selectedFile = this.selectedFile();
            if (selectedFile.exists() && !selectedFile.isFile()) {
                return;
            }
            if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(this, I18N.get("ui.GUIUtil.overwrite-file"), I18N.get("common.message"), 0)) != 0) {
                return;
            }
            super.approveSelection();
        }

        protected File selectedFile() {
            return GUIUtil.selectedFiles(this)[0];
        }
    }

    public static class Location {
        private final int x;
        private final int y;
        private final boolean fromRight;
        private final boolean fromBottom;

        public Location(int x, boolean fromRight, int y, boolean fromBottom) {
            this.x = x;
            this.y = y;
            this.fromRight = fromRight;
            this.fromBottom = fromBottom;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isFromBottom() {
            return this.fromBottom;
        }

        public boolean isFromRight() {
            return this.fromRight;
        }
    }
}

