/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.FlashOptions;
import com.vividsolutions.jump.workbench.ui.FlashStyle;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import lombok.Generated;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Flasher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Flasher.class);
    private static final String ID_FLASH_FEATURE = "FLASH_FEATURE";
    private Timer flashUpdater;
    private final Runnable rendererUpdate;

    Flasher(Runnable rendererUpdate) {
        this.rendererUpdate = rendererUpdate;
    }

    public void flash(FlashOptions options) {
        if (options == null || options.getStyleSupplier() == null) {
            log.error("Flashing requested but no flash options provided");
            return;
        }
        Runnable run = () -> this.restartFlashTimer(options);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void restartFlashTimer(FlashOptions options) {
        if (this.flashUpdater != null) {
            this.flashUpdater.stop();
        }
        this.flashUpdater = new Timer(0, e -> {
            FlashStyle style = options.getStyleSupplier().get();
            if (style == null) {
                this.removeFlashFeature();
                this.flashUpdater.stop();
            } else {
                this.updateFlashFeature(style);
            }
        });
        this.flashUpdater.setDelay(options.getDelayInMillis());
        this.flashUpdater.setCoalesce(false);
        this.flashUpdater.start();
    }

    private void updateFlashFeature(FlashStyle style) {
        Color fillColor = GUIUtil.alphaColor(style.getColor(), 125);
        GenericOverlayFeature flashFeature = new GenericOverlayFeature((Geometry)style.getGeometry(), style.getStroke(), style.getColor(), style.getStroke(), fillColor);
        GenericOverlayPlugin.addFeature(ID_FLASH_FEATURE, flashFeature);
        this.rendererUpdate.run();
    }

    private void removeFlashFeature() {
        GenericOverlayPlugin.removeFeature(ID_FLASH_FEATURE);
        this.rendererUpdate.run();
    }
}

