/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.FlashStyle;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class FlashOptions {
    public static final int DEFAULT_DELAY = 200;
    private final int delayInMillis;
    private final Supplier<FlashStyle> styleSupplier;

    public FlashOptions(int delayInMillis, Supplier<FlashStyle> styleSupplier) {
        this.delayInMillis = delayInMillis;
        this.styleSupplier = styleSupplier;
    }

    public int getDelayInMillis() {
        return this.delayInMillis;
    }

    public Supplier<FlashStyle> getStyleSupplier() {
        return this.styleSupplier;
    }

    public static FlashOptions createSingleFlash(int delayInMillis, FlashStyle style) {
        return new FlashOptions(delayInMillis, new SingleFlashStyleSupplier(style));
    }

    public static FlashOptions createKeyframedFlash(int delayInMillis, List<FlashStyle> styles) {
        return new FlashOptions(delayInMillis, new KeyframedFlashStyleSupplier(styles));
    }

    public static FlashOptions createKeyframedFlash(int delayInMillis, Stream<FlashStyle> styles) {
        return new FlashOptions(delayInMillis, new KeyframedFlashStyleSupplier(styles));
    }

    private static class SingleFlashStyleSupplier
    implements Supplier<FlashStyle> {
        private final FlashStyle style;
        private boolean flashed = false;

        public SingleFlashStyleSupplier(FlashStyle style) {
            this.style = style;
        }

        @Override
        public FlashStyle get() {
            if (this.flashed) {
                return null;
            }
            this.flashed = true;
            return this.style;
        }
    }

    private static class KeyframedFlashStyleSupplier
    implements Supplier<FlashStyle> {
        private final Iterator<FlashStyle> iterator;

        public KeyframedFlashStyleSupplier(List<FlashStyle> styles) {
            this.iterator = styles.iterator();
        }

        public KeyframedFlashStyleSupplier(Stream<FlashStyle> styles) {
            this.iterator = styles.iterator();
        }

        @Override
        public FlashStyle get() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }
    }
}

