/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class EditTransaction {
    private List<SimpleFeature> features;
    private List<Geometry> originalGeometries;
    private List<Geometry> proposedGeometries;
    private Layer layer;
    private String name;
    private boolean rollingBackInvalidEdits;
    public static final String ROLLING_BACK_INVALID_EDITS_KEY = EditTransaction.class.getName() + " - ROLLING_BACK_INVALID_EDITS";
    private final GeometryEditor editor = new GeometryEditor();
    private boolean allowAddingAndRemovingFeatures;
    private LayerViewPanelContext layerViewPanelContext;

    public EditTransaction(Collection<SimpleFeature> features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanel layerViewPanel) {
        this(features, name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanel.getContext());
    }

    public EditTransaction(Collection<SimpleFeature> features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanelContext layerViewPanelContext) {
        this.layerViewPanelContext = layerViewPanelContext;
        this.layer = layer;
        this.rollingBackInvalidEdits = rollingBackInvalidEdits;
        this.allowAddingAndRemovingFeatures = allowAddingAndRemovingFeatures;
        this.name = name;
        this.features = new ArrayList<SimpleFeature>(features);
        this.originalGeometries = this.geometryClones(features);
        this.proposedGeometries = this.geometryClones(features);
    }

    public static EditTransaction createTransactionOnSelection(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, LayerViewPanelContext layerViewPanelContext, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures) {
        Map<SimpleFeature, Geometry> featureToNewGeometryMap = EditTransaction.featureToNewGeometryMap(editor, selectionManagerProxy, layer);
        EditTransaction transaction = new EditTransaction(featureToNewGeometryMap.keySet(), name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanelContext);
        transaction.setGeometries(featureToNewGeometryMap);
        return transaction;
    }

    public static Map<SimpleFeature, Geometry> featureToNewGeometryMap(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, Layer layer) {
        HashMap<SimpleFeature, Geometry> featureToNewGeometryMap = new HashMap<SimpleFeature, Geometry>();
        for (SimpleFeature currFeature : selectionManagerProxy.getSelectionManager().getFeaturesWithSelectedItems(layer)) {
            SimpleFeature feature = FeatureUtil.cloneFeature((SimpleFeature)currFeature);
            Geometry newGeometry = (Geometry)((Geometry)feature.getDefaultGeometry()).clone();
            ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
            for (AbstractSelection selection : selectionManagerProxy.getSelectionManager().getSelections()) {
                selectedItems.addAll(selection.items(newGeometry, selection.getSelectedItemIndices(layer, feature)));
            }
            newGeometry = editor.edit(newGeometry, selectedItems);
            featureToNewGeometryMap.put(feature, newGeometry);
        }
        return featureToNewGeometryMap;
    }

    public Geometry getGeometry(int i) {
        return this.proposedGeometries.get(i);
    }

    public Geometry getGeometry(SimpleFeature feature) {
        return this.getGeometry(this.features.indexOf(feature));
    }

    public void setGeometry(SimpleFeature feature, Geometry geometry) {
        this.setGeometry(this.features.indexOf(feature), geometry);
    }

    public void setGeometries(Map<SimpleFeature, Geometry> featureToGeometryMap) {
        for (int i = 0; i < this.features.size(); ++i) {
            Geometry geometry = featureToGeometryMap.get(this.features.get(i));
            if (geometry == null) continue;
            this.setGeometry(i, geometry);
        }
    }

    public void setGeometry(int i, Geometry geometry) {
        this.proposedGeometries.set(i, this.editor.removeRepeatedPoints(geometry));
    }

    public boolean commit() {
        return EditTransaction.commit(Collections.singleton(this));
    }

    public static boolean commit(Collection<EditTransaction> editTransactions) {
        return EditTransaction.commit(editTransactions, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean commit(Collection<EditTransaction> editTransactions, SuccessAction successAction) {
        if (editTransactions.isEmpty()) {
            return true;
        }
        final ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
        for (EditTransaction editTransaction : editTransactions) {
            editTransaction.clearEnvelopeCaches();
            if (!editTransaction.proposedGeometriesValid()) {
                if (editTransaction.rollingBackInvalidEdits) {
                    editTransaction.layerViewPanelContext.warnUser(I18N.get("ui.EditTransaction.the-geometry-is-invalid-cancelled"));
                    return false;
                }
                editTransaction.layerViewPanelContext.warnUser(I18N.get("ui.EditTransaction.the-new-geometry-is-invalid"));
            }
            commands.add(editTransaction.createInternalCommand());
        }
        successAction.run();
        UndoableCommand command = new UndoableCommand(((UndoableCommand)commands.iterator().next()).getName()){

            @Override
            public void execute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.unexecute();
                }
            }
        };
        command.execute();
        boolean bolStopUndo = false;
        UndoableEditReceiver undo = editTransactions.iterator().next().layer.getLayerManager().getUndoableEditReceiver();
        try {
            if (!undo.isReceiving()) {
                bolStopUndo = true;
                undo.startReceiving();
            }
            undo.receive(command.toUndoableEdit());
        }
        finally {
            if (bolStopUndo) {
                undo.stopReceiving();
            }
        }
        return true;
    }

    public boolean commit(SuccessAction successAction) {
        return EditTransaction.commit(Collections.singleton(this), successAction);
    }

    public void clearEnvelopeCaches() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry obj = this.proposedGeometries.get(i);
            if (obj == null) continue;
            Geometry proposedGeometry = obj;
            proposedGeometry.geometryChanged();
        }
    }

    public boolean proposedGeometriesValid() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry proposedGeometry;
            Geometry obj = this.proposedGeometries.get(i);
            if (obj == null || (proposedGeometry = obj).isEmpty() || proposedGeometry.isValid()) continue;
            return false;
        }
        return true;
    }

    public UndoableCommand createCommand() {
        return new UndoableCommand(this.name){

            @Override
            public void execute() {
                EditTransaction.this.clearEnvelopeCaches();
                if (!EditTransaction.this.proposedGeometriesValid()) {
                    if (EditTransaction.this.rollingBackInvalidEdits) {
                        EditTransaction.this.layerViewPanelContext.warnUser(I18N.get("ui.EditTransaction.the-geometry-is-invalid-cancelled"));
                        return;
                    }
                    EditTransaction.this.layerViewPanelContext.warnUser(I18N.get("ui.EditTransaction.the-new-geometry-is-invalid"));
                }
                EditTransaction.this.changeGeometries(EditTransaction.this.proposedGeometries, EditTransaction.this.originalGeometries, EditTransaction.this.layer);
            }

            @Override
            public void unexecute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.originalGeometries, EditTransaction.this.proposedGeometries, EditTransaction.this.layer);
            }
        };
    }

    protected UndoableCommand createInternalCommand() {
        return new UndoableCommand(this.name){

            @Override
            public void execute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.proposedGeometries, EditTransaction.this.originalGeometries, EditTransaction.this.layer);
            }

            @Override
            public void unexecute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.originalGeometries, EditTransaction.this.proposedGeometries, EditTransaction.this.layer);
            }
        };
    }

    private List<Geometry> geometryClones(Collection<SimpleFeature> features) {
        ArrayList<Geometry> geometryClones = new ArrayList<Geometry>();
        for (SimpleFeature feature : features) {
            if (feature.getDefaultGeometry() != null) {
                geometryClones.add((Geometry)((Geometry)feature.getDefaultGeometry()).clone());
                continue;
            }
            geometryClones.add(null);
        }
        return geometryClones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeGeometries(List<Geometry> newGeometries, List<Geometry> oldGeometries, Layer layer) {
        boolean bolUseDefaultFeature = false;
        if (layer instanceof AbstractCadLayer) {
            AbstractCadLayer abstractCadLayer = (AbstractCadLayer)layer;
            bolUseDefaultFeature = abstractCadLayer.getUseDefaultFeature();
            abstractCadLayer.setUseDefaultFeature(false);
        }
        try {
            ArrayList<SimpleFeature> modifiedFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> featuresToAdd = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> featuresToRemove = new ArrayList<SimpleFeature>();
            for (int i = 0; i < this.size(); ++i) {
                SimpleFeature feature = this.features.get(i);
                Geometry oldGeometry = oldGeometries.get(i);
                Geometry newGeometry = newGeometries.get(i);
                if (this.allowAddingAndRemovingFeatures && oldGeometry.isEmpty() && !newGeometry.isEmpty()) {
                    featuresToAdd.add(feature);
                    continue;
                }
                if (this.allowAddingAndRemovingFeatures && newGeometry.isEmpty() && !oldGeometry.isEmpty()) {
                    featuresToRemove.add(feature);
                    continue;
                }
                modifiedFeatures.add(feature);
                feature.setDefaultGeometry((Object)newGeometry);
            }
            if (!featuresToRemove.isEmpty()) {
                layer.editFeature(featuresToRemove, 3);
            }
            if (!featuresToAdd.isEmpty()) {
                layer.editFeature(featuresToAdd, 1);
            }
            if (!modifiedFeatures.isEmpty()) {
                layer.editFeature(modifiedFeatures, 2);
            }
        }
        catch (IllegalAttributeException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
        finally {
            try {
                if (layer instanceof AbstractCadLayer) {
                    AbstractCadLayer abstractCadLayer = (AbstractCadLayer)layer;
                    abstractCadLayer.setUseDefaultFeature(bolUseDefaultFeature);
                }
            }
            catch (Exception exception) {}
        }
    }

    public int size() {
        return this.features.size();
    }

    public SimpleFeature getFeature(int i) {
        return this.features.get(i);
    }

    public void createFeature(SimpleFeature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        if (feature.getDefaultGeometry() == null) {
            throw new RuntimeException(I18N.get("ui.EditTransaction.the-resulting-geometry-is-invalid"));
        }
        this.features.add(feature);
        this.originalGeometries.add((Geometry)new Point(null, null, 0));
        this.proposedGeometries.add((Geometry)((Geometry)feature.getDefaultGeometry()).clone());
    }

    public void deleteFeature(SimpleFeature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        if (feature.getDefaultGeometry() == null) {
            throw new RuntimeException(I18N.get("ui.EditTransaction.the-resulting-geometry-is-invalid"));
        }
        this.features.add(feature);
        this.originalGeometries.add((Geometry)((Geometry)feature.getDefaultGeometry()).clone());
        this.proposedGeometries.add((Geometry)new Point(null, null, 0));
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static int emptyGeometryCount(Collection<EditTransaction> transactions) {
        int count = 0;
        for (EditTransaction transaction : transactions) {
            count += transaction.getEmptyGeometryCount();
        }
        return count;
    }

    private int getEmptyGeometryCount() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getGeometry(i) != null && !this.getGeometry(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static interface SelectionEditor {
        public Geometry edit(Geometry var1, Collection<Geometry> var2);
    }

    public static interface SuccessAction {
        public void run();
    }
}

