/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.type.Types;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class EditAttTransaction {
    private final List<SimpleFeature> features;
    private final Layer layer;
    private final String name;
    private final LayerViewPanelContext layerViewPanelContext;
    private final Map<Object, Object> mapAttributes = new HashMap<Object, Object>();
    private final SimpleFeatureType fType;

    public EditAttTransaction(Collection<SimpleFeature> features, String name, Layer layer, LayerViewPanel layerViewPanel) {
        this(features, name, layer, layerViewPanel.getContext());
    }

    public EditAttTransaction(Collection<SimpleFeature> features, String name, Layer layer, LayerViewPanelContext layerViewPanelContext) {
        this.layerViewPanelContext = layerViewPanelContext;
        this.layer = layer;
        this.name = name;
        this.features = new ArrayList<SimpleFeature>(features);
        this.fType = layer.getFeatureType();
    }

    public static EditAttTransaction createTransactionOnSelection(SelectionManagerProxy selectionManagerProxy, LayerViewPanelContext layerViewPanelContext, String name, Layer layer) {
        EditAttTransaction transaction = new EditAttTransaction(selectionManagerProxy.getSelectionManager().getFeaturesWithSelectedItems(layer), name, layer, layerViewPanelContext);
        return transaction;
    }

    public void addAttribute(String strAttName, Object objAttValue) {
        this.mapAttributes.put(strAttName, objAttValue);
    }

    public Object getAttribute(String strAttName) {
        return this.mapAttributes.get(strAttName);
    }

    public void removeAttribute(String strAttName) {
        this.mapAttributes.remove(strAttName);
    }

    public boolean commit() {
        return EditAttTransaction.commit(Collections.singleton(this));
    }

    public static boolean commit(Collection<EditAttTransaction> editTransactions) {
        return EditAttTransaction.commit(editTransactions, null);
    }

    public static boolean commit(Collection<EditAttTransaction> editTransactions, SuccessAction successAction) {
        return EditAttTransaction.commit(editTransactions, successAction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean commit(Collection<EditAttTransaction> editTransactions, SuccessAction successAction, boolean add2UndoableEditReceiver) {
        if (editTransactions.isEmpty()) {
            return true;
        }
        final ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
        for (EditAttTransaction editTransaction : editTransactions) {
            if (!editTransaction.proposedAttributesValid()) {
                editTransaction.layerViewPanelContext.warnUser(I18N.get("ui.EditAttTransaction.invalid-cancel"));
                return false;
            }
            commands.add(editTransaction.createCommand());
        }
        if (successAction != null) {
            successAction.run();
        }
        UndoableCommand command = new UndoableCommand(((UndoableCommand)commands.iterator().next()).getName()){

            @Override
            public void execute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.unexecute();
                }
            }
        };
        command.execute();
        if (add2UndoableEditReceiver) {
            boolean bolStopUndo = false;
            UndoableEditReceiver undo = editTransactions.iterator().next().layer.getLayerManager().getUndoableEditReceiver();
            try {
                if (!undo.isReceiving()) {
                    bolStopUndo = true;
                    undo.startReceiving();
                }
                undo.receive(command.toUndoableEdit());
            }
            finally {
                if (bolStopUndo) {
                    undo.stopReceiving();
                }
            }
        }
        return true;
    }

    public boolean commit(SuccessAction successAction) {
        return EditAttTransaction.commit(Collections.singleton(this), successAction);
    }

    public boolean proposedAttributesValid() {
        Iterator<Object> iAtt = this.mapAttributes.keySet().iterator();
        while (iAtt.hasNext()) {
            String strAttName = iAtt.next().toString();
            if (this.fType.indexOf(strAttName) != -1) continue;
            return false;
        }
        return true;
    }

    public UndoableCommand createCommand() {
        UndoableCommand command = new UndoableCommand(this.name){
            private List<Map<Object, Object>> oldAtts;
            {
                this.oldAtts = null;
            }

            @Override
            public void execute() {
                this.oldAtts = EditAttTransaction.this.changeAttributes(EditAttTransaction.this.features);
            }

            @Override
            public void unexecute() {
                try {
                    ArrayList<SimpleFeature> modifiedFeatures = new ArrayList<SimpleFeature>(EditAttTransaction.this.features.size());
                    for (int i = 0; i < EditAttTransaction.this.features.size(); ++i) {
                        SimpleFeature feature = EditAttTransaction.this.features.get(i);
                        Map<Object, Object> mapOldAtts = this.oldAtts.get(i);
                        Iterator<Object> iAtt = mapOldAtts.keySet().iterator();
                        while (iAtt.hasNext()) {
                            String strAttName = iAtt.next().toString();
                            Object objAtt = Types.parse((AttributeDescriptor)feature.getFeatureType().getDescriptor(strAttName), (Object)mapOldAtts.get(strAttName));
                            feature.setAttribute(strAttName, objAtt);
                        }
                        modifiedFeatures.add(feature);
                    }
                    if (!modifiedFeatures.isEmpty()) {
                        EditAttTransaction.this.layer.editFeature(modifiedFeatures, 2);
                    }
                }
                catch (IllegalAttributeException e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                }
            }
        };
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<Object, Object>> changeAttributes(List<SimpleFeature> lstFeatures) {
        ArrayList<SimpleFeature> modifiedFeatures = new ArrayList<SimpleFeature>(lstFeatures.size());
        ArrayList<Map<Object, Object>> oldAtts = new ArrayList<Map<Object, Object>>();
        try {
            for (int i = 0; i < lstFeatures.size(); ++i) {
                SimpleFeature feature = lstFeatures.get(i);
                modifiedFeatures.add(feature);
                HashMap<String, Object> mapOldAtts = new HashMap<String, Object>();
                Iterator<Object> iAtt = this.mapAttributes.keySet().iterator();
                while (iAtt.hasNext()) {
                    String strAttName = iAtt.next().toString();
                    mapOldAtts.put(strAttName, feature.getAttribute(strAttName));
                    Object objAtt = Types.parse((AttributeDescriptor)feature.getFeatureType().getDescriptor(strAttName), (Object)this.mapAttributes.get(strAttName));
                    feature.setAttribute(strAttName, objAtt);
                }
                oldAtts.add(mapOldAtts);
            }
            if (!modifiedFeatures.isEmpty()) {
                this.layer.editFeature(modifiedFeatures, 2);
            }
        }
        catch (IllegalAttributeException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
        return oldAtts;
    }

    public int size() {
        return this.features.size();
    }

    public SimpleFeature getFeature(int i) {
        return this.features.get(i);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static interface SuccessAction {
        public void run();
    }
}

