/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.jidesoft.swing.JideButton;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableStateListener;
import com.vividsolutions.jump.workbench.ui.DesktopPanelTabPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.components.CloseablePanel;
import com.vividsolutions.jump.workbench.ui.components.UndockablePanel;
import com.vividsolutions.jump.workbench.ui.components.dnd.DnDTabbedPane;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.OverviewPanel;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToScalePlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.util.Assert;

public class DesktopPanel
extends JPanel
implements EnableStateListener,
PropertyChangeListener {
    private static final ImageIcon ICON_CLOSE = IconLoader.svgIcon((String)"common_close.svg", (int)9);
    private static final ImageIcon ICON_LEFT = IconLoader.svgIcon((String)"collapse_left.svg", (int)9);
    private static final ImageIcon ICON_RIGHT = IconLoader.svgIcon((String)"collapse_right.svg", (int)9);
    private static final String TOOLTIP_CLOSE = I18N.get("ui.DesktopPanel.close-tooltip");
    private static final String TOOLTIP_EXPAND = I18N.get("ui.DesktopPanel.expand-tooltip");
    private static final String TOOLTIP_COLLAPSE = I18N.get("ui.DesktopPanel.collapse-tooltip");
    private static final int DIVIDER_SIZE = 5;
    private static final int MIN_BOTTOM_DIVIDER_HEIGHT = 300;
    private final ArrayList<ActionListener> lstTabsVisibleListeners = new ArrayList();
    private final ArrayList<ActionListener> lstTabsVisibleListenersLeft = new ArrayList();
    private final ArrayList<ActionListener> lstTabsVisibleListenersBottom = new ArrayList();
    private boolean bolSplitPos = false;
    private boolean bolTabsVisibleRight = true;
    private boolean bolTabsVisibleLeft = true;
    private boolean bolTabsVisibleBottom = false;
    private String[] arrScales = null;
    private boolean bolBlockScaleEvent = false;
    private JToolBar leftCollapsedToolBar;
    private JToolBar rightCollapsedToolBar;
    private final String uniqueBottomPanelBlackboardKey = "BOTTOM";
    private JButton butClose;
    private JButton butCloseLeft;
    private JComboBox<String> cmbScale;
    private JDesktopPane desktopPane;
    private DnDTabbedPane dndTabbedPane;
    private Box.Filler filler;
    private JSplitPane jSplitPane;
    private JSplitPane jSplitPaneBottom;
    private JSplitPane jSplitPaneLeft;
    private JPanel pnlAtt;
    private JPanel pnlModule;
    private OverviewPanel pnlOverview;
    private JPanel tabPanel;
    private JPanel tabPanelLeft;
    private JTabbedPane tabbedPane;
    private JTabbedPane tabbedPaneLeft;
    private JToolBar tbaLeft;
    private JToolBar tbaRight;
    private UndockablePanel undockablePanel;

    public DesktopPanel() {
        this.initComponents();
        this.desktopPane.setDesktopManager(new DefaultDesktopManager());
        this.init();
    }

    private JToolBar createCollapsableSideBar(JTabbedPane targetTabPane, ImageIcon expanderIcon, Consumer<Boolean> visibilitySwitcher) {
        JButton expander = new JButton(expanderIcon);
        expander.setMargin(new Insets(4, 5, 4, 5));
        expander.addActionListener(e -> visibilitySwitcher.accept(true));
        expander.setToolTipText(TOOLTIP_EXPAND);
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        final Runnable updateCollapsedBar = () -> {
            toolBar.removeAll();
            toolBar.add(expander);
            int idx = 0;
            while (idx < targetTabPane.getTabCount()) {
                JideButton showPaneButton = new JideButton(targetTabPane.getTitleAt(idx));
                showPaneButton.setOrientation(1);
                showPaneButton.setEnabled(targetTabPane.getComponentAt(idx).isEnabled());
                showPaneButton.setMargin(new Insets(4, 5, 4, 5));
                int i = idx++;
                showPaneButton.addActionListener(e -> {
                    targetTabPane.setSelectedIndex(i);
                    visibilitySwitcher.accept(true);
                });
                toolBar.addSeparator();
                toolBar.add((Component)showPaneButton);
            }
        };
        final PropertyChangeListener enabledListener = e -> updateCollapsedBar.run();
        targetTabPane.addContainerListener(new ContainerAdapter(this){

            @Override
            public void componentAdded(ContainerEvent e) {
                e.getChild().addPropertyChangeListener("enabled", enabledListener);
                updateCollapsedBar.run();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                e.getChild().removePropertyChangeListener("enabled", enabledListener);
                updateCollapsedBar.run();
            }
        });
        return toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.butClose.setToolTipText(TOOLTIP_COLLAPSE);
        this.butCloseLeft.setToolTipText(TOOLTIP_COLLAPSE);
        this.setBottomTabsVisible(false);
        this.butClose.setIcon(ICON_RIGHT);
        this.butCloseLeft.setIcon(ICON_LEFT);
        String strMapScale = I18N.get("ui.DesktopPanel.map-scale");
        String strChooseScale = I18N.get("ui.DesktopPanel.choose-scale") + "...";
        this.arrScales = I18N.get("ui.DesktopPanel.scales").split(",");
        this.bolBlockScaleEvent = true;
        try {
            this.cmbScale.addItem(strMapScale);
            this.cmbScale.addItem(strChooseScale);
            for (String arrScale : this.arrScales) {
                this.cmbScale.addItem("1 : " + arrScale);
            }
        }
        finally {
            this.bolBlockScaleEvent = false;
        }
        this.rightCollapsedToolBar = this.createCollapsableSideBar(this.tabbedPane, ICON_LEFT, this::setRightTabsVisible);
        this.leftCollapsedToolBar = this.createCollapsableSideBar(this.tabbedPaneLeft, ICON_RIGHT, this::setLeftTabsVisible);
    }

    @Override
    public void updateEnabledState() {
        this.updateEnabledStateOfPane(this.tabbedPane);
        this.updateEnabledStateOfPane(this.tabbedPaneLeft);
        this.updateEnabledStateOfPane(this.dndTabbedPane);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DOCK_PANEL".equals(evt.getPropertyName())) {
            this.jSplitPaneBottom.setBottomComponent(this.undockablePanel);
        } else if ("CLOSE_PANEL".equals(evt.getPropertyName())) {
            this.setBottomTabsVisible(false);
        }
    }

    private UndockablePanel getUndockablePanel() {
        if (this.undockablePanel == null) {
            String title = String.format("%s / %s", I18N.get("ui.plugin.ViewAttributesPlugIn.attributes"), I18N.get("ui.InfoPanel.object-information-plural"));
            this.undockablePanel = new UndockablePanel(title, this, "BOTTOM");
            this.undockablePanel.add(this.dndTabbedPane);
        }
        return this.undockablePanel;
    }

    private void updateEnabledStateOfPane(JTabbedPane pane) {
        for (int i = 0; i < pane.getTabCount(); ++i) {
            Component comp = pane.getComponentAt(i);
            if (comp instanceof CloseablePanel) {
                comp = ((CloseablePanel)comp).getComponent();
            }
            if (!(comp instanceof DesktopPanelTabPanel)) continue;
            ((DesktopPanelTabPanel)((Object)comp)).updateEnabledState();
        }
    }

    public void addRightTabsVisibleListener(ActionListener listener) {
        if (!this.lstTabsVisibleListeners.contains(listener)) {
            this.lstTabsVisibleListeners.add(listener);
        }
    }

    private void fireRightTabsVisibilityChanged() {
        ActionEvent evt = new ActionEvent(this, 1, "" + this.bolTabsVisibleRight);
        for (ActionListener listener : this.lstTabsVisibleListeners) {
            listener.actionPerformed(evt);
        }
    }

    public void addLeftTabsVisibleListener(ActionListener listener) {
        if (!this.lstTabsVisibleListenersLeft.contains(listener)) {
            this.lstTabsVisibleListenersLeft.add(listener);
        }
    }

    private void fireLeftTabsVisibilityChanged() {
        ActionEvent evt = new ActionEvent(this, 1, "" + this.bolTabsVisibleLeft);
        for (ActionListener listener : this.lstTabsVisibleListenersLeft) {
            listener.actionPerformed(evt);
        }
    }

    public void addBottomTabsVisibleListener(ActionListener listener) {
        if (!this.lstTabsVisibleListenersBottom.contains(listener)) {
            this.lstTabsVisibleListenersBottom.add(listener);
        }
    }

    private void fireBottomTabsVisibilityChanged() {
        ActionEvent evt = new ActionEvent(this, 1, "" + this.bolTabsVisibleBottom);
        for (ActionListener listener : this.lstTabsVisibleListenersBottom) {
            listener.actionPerformed(evt);
        }
    }

    public boolean getRightTabsVisible() {
        return this.bolTabsVisibleRight;
    }

    public void setRightTabsVisible(boolean bolTabsVisible) {
        this.bolTabsVisibleRight = bolTabsVisible;
        if (this.bolTabsVisibleRight) {
            this.jSplitPane.setDividerSize(5);
            this.jSplitPane.setRightComponent(this.tabPanel);
        } else {
            this.jSplitPane.setDividerSize(0);
            this.jSplitPane.setRightComponent(this.rightCollapsedToolBar);
        }
        this.setDefaultRightDividerLocation();
        this.fireRightTabsVisibilityChanged();
    }

    public boolean getLeftTabsVisible() {
        return this.bolTabsVisibleLeft;
    }

    public void setLeftTabsVisible(boolean bolTabsVisible) {
        this.bolTabsVisibleLeft = bolTabsVisible;
        if (this.bolTabsVisibleLeft) {
            this.jSplitPaneLeft.setDividerSize(5);
            this.jSplitPaneLeft.setLeftComponent(this.tabPanelLeft);
        } else {
            this.jSplitPaneLeft.setDividerSize(0);
            this.jSplitPaneLeft.setLeftComponent(this.leftCollapsedToolBar);
        }
        this.setDefaultLeftDividerLocation();
        this.fireLeftTabsVisibilityChanged();
    }

    public boolean getBottomTabsVisible() {
        return this.bolTabsVisibleBottom;
    }

    public void setBottomTabsVisible(boolean bolTabsVisible) {
        this.bolTabsVisibleBottom = bolTabsVisible;
        if (this.bolTabsVisibleBottom) {
            this.setDefaultBottomDividerLocation();
            this.jSplitPaneBottom.setDividerSize(5);
        } else {
            this.jSplitPaneBottom.setDividerSize(0);
            this.jSplitPaneBottom.setDividerLocation(1.0);
        }
        this.fireBottomTabsVisibilityChanged();
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public JTabbedPane getRightTabbedPane() {
        return this.tabbedPane;
    }

    public JTabbedPane getLeftTabbedPane() {
        return this.tabbedPaneLeft;
    }

    public JTabbedPane getBottomTabbedPane() {
        return this.dndTabbedPane;
    }

    public OverviewPanel getOverviewPanel() {
        return this.pnlOverview;
    }

    public JComponent getNullOrTabRight(JComponent content) {
        return this.getNullOrTabbedPane(content, this.getRightTabbedPane());
    }

    public JComponent getNullOrTabLeft(JComponent content) {
        return this.getNullOrTabbedPane(content, this.getLeftTabbedPane());
    }

    public JComponent getNullOrTabBottom(JComponent content) {
        return this.getNullOrTabbedPane(content, this.getBottomTabbedPane());
    }

    public JComponent getNullOrTabbedPane(JComponent component, JTabbedPane tabbedPane) {
        for (int i = 0; i < tabbedPane.getComponentCount(); ++i) {
            CloseablePanel closeablePanel;
            Component comp = tabbedPane.getComponent(i);
            if (comp == component) {
                return component;
            }
            if (!(comp instanceof CloseablePanel) || (closeablePanel = (CloseablePanel)tabbedPane.getComponent(i)).getComponent() != component) continue;
            return closeablePanel;
        }
        return null;
    }

    public boolean hasPane(JComponent content) {
        return this.getNullOrTabRight(content) != null || this.getNullOrTabLeft(content) != null || this.getNullOrTabBottom(content) != null;
    }

    public void selectPane(JComponent content) {
        JComponent contentResult = this.getNullOrTabRight(content);
        if (contentResult != null) {
            this.getRightTabbedPane().setSelectedComponent(contentResult);
        }
        if ((contentResult = this.getNullOrTabLeft(content)) != null) {
            this.getLeftTabbedPane().setSelectedComponent(contentResult);
        }
        if ((contentResult = this.getNullOrTabBottom(content)) != null) {
            this.getBottomTabbedPane().setSelectedComponent(contentResult);
        }
    }

    public void removePane(JComponent content) {
        try {
            GUIUtil.invokeOnEventThreadLater(() -> {
                JComponent contentResult = this.getNullOrTabRight(content);
                if (contentResult != null) {
                    this.getRightTabbedPane().remove(contentResult);
                }
                if ((contentResult = this.getNullOrTabLeft(content)) != null) {
                    this.getLeftTabbedPane().remove(contentResult);
                }
                if ((contentResult = this.getNullOrTabBottom(content)) != null) {
                    this.getBottomTabbedPane().remove(contentResult);
                }
            });
        }
        catch (Exception e) {
            WorkbenchContext.getFrame().handleThrowable(e);
        }
    }

    private void addCloseableTabPane(String title, String name, JComponent content, ActionListener closeAction, JInternalFrame frmLinked, JTabbedPane tabbedPane2Add) {
        final CloseablePanel closeablePanel = new CloseablePanel();
        closeablePanel.setTitle(name);
        closeablePanel.setComponent(content);
        InternalFrameAdapter taskCloseListener = new InternalFrameAdapter(this){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                closeablePanel.executeCloseActions();
            }
        };
        ActionListener closeActionInternal = evt -> {
            tabbedPane2Add.remove(closeablePanel);
            if (closeAction != null) {
                closeAction.actionPerformed(evt);
            }
            if (frmLinked != null) {
                frmLinked.removeInternalFrameListener(taskCloseListener);
            }
        };
        closeablePanel.assignCloseAction(closeActionInternal);
        tabbedPane2Add.add(title, closeablePanel);
        tabbedPane2Add.setSelectedComponent(closeablePanel);
        if (frmLinked != null) {
            frmLinked.addInternalFrameListener(taskCloseListener);
        }
    }

    private void addUndockablePanel(String title, JComponent content, JInternalFrame frmLinked, final JTabbedPane tabbedPane2Add) {
        tabbedPane2Add.add(title, content);
        tabbedPane2Add.setSelectedComponent(content);
        if (frmLinked != null) {
            InternalFrameAdapter taskCloseListener = new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    DesktopPanel.this.setBottomTabsVisible(false);
                    tabbedPane2Add.removeAll();
                }
            };
            frmLinked.addInternalFrameListener(taskCloseListener);
        }
    }

    public void addRightPane(String title, String name, JComponent content, ActionListener closeAction, JInternalFrame frmLinked) {
        this.addCloseableTabPane(title, name, content, closeAction, frmLinked, this.getRightTabbedPane());
    }

    public void addLeftPane(String title, String name, JComponent content, ActionListener closeAction, JInternalFrame frmLinked) {
        this.addCloseableTabPane(title, name, content, closeAction, frmLinked, this.getLeftTabbedPane());
    }

    public void addBottomPane(String title, String name, JComponent content, ActionListener closeAction, JInternalFrame frmLinked) {
        try {
            GUIUtil.invokeOnEventThreadLater(() -> {
                this.showUndockedPanel();
                this.addUndockablePanel(title, content, frmLinked, this.getBottomTabbedPane());
                if (!this.getBottomTabsVisible()) {
                    this.setBottomTabsVisible(true);
                }
                if (this.undockablePanel.getHeight() < 200) {
                    this.jSplitPaneBottom.setDividerLocation(this.jSplitPaneBottom.getHeight() - 300);
                }
            });
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
        }
    }

    public void showUndockedPanel() {
        boolean isPanelUndocked = PersistentBlackboardPlugIn.get().get("BOTTOM_DRAG_WINDOW_UNDOCKED", false);
        if (isPanelUndocked) {
            this.undockablePanel.showUndockedFrame(isPanelUndocked);
        }
    }

    public void setDefaultRightDividerLocation() {
        this.jSplitPane.setDividerLocation(-1);
    }

    public void setDefaultLeftDividerLocation() {
        this.jSplitPaneLeft.setDividerLocation(-1);
    }

    public void setDefaultBottomDividerLocation() {
        if (this.bolTabsVisibleBottom) {
            this.jSplitPaneBottom.setDividerLocation(this.jSplitPaneBottom.getHeight() - 300);
        } else {
            this.jSplitPaneBottom.setDividerLocation(1.0);
        }
    }

    private void initComponents() {
        this.dndTabbedPane = new DnDTabbedPane();
        this.jSplitPane = new JSplitPane();
        this.pnlModule = new JPanel();
        this.jSplitPaneLeft = new JSplitPane();
        this.tabPanelLeft = new JPanel();
        this.tbaLeft = new JToolBar();
        this.butCloseLeft = new JButton();
        this.cmbScale = new JComboBox();
        this.tabbedPaneLeft = new JTabbedPane();
        this.pnlOverview = new OverviewPanel();
        this.pnlAtt = new JPanel();
        this.jSplitPaneBottom = new JSplitPane();
        this.desktopPane = new JDesktopPane();
        this.undockablePanel = this.getUndockablePanel();
        this.tabPanel = new JPanel();
        this.tbaRight = new JToolBar();
        this.filler = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.butClose = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.dndTabbedPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DesktopPanel.this.dndTabbedPanePropertyChange(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jSplitPane.setResizeWeight(1.0);
        this.pnlModule.setLayout(new BorderLayout());
        this.jSplitPaneLeft.setDividerLocation(215);
        this.jSplitPaneLeft.setCursor(new Cursor(0));
        this.tabPanelLeft.setMinimumSize(new Dimension(225, 10));
        this.tabPanelLeft.setPreferredSize(new Dimension(225, 10));
        this.tabPanelLeft.setLayout(new GridBagLayout());
        this.butCloseLeft.setHorizontalTextPosition(0);
        this.butCloseLeft.setIconTextGap(0);
        this.butCloseLeft.setMargin(new Insets(4, 5, 4, 5));
        this.butCloseLeft.setVerticalTextPosition(3);
        this.butCloseLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopPanel.this.butCloseLeftActionPerformed(evt);
            }
        });
        this.tbaLeft.add(this.butCloseLeft);
        this.cmbScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopPanel.this.cmbScale_onActionPerformed(evt);
            }
        });
        this.tbaLeft.add(this.cmbScale);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tabPanelLeft.add((Component)this.tbaLeft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tabPanelLeft.add((Component)this.tabbedPaneLeft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.tabPanelLeft.add((Component)this.pnlOverview, gridBagConstraints);
        this.jSplitPaneLeft.setLeftComponent(this.tabPanelLeft);
        this.pnlAtt.setLayout(new BorderLayout());
        this.jSplitPaneBottom.setDividerLocation(2000);
        this.jSplitPaneBottom.setOrientation(0);
        this.jSplitPaneBottom.setResizeWeight(1.0);
        this.desktopPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DesktopPanel.this.desktopPanel_onComponentResized(evt);
            }
        });
        this.jSplitPaneBottom.setTopComponent(this.desktopPane);
        this.jSplitPaneBottom.setRightComponent(this.undockablePanel);
        this.pnlAtt.add((Component)this.jSplitPaneBottom, "Center");
        this.jSplitPaneLeft.setRightComponent(this.pnlAtt);
        this.pnlModule.add((Component)this.jSplitPaneLeft, "Center");
        this.jSplitPane.setLeftComponent(this.pnlModule);
        this.tabPanel.setMinimumSize(new Dimension(200, 16));
        this.tabPanel.setPreferredSize(new Dimension(200, 16));
        this.tabPanel.setLayout(new BorderLayout());
        this.tbaRight.add(this.filler);
        this.butClose.setHorizontalTextPosition(0);
        this.butClose.setIconTextGap(0);
        this.butClose.setMargin(new Insets(4, 5, 4, 5));
        this.butClose.setVerticalTextPosition(3);
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DesktopPanel.this.butCloseActionPerformed(evt);
            }
        });
        this.tbaRight.add(this.butClose);
        this.tabPanel.add((Component)this.tbaRight, "North");
        this.tabbedPane.setRequestFocusEnabled(false);
        this.tabPanel.add((Component)this.tabbedPane, "Center");
        this.jSplitPane.setRightComponent(this.tabPanel);
        this.add((Component)this.jSplitPane, "Center");
    }

    private void butCloseLeftActionPerformed(ActionEvent evt) {
        this.setLeftTabsVisible(!this.bolTabsVisibleLeft);
    }

    private void butCloseActionPerformed(ActionEvent evt) {
        this.setRightTabsVisible(!this.bolTabsVisibleRight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmbScale_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockScaleEvent) {
            return;
        }
        this.bolBlockScaleEvent = true;
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"));
            Runnable work = () -> {
                try {
                    if (WorkbenchContext.getFrame() == null || WorkbenchContext.getFrame().getActiveInternalFrame() == null || !(WorkbenchContext.getFrame().getActiveInternalFrame() instanceof TaskFrame)) {
                        return;
                    }
                    if (this.cmbScale.getSelectedIndex() == 0) {
                        return;
                    }
                    if (this.cmbScale.getSelectedIndex() == 1) {
                        JUMPWorkbench.getBuiltInPlugIn(ZoomToScalePlugIn.class).execute(WorkbenchContext.getInstance().createPlugInContext());
                    } else {
                        WorkbenchContext.getMapAppContext().getActiveMap().zoomScale(Double.parseDouble(this.arrScales[this.cmbScale.getSelectedIndex() - 2]));
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                throw dlgWait.getError();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"riwagis");
        }
        finally {
            this.cmbScale.setSelectedIndex(0);
            this.bolBlockScaleEvent = false;
        }
    }

    private void desktopPanel_onComponentResized(ComponentEvent evt) {
        if (this.bolSplitPos) {
            return;
        }
        this.bolSplitPos = true;
        try {
            if (this.bolTabsVisibleBottom) {
                if (this.undockablePanel.getHeight() < 30) {
                    this.setDefaultBottomDividerLocation();
                }
            } else {
                this.jSplitPaneBottom.setDividerLocation(1.0);
            }
        }
        finally {
            this.bolSplitPos = false;
        }
    }

    private void dndTabbedPanePropertyChange(PropertyChangeEvent evt) {
        if ("LAST_TAB_CLOSED".equals(evt.getPropertyName())) {
            this.setBottomTabsVisible(false);
        }
    }
}

