/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CopyThisCoordinatePlugIn;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinateFieldsDocumentListener
implements DocumentListener {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinateFieldsDocumentListener.class);
    private final JFormattedTextField txtCurrent;
    private final JFormattedTextField txtX;
    private final JFormattedTextField txtY;

    public CoordinateFieldsDocumentListener(JFormattedTextField txtCurrent, JFormattedTextField txtX, JFormattedTextField txtY) {
        this.txtCurrent = txtCurrent;
        this.txtX = txtX;
        this.txtY = txtY;
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] coords;
                    String delimiter = PersistentBlackboardPlugIn.get().get(CopyThisCoordinatePlugIn.DELIMITER, ";");
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    String strLocaleDecSeparator = Character.toString(dfs.getDecimalSeparator());
                    String strLocaleGroupingSeparator = Character.toString(dfs.getGroupingSeparator());
                    if (delimiter.equals(strLocaleDecSeparator) || delimiter.equals(strLocaleGroupingSeparator)) {
                        return;
                    }
                    String strDecSeparator = PersistentBlackboardPlugIn.get().get(CopyThisCoordinatePlugIn.DECIMAL_DELIMITER, strLocaleDecSeparator);
                    if (delimiter.equals(strDecSeparator)) {
                        return;
                    }
                    dfs.setDecimalSeparator(strDecSeparator.toCharArray()[0]);
                    DecimalFormat dfImport = new DecimalFormat();
                    if (dfs.getGroupingSeparator() == strDecSeparator.toCharArray()[0]) {
                        dfImport.setGroupingUsed(false);
                    } else {
                        dfImport.setGroupingSize(3);
                        dfImport.setGroupingUsed(true);
                    }
                    dfImport.setDecimalFormatSymbols(dfs);
                    dfImport.setMinimumFractionDigits(2);
                    dfImport.setMaximumFractionDigits(6);
                    String data = e.getDocument().getText(0, e.getDocument().getLength());
                    if (CoordinateFieldsDocumentListener.this.txtCurrent.getCaretPosition() > 0) {
                        data = data.substring(0, CoordinateFieldsDocumentListener.this.txtCurrent.getCaretPosition());
                    }
                    if ((coords = data.split(delimiter = data.contains(delimiter) ? Pattern.quote(delimiter) : "[^0-9.,-]")) != null && coords.length > 1) {
                        if (StringUtils.isNotEmpty((CharSequence)coords[0])) {
                            CoordinateFieldsDocumentListener.this.txtX.setValue(dfImport.parse(coords[0]));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)coords[1])) {
                            CoordinateFieldsDocumentListener.this.txtY.setValue(dfImport.parse(coords[1]));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("error parsing coordinates", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

