/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.model.style.ColorModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;

public class ColorChooserPanelWithDB
extends JPanel {
    private static final ColorModel DUMMY_COLOR_MODEL = new ColorModel(0, 0, 0);
    private ColorModel colorChooserColorModel = DUMMY_COLOR_MODEL;
    private StylePanel stylePanel = null;
    private final ArrayList actionListeners = new ArrayList();
    private ColorChooserPanel colorChooser;
    private JTextField txtBsh;

    public ColorChooserPanelWithDB() {
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.txtBsh.setToolTipText(I18N.get("ui.ColorChooserPanelWithDB.bsh-tooltip-text"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateEnabledState();
        } else {
            this.colorChooser.setEnabled(enabled);
            this.txtBsh.setEnabled(enabled);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionPerformed() {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public void setColorModel(ColorModel colorModel) {
        if (colorModel != null) {
            if (!StringUtils.equals((String)this.txtBsh.getText(), (String)colorModel.getBsh())) {
                this.txtBsh.setText(colorModel.getBsh());
            }
            this.colorChooser.setColor(RiwaJumpModelUtilities.colorByColorModel(colorModel));
        } else {
            this.txtBsh.setText("");
            this.colorChooser.setColor(Color.GRAY);
        }
        this.setColorModelInternal(colorModel);
    }

    public void setColorModel(ColorModel colorModel, int alpha) {
        this.setColorModel(colorModel);
        this.setAlpha(alpha);
    }

    private void setColorModelInternal(ColorModel colorModel) {
        this.colorChooserColorModel = colorModel;
        this.updateEnabledState();
    }

    public void setAlpha(int alpha) {
        this.colorChooser.setAlpha(alpha);
    }

    private void updateEnabledState() {
        if (this.colorChooserColorModel != null && this.isEnabled()) {
            this.txtBsh.setEnabled(true);
            this.colorChooser.setEnabled(true);
        } else {
            this.txtBsh.setEnabled(false);
            this.colorChooser.setEnabled(false);
        }
    }

    public JTextComponent getInternalTextComponent() {
        return this.txtBsh;
    }

    public ColorChooserPanel getInternalColorChooser() {
        return this.colorChooser;
    }

    private void initComponents() {
        this.txtBsh = new JTextField();
        this.colorChooser = new ColorChooserPanel();
        this.setLayout(new GridBagLayout());
        this.txtBsh.setColumns(10);
        this.txtBsh.setToolTipText("Farbwert aus Attribut");
        this.txtBsh.setMinimumSize(new Dimension(120, 20));
        this.txtBsh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorChooserPanelWithDB.this.txtBshActionPerformed(evt);
            }
        });
        this.txtBsh.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ColorChooserPanelWithDB.this.txtBshKeyReleased(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.txtBsh, gridBagConstraints);
        this.colorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorChooserPanelWithDB.this.colorChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.colorChooser, gridBagConstraints);
    }

    private void colorChooserActionPerformed(ActionEvent evt) {
        ColorModel colorModelByChooser = new ColorModel(this.colorChooser.getColor().getRed(), this.colorChooser.getColor().getGreen(), this.colorChooser.getColor().getBlue(), this.colorChooserColorModel.getAlpha(), this.colorChooserColorModel.getBsh());
        this.setColorModelInternal(colorModelByChooser);
        this.fireActionPerformed();
    }

    private void txtBshKeyReleased(KeyEvent evt) {
        String bsh = this.txtBsh.getText();
        if (StringUtils.isBlank((String)bsh)) {
            bsh = null;
        }
        ColorModel colorModelByTxtBsh = new ColorModel(this.colorChooserColorModel.getRed(), this.colorChooserColorModel.getGreen(), this.colorChooserColorModel.getBlue(), this.colorChooserColorModel.getAlpha(), bsh);
        this.setColorModelInternal(colorModelByTxtBsh);
        if (this.stylePanel != null) {
            if (FeatBshValidator.validateTextExpression((String)this.txtBsh.getText(), (SimpleFeatureType)this.stylePanel.getFeatureRetriever().getFeatureType()) == null) {
                this.txtBsh.setForeground(Color.GREEN.darker());
            } else {
                this.txtBsh.setForeground(Color.RED.darker());
            }
        } else {
            this.txtBsh.setForeground(Color.BLACK);
        }
        this.fireActionPerformed();
    }

    private void txtBshActionPerformed(ActionEvent evt) {
    }

    @Generated
    public ColorModel getColorChooserColorModel() {
        return this.colorChooserColorModel;
    }

    @Generated
    public void setStylePanel(StylePanel stylePanel) {
        this.stylePanel = stylePanel;
    }
}

