/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.ColorPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorChooserPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(ColorChooserPanel.class);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton changeButton = new JButton();
    JPanel outerColorPanel = new JPanel();
    ColorPanel colorPanel = new ColorPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private Color color = Color.black;
    private int alpha;
    private ArrayList actionListeners = new ArrayList();
    private static boolean chooserVisible = false;
    private static final JColorChooser colorChooser = new JColorChooser();
    private ActionListener colorChooserOKListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor = colorChooser.getColor();
            if (newColor == null) {
                return;
            }
            ColorChooserPanel.this.setColor(newColor);
            ColorChooserPanel.this.fireActionPerformed();
        }
    };
    private JPopupMenu pMenu = new JPopupMenu("Copy/Paste");

    public ColorChooserPanel() {
        try {
            this.jbInit();
            this.colorPanel.setLineBaseColor(null);
            this.changeButton.setToolTipText(I18N.get("ui.ColorChooserPanel.browse"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.changeButton.setMargin(new Insets(0, 2, 0, 2));
        this.changeButton.setText("...");
        this.changeButton.setPreferredSize(new Dimension(22, 22));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel.this.changeButton_actionPerformed();
            }
        });
        this.outerColorPanel.setBorder(UIManager.getBorder("ComboBox.border"));
        this.outerColorPanel.setPreferredSize(new Dimension(60, 22));
        this.outerColorPanel.setBackground(Color.white);
        this.outerColorPanel.setLayout(this.gridBagLayout2);
        this.outerColorPanel.setInheritsPopupMenu(true);
        this.colorPanel.setMargin(0);
        this.colorPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.colorPanel.setInheritsPopupMenu(true);
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColorChooserPanel.this.changeButton_actionPerformed();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() && !ColorChooserPanel.this.isEnabled()) {
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && !ColorChooserPanel.this.isEnabled()) {
                    e.consume();
                }
            }
        });
        this.setOpaque(false);
        this.add((Component)this.changeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.outerColorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.outerColorPanel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.initPopupMenu();
    }

    private void initPopupMenu() {
        JMenuItem miCopy = new JMenuItem(I18N.get("common.copy"));
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection transferable = new StringSelection("" + ColorChooserPanel.this.color.getRGB());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, transferable);
            }
        });
        this.pMenu.add(miCopy);
        this.pMenu.addSeparator();
        JMenuItem miPaste = new JMenuItem(I18N.get("common.paste"));
        miPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String strColor = ObjectUtils.toString((Object)transferable.getTransferData(DataFlavor.stringFlavor));
                        if (strColor == null || strColor.length() == 0) {
                            return;
                        }
                        int intRGB = Integer.parseInt(strColor);
                        ColorChooserPanel.this.color = new Color(intRGB);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ColorChooserPanel.this.updateColorPanel();
                                ColorChooserPanel.this.fireActionPerformed();
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Error pasting color in ColorChooserPanel.", (Throwable)ex);
                }
            }
        });
        this.pMenu.add(miPaste);
        this.setComponentPopupMenu(this.pMenu);
    }

    void changeButton_actionPerformed() {
        if (!this.isEnabled()) {
            return;
        }
        if (chooserVisible) {
            GUISupport.msgbox((Component)this, (String)"ui.ColorChooserPanel.other-visible", (String)I18N.get("common.error"));
            return;
        }
        chooserVisible = true;
        try {
            colorChooser.setColor(this.color);
            JDialog colorChooserDialog = JColorChooser.createDialog(this, I18N.get("ui.ColorChooserPanel.choose-color"), true, colorChooser, this.colorChooserOKListener, null);
            GUISupport.centreComponent((Component)colorChooserDialog, (Component)SwingUtilities.windowForComponent(this));
            colorChooserDialog.setVisible(true);
        }
        finally {
            chooserVisible = false;
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateColorPanel();
    }

    private void updateColorPanel() {
        this.colorPanel.setFillColor(GUIUtil.alphaColor(this.color, this.alpha));
        this.colorPanel.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionPerformed() {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.updateColorPanel();
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        MenuElement[] arrMens;
        this.changeButton.setEnabled(newEnabled);
        this.colorPanel.setEnabled(newEnabled);
        this.outerColorPanel.setEnabled(newEnabled);
        for (MenuElement men : arrMens = this.pMenu.getSubElements()) {
            men.getComponent().setEnabled(newEnabled);
        }
        super.setEnabled(newEnabled);
    }
}

