/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.ExtensionsAboutPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.SplashPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import de.riwagis.gis.context.map.debug.DebugInformation;
import de.riwagis.gis.context.map.debug.DebugInformationProvider;
import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTextField;

public class AboutDialog
extends JDialog {
    private final JPanel buttonPanel = new JPanel();
    private final JButton okButton = new JButton();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel logoPanel = new JPanel(new BorderLayout());
    private SplashPanel splashPanel;
    private JXTable infoTable;
    private ExtensionsAboutPanel extensionsAboutPanel = new ExtensionsAboutPanel();

    public static AboutDialog instance(WorkbenchContext context) {
        String INSTANCE_KEY = AboutDialog.class.getName() + " - INSTANCE";
        if (JUMPWorkbench.getBlackboard().get(INSTANCE_KEY) == null) {
            JUMPWorkbench.getBlackboard().put(INSTANCE_KEY, new AboutDialog(JUMPWorkbench.getFrame()));
        }
        AboutDialog dialog = (AboutDialog)JUMPWorkbench.getBlackboard().get(INSTANCE_KEY);
        GUIUtil.centreOnWindow(dialog);
        return dialog;
    }

    private AboutDialog(WorkbenchFrame frame) {
        super(frame, AboutDialog.getAboutTitle(), true);
        this.extensionsAboutPanel.setPlugInManager(JUMPWorkbench.getPlugInManager());
        this.splashPanel = new SplashPanel(JUMPWorkbench.splashImage(), "<html><div align='right'>" + I18N.get("ui.AboutDialog.version") + " " + JUMPWorkbench.getDisplayVersion() + " / RIWA GmbH</div></html>");
        try {
            this.jbInit();
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getAboutTitle() {
        String wbTitle = "";
        try {
            wbTitle = JUMPWorkbench.getWorkbench().getProperties().getTitle();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)wbTitle, (CharSequence)I18N.get("ui.AboutDialog.about-jump"));
    }

    private final void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(e -> this.hideDialog());
        this.tabbedPane.add((Component)this.logoPanel, I18N.get("ui.AboutDialog.about"));
        this.logoPanel.add((Component)this.splashPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.tabbedPane.setBounds(0, 0, 0, 0);
        this.tabbedPane.addTab(I18N.get("ui.AboutDialog.info"), this.createNewInfoPanel());
        this.tabbedPane.addTab(StringUtil.toFriendlyName(this.extensionsAboutPanel.getClass().getName(), "AboutPanel"), this.extensionsAboutPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private Component createNewInfoPanel() {
        DefaultTableModel model = new DefaultTableModel(new String[]{I18N.get("ui.AboutDialog.infotable-key"), I18N.get("ui.AboutDialog.infotable-value")}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.infoTable = new JXTable((TableModel)model);
        this.infoTable.setCellSelectionEnabled(true);
        this.infoTable.addMouseListener((MouseListener)new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent me) {
                Object cellValue;
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                int col = table.columnAtPoint(p);
                if (me.getClickCount() == 2 && (cellValue = table.getValueAt(row, col)) instanceof TableValueWithAction) {
                    ((TableValueWithAction)cellValue).runAction();
                }
            }
        });
        this.infoTable.setPreferredScrollableViewportSize(new Dimension(20, 20));
        JXTextField searchField = new JXTextField();
        searchField.setPrompt(I18N.get("ui.AboutDialog.infotable-filter"));
        searchField.setOpaque(true);
        searchField.addActionListener(e -> {
            if (searchField.getText().isBlank()) {
                this.infoTable.setRowFilter(null);
            } else {
                this.infoTable.setRowFilter(RowFilter.regexFilter(searchField.getText(), new int[0]));
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.infoTable);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton btnCollectGarbage = new JButton(I18N.get("ui.AboutDialog.garbage-collect"));
        btnCollectGarbage.setIcon(IconLoader.svgIcon((String)"common_reload_green.svg"));
        btnCollectGarbage.addActionListener(e -> {
            Runtime.getRuntime().gc();
            this.refreshTableContent();
        });
        btnCollectGarbage.setOpaque(false);
        jToolBar.add(btnCollectGarbage);
        JButton btnCopy = new JButton(I18N.get("ui.AboutDialog.copy-to-clipboard"));
        btnCopy.setIcon(IconLoader.svgIcon((String)"common_copy.svg"));
        btnCopy.addActionListener(e -> this.copyTableContentToClipboard(this.infoTable));
        btnCopy.setOpaque(false);
        jToolBar.add(btnCopy);
        jToolBar.setRollover(true);
        jToolBar.add((Component)searchField);
        jToolBar.setOpaque(false);
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void copyTableContentToClipboard(JXTable table) {
        StringBuilder builder = new StringBuilder();
        for (int row = 0; row < table.getRowCount(); ++row) {
            String key = (String)table.getValueAt(row, 0);
            TableValueWithAction value = (TableValueWithAction)table.getValueAt(row, 1);
            builder.append(key).append("\t").append(Objects.toString(value.getValue(), "")).append(System.lineSeparator());
        }
        StringSelection selection = new StringSelection(builder.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private void refreshTableContent() {
        DefaultTableModel model = (DefaultTableModel)this.infoTable.getModel();
        model.setRowCount(0);
        ServiceLoader.load(DebugInformationProvider.class).stream().map(ServiceLoader.Provider::get).flatMap(provider -> provider.provide().stream()).sorted(Comparator.comparing(DebugInformation::getKey)).forEach(debugInfo -> model.addRow(new Object[]{debugInfo.getDisplayKey(), new TableValueWithAction(debugInfo.getDisplayValue(), () -> debugInfo.doDoubleClickAction())}));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshTableContent();
        }
        super.setVisible(b);
    }

    private void hideDialog() {
        this.setVisible(false);
    }

    private static class TableValueWithAction {
        private final String value;
        private final Runnable action;

        public TableValueWithAction(String value, Runnable action) {
            this.value = value;
            this.action = action;
        }

        public String getValue() {
            return this.value;
        }

        public void runAction() {
            this.action.run();
        }

        public String toString() {
            return this.value;
        }
    }
}

