/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.tools;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Collection;

public class LayerTools {
    protected PlugInContext context = null;

    public LayerTools(PlugInContext context) {
        this.context = context;
    }

    public Layer[] getSelectedLayers() {
        return this.context.getSelectedLayers();
    }

    public int getNumSelectedLayers() {
        return LayerTools.getNumSelectedLayers(this.context);
    }

    public static int getNumSelectedLayers(PlugInContext context) {
        return context.getSelectedLayers().length;
    }

    public static Layer[] getSelectedLayers(PlugInContext context, int num) {
        Layer[] selLayers = context.getSelectedLayers();
        if (selLayers.length == 0) {
            return null;
        }
        if (num <= 0) {
            return selLayers;
        }
        Layer[] result = new Layer[num];
        for (int i = 0; i < selLayers.length && i < result.length; ++i) {
            result[i] = selLayers[i];
        }
        return result;
    }

    public static Layer getSelectedLayer(PlugInContext context) {
        Layer[] selLayers = LayerTools.getSelectedLayers(context, 1);
        if (selLayers == null || selLayers.length == 0) {
            return null;
        }
        return selLayers[0];
    }

    public static Layerable getSelectedLayerable(PlugInContext context, Class layerableClass) {
        Collection<Layerable> selLayers = context.getLayerNamePanel().selectedNodes(layerableClass);
        if (selLayers == null || selLayers.size() == 0) {
            return null;
        }
        return selLayers.toArray(new Layerable[0])[0];
    }
}

