/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlugInManager {
    private static final Logger LOG = LoggerFactory.getLogger(PlugInManager.class);
    private final TaskMonitor monitor;
    private final WorkbenchContext context;
    private final Collection<Configuration> configurations = new ArrayList<Configuration>();
    private final File plugInDirectory;
    private final ClassLoader classLoader;

    public static String name(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getName();
        }
        return String.format("%s (%s)", StringUtil.toFriendlyName(configuration.getClass().getName(), "Configuration"), configuration.getClass().getPackage().getName());
    }

    public static String version(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getVersion();
        }
        return "";
    }

    public void closeAllConfigurations() {
        for (Configuration c : this.configurations) {
            try {
                if (!(c instanceof Closeable)) continue;
                LOG.debug(String.format("Closing '%s'", c));
                ((Closeable)((Object)c)).close();
            }
            catch (IOException ex) {
                LOG.warn(String.format("Unable to close '%s': %s", c, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public PlugInManager(WorkbenchContext context, File plugInDirectory, TaskMonitor monitor) throws Exception {
        this.monitor = monitor;
        Assert.isTrue((plugInDirectory == null || plugInDirectory.isDirectory() ? 1 : 0) != 0);
        this.classLoader = plugInDirectory != null ? new URLClassLoader(this.toURLs(this.findFilesRecursively(plugInDirectory))) : this.getClass().getClassLoader();
        this.context = context;
        this.configurations.addAll(plugInDirectory != null ? this.findConfigurations(plugInDirectory) : new ArrayList());
        this.configurations.addAll(this.findConfigurations(WorkbenchContext.getWorkbench().getProperties().getConfigurationClasses()));
        this.plugInDirectory = plugInDirectory;
    }

    public void load() throws Exception {
        this.loadPlugInClasses(WorkbenchContext.getWorkbench().getProperties().getPlugInClasses());
        this.loadConfigurations();
    }

    private void loadConfigurations() throws Exception {
        for (Configuration configuration : this.configurations) {
            configuration.configure(new PlugInContext(this.context, null, null, null, null));
        }
    }

    private Collection<Configuration> findConfigurations(Collection<Class<?>> classes) throws Exception {
        ArrayList<Configuration> configurationsFound = new ArrayList<Configuration>();
        for (Class<?> c : classes) {
            if (!Configuration.class.isAssignableFrom(c)) continue;
            LOG.info(String.format("Loading %s", c.getName()));
            Configuration configuration = (Configuration)c.newInstance();
            configurationsFound.add(configuration);
            this.monitor.report(String.format("Loading %s %s", PlugInManager.name(configuration), PlugInManager.version(configuration)));
        }
        return configurationsFound;
    }

    private void loadPlugInClasses(Collection<Class<?>> plugInClasses) throws Exception {
        for (Class<?> plugInClass : plugInClasses) {
            PlugIn plugIn = (PlugIn)plugInClass.newInstance();
            plugIn.initialize(new PlugInContext(this.context, null, null, null, null));
        }
    }

    private Collection<File> findFilesRecursively(File directory) {
        Assert.isTrue((boolean)directory.isDirectory());
        ArrayList<File> files = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(this.findFilesRecursively(file));
            }
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private Collection<Configuration> findConfigurations(File plugInDirectory) throws Exception {
        ArrayList<Configuration> configurationsFound = new ArrayList<Configuration>();
        for (File file : this.findFilesRecursively(plugInDirectory)) {
            try {
                configurationsFound.addAll(this.findConfigurations(this.classes(new ZipFile(file), this.classLoader)));
            }
            catch (ZipException zipException) {}
        }
        return configurationsFound;
    }

    private URL[] toURLs(Collection<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File currFile : files) {
            try {
                urls.add(new URL(String.format("jar:file:%s!/", currFile.getPath())));
            }
            catch (MalformedURLException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
        return urls.toArray(new URL[0]);
    }

    private Collection<Class<?>> classes(ZipFile zipFile, ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            Class<?> c;
            ZipEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith("Extension.class") && !entryName.endsWith("Configuration.class") || (c = this.toClass(entry, classLoader)) == null) continue;
            classes.add(c);
        }
        return classes;
    }

    private Class<?> toClass(ZipEntry entry, ClassLoader classLoader) {
        Class<?> candidate;
        if (entry.isDirectory()) {
            return null;
        }
        if (!entry.getName().endsWith(".class")) {
            return null;
        }
        if (entry.getName().indexOf(36) != -1) {
            return null;
        }
        String className = entry.getName();
        className = className.substring(0, className.length() - ".class".length());
        className = StringUtil.replaceAll(className, "/", ".");
        try {
            candidate = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Assert.shouldNeverReachHere((String)String.format("Class not found: %s. Refine class name algorithm.", className));
            return null;
        }
        catch (Throwable t) {
            LOG.error(String.format("Throwable encountered loading %s:", className), t);
            return null;
        }
        return candidate;
    }

    public Collection<Configuration> getConfigurations() {
        return Collections.unmodifiableCollection(this.configurations);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getPlugInDirectory() {
        return this.plugInDirectory;
    }
}

