/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.components.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import javax.swing.JInternalFrame;
import org.locationtech.jts.geom.Envelope;

public class PlugInContext
implements LayerManagerProxy {
    private final Task task;
    private final LayerNamePanel layerNamePanel;
    private final LayerViewPanel layerViewPanel;
    private final WorkbenchContext workbenchContext;
    private final EnableCheckFactory checkFactory;
    private final FeatureInstaller featureInstaller;
    private final LayerManagerProxy layerManagerProxy;

    public PlugInContext(WorkbenchContext workbenchContext, Task task, LayerManagerProxy layerManagerProxy, LayerNamePanel layerNamePanel, LayerViewPanel layerViewPanel) {
        this.workbenchContext = workbenchContext;
        this.task = task;
        this.layerManagerProxy = layerManagerProxy;
        this.layerNamePanel = layerNamePanel;
        this.layerViewPanel = layerViewPanel;
        this.checkFactory = new EnableCheckFactory(workbenchContext);
        this.featureInstaller = new FeatureInstaller(workbenchContext);
    }

    public ErrorHandler getErrorHandler() {
        return WorkbenchContext.getErrorHandler();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.workbenchContext;
    }

    public Layer getSelectedLayer(int i) {
        Layer[] selectedLayers = this.getSelectedLayers();
        if (selectedLayers.length > i) {
            return selectedLayers[i];
        }
        return null;
    }

    public Layer[] getSelectedLayers() {
        return this.getLayerNamePanel().getSelectedLayers();
    }

    public Envelope getSelectedLayerEnvelope() {
        return this.getSelectedLayer(0).getEnvelope();
    }

    public Task getTask() {
        return this.task;
    }

    public LayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    public LayerViewPanel getLayerViewPanel() {
        return this.layerViewPanel;
    }

    public WorkbenchFrame getWorkbenchFrame() {
        return JUMPWorkbench.getFrame();
    }

    public JInternalFrame getActiveInternalFrame() {
        return JUMPWorkbench.getFrame().getActiveInternalFrame();
    }

    public EnableCheckFactory getCheckFactory() {
        return this.checkFactory;
    }

    public FeatureInstaller getFeatureInstaller() {
        return this.featureInstaller;
    }
}

