/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.visibility.LayerableVisibility;
import com.vividsolutions.jump.workbench.model.visibility.StyleCollectionVisibility;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class EnableCheckFactory {
    private static EnableCheckFactory INSTANCE;
    private final WorkbenchContext workbenchContext;

    public static EnableCheckFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EnableCheckFactory(WorkbenchContext.getInstance());
        }
        return INSTANCE;
    }

    @Deprecated
    public EnableCheckFactory(WorkbenchContext workbenchContext) {
        Assert.isTrue((workbenchContext != null ? 1 : 0) != 0);
        this.workbenchContext = workbenchContext;
    }

    public EnableCheck createTaskWindowMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof TaskFrame) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-Task-Window-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithSelectionManagerMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof SelectionManagerProxy) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-selection-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerManagerMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof LayerManagerProxy) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithAssociatedTaskFrameMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof TaskFrameProxy) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-an-associated-task-frame-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerNamePanelMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof LayerNamePanelProxy) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-name-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerViewPanelMustBeActiveCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return !(JUMPWorkbench.getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy) ? I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-view-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedFeaturesCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                if (JUMPWorkbench.getFrame().getActiveInternalFrame() == null) {
                    return "no frame";
                }
                Collection<Layer> layersWithSelectedFeatures = ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
                return layersWithSelectedFeatures.size() > 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-features") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedItemsCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Collection<Layer> layersWithSelectedItems = ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems();
                return layersWithSelectedItems.size() > 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-items") : null;
            }
        };
    }

    public EnableCheck createSelectedItemsLayersMustBeEditableCheck() {
        return new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                SelectionManagerProxy smp = (SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame());
                if (smp == null) {
                    return I18N.get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-selection-manager-must-be-active");
                }
                for (Layer layer : smp.getSelectionManager().getLayersWithSelectedItems()) {
                    if (layer.isEditable()) continue;
                    return I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Selected-items-layers-must-be-editable", layer.getName());
                }
                return null;
            }
        };
    }

    public EnableCheck createExactlyNLocalCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                int ct = 0;
                for (Category cat : EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories()) {
                    if (cat.isBuildIn()) continue;
                    ++ct;
                }
                return n != ct ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-local-category-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-local-categories-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-category-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-categories-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNLayerablesMustBeSelectedCheck(final int n, final Class<?> layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EnableCheckFactory.this.workbenchContext.getLayerNamePanel() == null || n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size()) {
                    return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-be-selected", n);
                }
                return null;
            }
        };
    }

    public <T extends Layerable> EnableCheck createExactlyNLocalOrRedlineLayerablesMustBeSelectedCheck(final int n, final Class<T> layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EnableCheckFactory.this.workbenchContext.getLayerNamePanel() != null) {
                    int ct = 0;
                    for (Layerable ly : EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass)) {
                        if (ly.isBuildIn() && !(ly instanceof RedlineLayer)) continue;
                        ++ct;
                    }
                    if (n == ct) {
                        return null;
                    }
                }
                return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-local-or-redline-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-local-or-redline-layers-must-be-selected", n);
            }
        };
    }

    public EnableCheck createExactlyNLayersMustBeSelectedCheck(int n) {
        return this.createExactlyNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createExactlyNSelectableLayersMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EnableCheckFactory.this.workbenchContext.getLayerNamePanel() == null || n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(Layer.class).size()) {
                    return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-be-selected", n);
                }
                Layer ly = EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(Layer.class).iterator().next();
                if (!ly.isSelectable()) {
                    return I18N.get("com.vividsolutions.jump.workbench.plugin.Selected-layer-has-to-be-selectable");
                }
                return null;
            }
        };
    }

    public EnableCheck createExactlyNLocalLayersMustBeSelectedCheck(int n) {
        return this.createExactlyNLocalOrRedlineLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-category-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-categories-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNLocalCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                int ct = 0;
                for (Category cat : EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories()) {
                    if (cat.isBuildIn()) continue;
                    ++ct;
                }
                return n > ct ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-local-category-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-local-categories-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustBeSelectedCheck(final int n, final Class<?> layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerNamePanel layerNamePanel = EnableCheckFactory.this.workbenchContext.getLayerNamePanel();
                return layerNamePanel == null || n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNSelectedLayersMustHaveChildrenCheck(int n) {
        return component -> {
            LayerNamePanel layerNamePanel = this.workbenchContext.getLayerNamePanel();
            long count = 0L;
            if (layerNamePanel != null) {
                count = layerNamePanel.selectedNodes(AbstractLayerable.class).stream().flatMap(layer -> layer.getStyleCollections().stream().map(style -> new StyleCollectionVisibility((StyleCollection)style, new LayerableVisibility((Layerable)layer, null)))).filter(styleColVis -> !styleColVis.getChildren().isEmpty()).count();
            }
            return (long)n > count ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-have-children") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-have-children", n)) : null;
        };
    }

    public <T extends Layerable> EnableCheck createAtLeastNLocalLayerablesMustBeSelectedCheck(final int n, final Class<T> layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EnableCheckFactory.this.workbenchContext.getLayerNamePanel() != null) {
                    int ct = 0;
                    for (Layerable ly : EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass)) {
                        if (ly.isBuildIn()) continue;
                        ++ct;
                    }
                    if (ct >= n) {
                        return null;
                    }
                }
                return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-local-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-local-layers-must-be-selected", n);
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustBeSelectedCheck(int n) {
        return this.createAtLeastNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNSelectableLayersMustBeSelectedCheck(final int n) {
        return new EnableCheck(){
            private final String strErrorMessage;
            {
                this.strErrorMessage = n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-selected", n);
            }

            @Override
            public String check(JComponent component) {
                LayerNamePanel layerNamePanel = EnableCheckFactory.this.workbenchContext.getLayerNamePanel();
                if (layerNamePanel == null) {
                    return this.strErrorMessage;
                }
                Collection<Layer> colLy = EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(Layer.class);
                if (n > colLy.size()) {
                    return this.strErrorMessage;
                }
                for (Layer ly : colLy) {
                    if (!ly.isSelectable()) continue;
                    return null;
                }
                return this.strErrorMessage;
            }
        };
    }

    public EnableCheck createAtLeastNLocalLayersMustBeSelectedCheck(int n) {
        return this.createAtLeastNLocalLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNLayersMustBeEditableCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return EnableCheckFactory.this.workbenchContext.getLayerManager() != null && n > EnableCheckFactory.this.workbenchContext.getLayerManager().getEditableLayers().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-editable") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-editable", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                return layerManager == null || n > layerManager.size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-exist") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-exist", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNSelectableLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                if (layerManager == null || n > layerManager.size()) {
                    return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-selectable-layer-must-exist") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-selectable-layers-must-exist", n);
                }
                for (Layer ly : layerManager.getLayers()) {
                    if (!ly.isSelectable()) continue;
                    return null;
                }
                return n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-selectable-layer-must-exist") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-selectable-layers-must-exist", n);
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                return layerManager == null || n > layerManager.size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-layerables-must-exist") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-layerables-must-exist", n)) : null;
            }
        };
    }

    public EnableCheck createAtMostNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n < EnableCheckFactory.this.workbenchContext.getLayerManager().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-most-one-layer-must-exist") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-most-n-layers-must-exist", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNFeaturesOrPartsMustBeSelectedCheck(int n) {
        return component -> {
            SelectionManager selectionManager = ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager();
            int selectedPartsOrFeatures = 0;
            for (Layer layer : selectionManager.getLayersWithSelectedItems()) {
                for (SimpleFeature feature : selectionManager.getFeaturesWithSelectedItems(layer)) {
                    for (AbstractSelection selection : selectionManager.getSelections()) {
                        selectedPartsOrFeatures += selection.getSelectedItemCount(layer, feature);
                    }
                }
            }
            return n > selectedPartsOrFeatures ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-be-selected", n)) : null;
        };
    }

    public EnableCheck createAtLeastNFeaturesOnCurrentLayerMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                JInternalFrame activeInternalFrame = JUMPWorkbench.getFrame().getActiveInternalFrame();
                List<Layer> selectedLegendLayers = Arrays.asList(((LayerNamePanelProxy)((Object)activeInternalFrame)).getLayerNamePanel().getSelectedLayers());
                SelectionManager selectionManager = ((SelectionManagerProxy)((Object)activeInternalFrame)).getSelectionManager();
                int selectedFeaturesOnSelectedLayers = selectedLegendLayers.stream().mapToInt(l -> selectionManager.getFeaturesWithSelectedItems((Layer)l).size()).sum();
                return n > selectedFeaturesOnSelectedLayers ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-be-selected-on-this-layer") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-be-selected-on-this-layer", n)) : null;
            }
        };
    }

    public EnableCheck createAtLeastNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                JInternalFrame iFrame = JUMPWorkbench.getFrame().getActiveInternalFrame();
                return iFrame == null || n > ((SelectionManagerProxy)((Object)iFrame)).getSelectionManager().getSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-item-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-items-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createAtMostNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                JInternalFrame iFrame = JUMPWorkbench.getFrame().getActiveInternalFrame();
                return iFrame == null || ((SelectionManagerProxy)((Object)iFrame)).getSelectionManager().getSelectedItems().size() > n ? String.format("At most %s item%s should be selected", n, StringUtil.s(n)) : null;
            }
        };
    }

    public EnableCheck createAtMostNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().size() > n ? String.format("At most %s feature%s should be selected", n, StringUtil.s(n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-item-must-be-selected") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-items-must-be-selected", n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-have-selected-items") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-have-selected-items", n)) : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-have-selected-items") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-have-selected-items", n)) : null;
            }
        };
    }

    public EnableCheck createSelectedLayersMustBeEditableCheck() {
        return component -> {
            if (this.workbenchContext.getLayerNamePanel() != null) {
                for (Layer layer : Arrays.asList(this.workbenchContext.getLayerNamePanel().getSelectedLayers())) {
                    if (layer.isEditable()) continue;
                    return I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Selected-layers-must-be-editable", layer.getName());
                }
            } else {
                return "No layerNamePanel available.";
            }
            return null;
        };
    }

    public EnableCheck createSelectedLayersCanBeDigiLayerCheck() {
        return this.createSelectedLayersValidatorCheck(layer -> {
            if (!layer.canBeDigiLayer()) {
                return I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Selected-layers-must-be-possible-digilayer", layer.getName());
            }
            return null;
        });
    }

    public EnableCheck createSelectedLayersMustBeNoLabelLayerCheck() {
        return this.createSelectedLayersValidatorCheck(layer -> {
            if (layer instanceof LabelLayer) {
                return I18N.getMessage("com.vividsolutions.jump.workbench.plugin.Selected-layers-must-be-no-label-layer", layer.getName());
            }
            return null;
        });
    }

    public EnableCheck createSelectedLayersValidatorCheck(Function<Layer, String> layerPredicate) {
        return component -> {
            if (this.workbenchContext.getLayerNamePanel() == null) {
                return "No layerNamePanel available.";
            }
            for (Layer layer : Arrays.asList(this.workbenchContext.getLayerNamePanel().getSelectedLayers())) {
                String message = (String)layerPredicate.apply(layer);
                if (message == null) continue;
                return message;
            }
            return null;
        };
    }

    public EnableCheck createAtLeastNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > ((SelectionManagerProxy)((Object)JUMPWorkbench.getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItems().size() ? (n == 1 ? I18N.get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-have-selected-items") : I18N.getMessage("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-have-selected-items", n)) : null;
            }
        };
    }

    public EnableCheck createRequires3DProject() {
        return component -> {
            if (JUMPWorkbench.GIS_CONTEXT == null) {
                return "no gis context initialized";
            }
            if (JUMPWorkbench.GIS_CONTEXT.getModuleApp().getVersion() < 1022) {
                return "wrong gis server version";
            }
            if (!Gis3DContextImpl.getInstance().is3DAvailable()) {
                return "3D nicht verf\u00fcgbar.";
            }
            return null;
        };
    }
}

