/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.MissingResourceException;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugIn
implements PlugIn {
    private static Logger LOG = LoggerFactory.getLogger(AbstractPlugIn.class);
    private final String name;

    public boolean isUndoable() {
        return true;
    }

    protected void execute(UndoableCommand command, PlugInContext context) {
        AbstractPlugIn.execute(command, (LayerManagerProxy)context.getLayerViewPanel(), this.isUndoable());
    }

    protected AbstractPlugIn() {
        this(null);
    }

    protected AbstractPlugIn(String name) {
        this.name = name;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        LOG.info(String.format("initializing '%s'", this.getName()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    @Override
    public String getName() {
        return this.name == null ? AbstractPlugIn.createName(this.getClass()) : this.name;
    }

    public static String createName(Class<?> plugInClass) {
        try {
            return I18N.get(plugInClass.getName());
        }
        catch (MissingResourceException e) {
            LOG.error(String.format("%s %s", e.getMessage(), plugInClass.getName()));
            return StringUtil.toFriendlyName(plugInClass.getName(), "PlugIn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePlugin(PlugIn plugIn, WorkbenchContext workbenchContext, TaskMonitorManager taskMonitorManager) {
        try {
            UndoableEditReceiver undoableEditReceiver;
            if (WorkbenchContext.getWorkbench() != null) {
                JUMPWorkbench.getFrame().setStatusMessage("");
                JUMPWorkbench.getFrame().log(I18N.getMessage("plugin.AbstractPlugIn.executing", plugIn.getName()));
            }
            PlugInContext plugInContext = workbenchContext.createPlugInContext();
            UndoableEditReceiver undoableEditReceiver2 = undoableEditReceiver = workbenchContext.getLayerManager() != null ? workbenchContext.getLayerManager().getUndoableEditReceiver() : null;
            if (undoableEditReceiver != null) {
                undoableEditReceiver.startReceiving();
            }
            try {
                boolean executeComplete = plugIn.execute(plugInContext);
                if (plugIn instanceof ThreadedPlugIn && executeComplete) {
                    taskMonitorManager.execute((ThreadedPlugIn)plugIn, plugInContext);
                }
            }
            finally {
                if (undoableEditReceiver != null) {
                    undoableEditReceiver.stopReceiving();
                }
            }
        }
        catch (Throwable t) {
            WorkbenchContext.getErrorHandler().handleThrowable(t);
        }
    }

    public static ActionListener toActionListener(PlugIn plugIn, WorkbenchContext workbenchContext, TaskMonitorManager taskMonitorManager) {
        return e -> AbstractPlugIn.executePlugin(plugIn, workbenchContext, taskMonitorManager);
    }

    public static void execute(Collection<UndoableCommand> commands, LayerManagerProxy layerManagerProxy) {
        AbstractPlugIn.execute(commands, layerManagerProxy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(final Collection<UndoableCommand> commands, LayerManagerProxy layerManagerProxy, boolean bolUndoable) {
        if (commands.isEmpty()) {
            return;
        }
        UndoableCommand command = new UndoableCommand(commands.iterator().next().getName()){

            @Override
            public void execute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.unexecute();
                }
            }
        };
        boolean exceptionOccurred = true;
        try {
            command.execute();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred) {
                layerManagerProxy.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        boolean bolStopReceiving = false;
        if (!layerManagerProxy.getLayerManager().getUndoableEditReceiver().isReceiving()) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().startReceiving();
            bolStopReceiving = true;
        }
        if (bolUndoable) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        if (bolStopReceiving) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    public static void execute(UndoableCommand command, LayerManagerProxy layerManagerProxy) {
        AbstractPlugIn.execute(command, layerManagerProxy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(UndoableCommand command, LayerManagerProxy layerManagerProxy, boolean bolUndoable) {
        boolean exceptionOccurred = true;
        try {
            command.execute();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred) {
                layerManagerProxy.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        boolean bolStopReceiving = false;
        if (!layerManagerProxy.getLayerManager().getUndoableEditReceiver().isReceiving()) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().startReceiving();
            bolStopReceiving = true;
        }
        if (bolUndoable) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        if (bolStopReceiving) {
            layerManagerProxy.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    @Override
    public KeyStroke getKeyStroke() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static void warnUser(PlugInContext context, String msg) {
        context.getWorkbenchFrame().warnUser(msg);
    }

    protected boolean isRollingBackInvalidEdits(PlugInContext context) {
        return JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    @Override
    public void resetModuleContextCache() {
    }
}

