/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportPlugIn
extends AbstractPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExportPlugIn.class);

    public static boolean isExportAllowed() {
        if (JUMPWorkbench.GIS_CONTEXT != null) {
            try {
                if (JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().containsKey("usr_allow_geodata_exports")) {
                    String info = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().get("usr_allow_geodata_exports").toString();
                    return info != null && !info.equals("0") && !info.equalsIgnoreCase("false");
                }
                return false;
            }
            catch (Exception e) {
                LOG.warn(String.format("unable to check export allowance: %s", e.getMessage()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static EnableCheck createExportAllowedCheck() {
        return c -> {
            if (AbstractExportPlugIn.isExportAllowed()) {
                return null;
            }
            return I18N.get("com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn.export-not-allowed");
        };
    }

    @Override
    public EnableCheck createEnableCheck() {
        return AbstractExportPlugIn.createExportAllowedCheck();
    }
}

