/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.visibility;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.visibility.CadStyleVisibility;
import com.vividsolutions.jump.workbench.model.visibility.ColorThemingStyleVisibility;
import com.vividsolutions.jump.workbench.model.visibility.ModelVisibility;
import com.vividsolutions.jump.workbench.model.visibility.WMSStyleVisibility;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import java.util.ArrayList;
import java.util.Collection;

public class StyleCollectionVisibility
implements ModelVisibility {
    protected final StyleCollection sCol;
    protected final ModelVisibility parent;

    public StyleCollectionVisibility(StyleCollection sCol, ModelVisibility parent) {
        this.sCol = sCol;
        this.parent = parent;
    }

    @Override
    public Collection<ModelVisibility> getChildren() {
        WMSStyleModel wmsStyle;
        LayerStyleCollection lySCol;
        ArrayList<ModelVisibility> lstVisi = new ArrayList<ModelVisibility>();
        Layerable ly = (Layerable)this.getParent().getLayerModelObject();
        if (ly instanceof Layer && ((lySCol = (LayerStyleCollection)this.sCol).getBasicStyle() == null || !lySCol.getBasicStyle().isEnabled())) {
            ColorThemingStyleModel thStyle = lySCol.getStyle(ColorThemingStyleModel.class);
            CadStyleModel cadStyle = lySCol.getStyle(CadStyleModel.class);
            if (thStyle != null) {
                lstVisi.add(this.getColorThemingStyleVisibility(ly, thStyle));
            } else if (cadStyle != null && !cadStyle.isLoadAllLayers()) {
                lstVisi.add(this.getCadStyleVisibility(cadStyle));
            }
        }
        if (ly instanceof WMSLayer && (wmsStyle = this.sCol.getStyle(WMSStyleModel.class)) != null) {
            lstVisi.add(this.getWMSStyleVisibility(wmsStyle));
        }
        return lstVisi;
    }

    @Override
    public void setVisibilityForDirectChildren(Boolean setVisible) {
        for (ModelVisibility mv : this.getChildren()) {
            mv.setVisibilityForSelf(setVisible);
        }
    }

    @Override
    public void setVisibilityForSelf(Boolean setVisible) {
    }

    @Override
    public ModelVisibility getParent() {
        return this.parent;
    }

    @Override
    public Object getLayerModelObject() {
        return this.sCol;
    }

    protected ColorThemingStyleVisibility getColorThemingStyleVisibility(Layerable ly, ColorThemingStyleModel thStyle) {
        return new ColorThemingStyleVisibility((Layer)ly, thStyle, this);
    }

    protected CadStyleVisibility getCadStyleVisibility(CadStyleModel cadStyle) {
        return new CadStyleVisibility(cadStyle, this);
    }

    protected WMSStyleVisibility getWMSStyleVisibility(WMSStyleModel wmsStyle) {
        return new WMSStyleVisibility(wmsStyle, this);
    }
}

