/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.visibility;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.visibility.ModelVisibility;
import com.vividsolutions.jump.workbench.model.visibility.StyleCollectionVisibility;
import java.util.ArrayList;
import java.util.Collection;

public class LayerableVisibility
implements ModelVisibility {
    protected final Layerable ly;
    protected final ModelVisibility parent;

    public LayerableVisibility(Layerable ly, ModelVisibility parent) {
        this.ly = ly;
        this.parent = parent;
    }

    @Override
    public Collection<ModelVisibility> getChildren() {
        ArrayList<ModelVisibility> lstVisi = new ArrayList<ModelVisibility>();
        if (this.ly instanceof Layer && !(this.ly instanceof RedlineLayer) || this.ly instanceof WMSLayer) {
            Layerable lay = this.ly;
            Collection<StyleCollection> col = lay.getStyleCollections();
            for (StyleCollection lyCol : col) {
                lstVisi.add(this.getStyleCollectionVisibility(lyCol));
            }
        }
        return lstVisi;
    }

    @Override
    public void setVisibilityForDirectChildren(Boolean setVisible) {
        for (ModelVisibility mv : this.getChildren()) {
            mv.setVisibilityForDirectChildren(setVisible);
        }
    }

    @Override
    public void setVisibilityForSelf(Boolean setVisible) {
        this.ly.setVisible(setVisible);
    }

    @Override
    public ModelVisibility getParent() {
        return this.parent;
    }

    @Override
    public Object getLayerModelObject() {
        return this.ly;
    }

    protected StyleCollectionVisibility getStyleCollectionVisibility(StyleCollection lyCol) {
        return new StyleCollectionVisibility(lyCol, this);
    }
}

