/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.visibility;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.visibility.LayerableVisibility;
import com.vividsolutions.jump.workbench.model.visibility.ModelVisibility;
import java.util.ArrayList;
import java.util.Collection;

public class CategoryVisibility
implements ModelVisibility {
    protected final Category cat;
    protected final ModelVisibility parent;

    public CategoryVisibility(Category cat, ModelVisibility parent) {
        this.cat = cat;
        this.parent = parent;
    }

    @Override
    public Collection<ModelVisibility> getChildren() {
        ArrayList<ModelVisibility> lstVisi = new ArrayList<ModelVisibility>();
        for (Category catChild : this.cat.getSubcategories()) {
            lstVisi.add(this.getCategoryVisibility(catChild));
        }
        for (Layerable ly : this.cat.getLayerables()) {
            lstVisi.add(this.getLayerableVisibility(ly));
        }
        return lstVisi;
    }

    @Override
    public void setVisibilityForDirectChildren(Boolean setVisible) {
        for (ModelVisibility mv : this.getChildren()) {
            mv.setVisibilityForSelf(setVisible);
            if (!(mv instanceof CategoryVisibility)) continue;
            mv.setVisibilityForDirectChildren(setVisible);
        }
    }

    @Override
    public void setVisibilityForSelf(Boolean setVisible) {
        this.cat.setVisible(setVisible);
    }

    @Override
    public ModelVisibility getParent() {
        return this.parent;
    }

    @Override
    public Object getLayerModelObject() {
        return this.cat;
    }

    protected CategoryVisibility getCategoryVisibility(Category catChild) {
        return new CategoryVisibility(catChild, this);
    }

    protected LayerableVisibility getLayerableVisibility(Layerable ly) {
        return new LayerableVisibility(ly, this);
    }
}

