/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.model.CadLayerStyleDefinition;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineGlobalStyles {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineGlobalStyles.class);
    private static final String FILE_DEFAULT_STYLES = "default-styles.draw";
    private static final String STYLE_STANDARD = "Standard";
    private static RedlineGlobalStyles instance;
    private final RedlineLayer globalLayer = new RedlineLayerWithoutBuiltInSymbols();
    private final Comparator<String> styleComparator = Comparator.comparingInt(a -> BooleanUtils.toInteger((boolean)this.globalLayer.containsDrawingStyle((String)a))).reversed().thenComparing(a -> a);

    private RedlineGlobalStyles() {
        this.readStyles();
    }

    private void readStyles() {
        CadLayerStyleDefinition styles = this.getDefaultStylesFromFile().orElseGet(() -> new CadLayerStyleDefinition(0, 0, Collections.emptyMap(), Collections.singletonMap(STYLE_STANDARD, this.globalLayer.getDefaultFeature())));
        this.globalLayer.clearDrawingStyles();
        this.globalLayer.getRedlineSymbolStore().clear();
        styles.getStyles().forEach(this.globalLayer::addDrawingStyle);
        styles.getSymbols().forEach(this.globalLayer.getRedlineSymbolStore()::addSymbol);
    }

    private Optional<CadLayerStyleDefinition> getDefaultStylesFromFile() {
        File globalStyleFile = this.getGlobalStyleFile();
        if (!globalStyleFile.exists()) {
            return Optional.empty();
        }
        return RedlineLayerUtils.readStylesFromFile(globalStyleFile, null);
    }

    private File getGlobalStyleFile() {
        File jumpDir = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.JUMP.getDirectoryName());
        File defaultStyleFile = new File(jumpDir, FILE_DEFAULT_STYLES);
        return defaultStyleFile;
    }

    public void saveStyle(String name, SimpleFeature style, RedlineLayer sourceLayer) {
        this.globalLayer.addOrReplaceDrawingStyle(name, style);
        RedlineLayerUtils.addSymbolAndFillIfNecessary(this.globalLayer, sourceLayer, style);
        this.saveAllGlobalStyles();
        this.readStyles();
    }

    public void saveAllGlobalStyles() {
        RedlineLayerUtils.saveStylesToFile(this.globalLayer, this.globalLayer.getDrawingStyles().keySet(), this.getGlobalStyleFile(), null);
    }

    public SortedSet<String> getAllStyleNames(RedlineLayer layer) {
        TreeSet<String> combined = new TreeSet<String>(this.styleComparator);
        combined.addAll(layer.getDrawingStyles().keySet());
        combined.addAll(this.globalLayer.getDrawingStyles().keySet());
        return Collections.unmodifiableSortedSet(combined);
    }

    public int getStyleCount(RedlineLayer layer) {
        HashSet<String> combined = new HashSet<String>();
        combined.addAll(layer.getDrawingStyles().keySet());
        combined.addAll(this.globalLayer.getDrawingStyles().keySet());
        return combined.size();
    }

    public SimpleFeature getStyle(RedlineLayer layer, String name) {
        if (this.globalLayer.containsDrawingStyle(name)) {
            return this.globalLayer.getDrawingStyle(name);
        }
        return layer.getDrawingStyle(name);
    }

    public boolean containsStyle(RedlineLayer layer, String name) {
        if (this.globalLayer.containsDrawingStyle(name)) {
            return true;
        }
        return layer.containsDrawingStyle(name);
    }

    public boolean isGlobalStyle(String value) {
        return this.globalLayer.containsDrawingStyle(value);
    }

    public void copyOverGlobalSymbolsIfRequired(Layer destLayer, SimpleFeature feature) {
        RedlineLayerUtils.addSymbolAndFillIfNecessary(destLayer, this.globalLayer, feature, false);
    }

    public RedlineLayerSymbolStore getGlobalStore() {
        return this.globalLayer.getRedlineSymbolStore();
    }

    public Optional<String> addOrUpdateGlobalStylesAndSymbols(CadLayerStyleDefinition styleDefinitions, Set<String> stylesForFile) {
        Optional<String> first = RedlineLayerUtils.addOrUpdateStylesAndSymbols(this.globalLayer, styleDefinitions, stylesForFile);
        this.saveAllGlobalStyles();
        this.readStyles();
        return first;
    }

    public SimpleFeature getDefaultStyle() {
        return this.globalLayer.getDrawingStyles().values().stream().findFirst().orElseThrow();
    }

    public static RedlineGlobalStyles getInstance() {
        if (instance == null) {
            instance = new RedlineGlobalStyles();
        }
        return instance;
    }

    private static class RedlineLayerWithoutBuiltInSymbols
    extends RedlineLayer {
        public RedlineLayerWithoutBuiltInSymbols() {
            super("Fake Layer for Global Redline Styles", LayerManager.dummyLayerManager);
        }

        @Override
        public RedlineLayerSymbolStore getRedlineSymbolStore() {
            if (this.symbolStore == null) {
                this.symbolStore = RedlineLayerSymbolStore.createSimple();
            }
            return this.symbolStore;
        }

        @Override
        protected SimpleFeature initDefaultFeature() {
            return this.createDefaultWorkbenchFeature();
        }
    }
}

