/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.geotools.data.io.FeatureOutputStream;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.components.WaitDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;

public class RedlineFeatureOutputStream
extends FeatureOutputStream {
    private final RedlineLayer sourceLayer;
    private final WaitDialog waitDialog;

    public RedlineFeatureOutputStream(RedlineLayer rly, File file, WaitDialog dlgWait) throws IOException {
        super((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), rly.getFeatureType());
        Objects.requireNonNull(rly);
        this.sourceLayer = rly;
        this.waitDialog = dlgWait;
    }

    public void writeHeader() throws IOException {
        super.writeInt(6);
        super.writeUTF(this.sourceLayer.getName());
        super.writeUTF(this.sourceLayer.getDescription());
        super.writeInt(this.sourceLayer.getRenderPrio());
        super.writeBoolean(this.sourceLayer.isEditableInternal());
        super.writeBoolean(this.sourceLayer.isSelectable());
        super.writeBoolean(this.sourceLayer.isVisible());
        super.writeUTF(this.sourceLayer.getCRSDefinition().getKey());
        this.writeSymbolDefinitions(this.sourceLayer.getRedlineSymbolStore().getDefinitionsAndData());
        this.writeStyleDefinitions(this.sourceLayer.getDrawingStyles());
        super.writeInt(this.sourceLayer.getDrawScale());
    }

    private void writeSymbolDefinitions(Collection<Pair<CadLayerSymbolDefinition, ByteBuffer>> symbolDefs) throws IOException {
        super.writeInt(symbolDefs.size());
        for (Pair<CadLayerSymbolDefinition, ByteBuffer> pair : symbolDefs) {
            this.writeSymbolDefinition((CadLayerSymbolDefinition)pair.getLeft(), (ByteBuffer)pair.getRight());
        }
    }

    private void writeSymbolDefinition(CadLayerSymbolDefinition def, ByteBuffer data) throws IOException {
        super.writeUTF(def.getName());
        super.writeUTF(def.getSymbolName());
        super.writeInt(data.array().length);
        super.write(data.array());
    }

    private void writeStyleDefinitions(Map<String, SimpleFeature> drawingStyles) throws IOException {
        super.writeInt(drawingStyles.size());
        for (Map.Entry<String, SimpleFeature> entry : drawingStyles.entrySet()) {
            this.writeStyleDefinition(entry.getKey(), entry.getValue());
        }
    }

    private void writeStyleDefinition(String styleName, SimpleFeature styleDefinition) throws IOException {
        super.writeUTF(styleName);
        super.writeFeature(styleDefinition);
    }

    public void writeFeatures() throws IOException {
        block10: {
            try (FeatureIterator<SimpleFeature> fi = this.sourceLayer.getFeatureIterator((Envelope)null);){
                while (fi.hasNext()) {
                    if (this.waitDialog != null && !this.waitDialog.isVisible()) {
                        break;
                    }
                    super.writeFeature((SimpleFeature)fi.next());
                }
            }
            catch (Exception e) {
                if (this.waitDialog == null) break block10;
                this.waitDialog.setError(e);
            }
        }
    }

    public void writeStylesDefinitionStandalone(Set<String> styles) throws IOException {
        RedlineGlobalStyles globalStyles = RedlineGlobalStyles.getInstance();
        RedlineLayerSymbolStore redlineStore = this.sourceLayer.getRedlineSymbolStore();
        Map<String, SimpleFeature> styleDefs = styles.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), name -> globalStyles.getStyle(this.sourceLayer, (String)name)));
        List<Pair<CadLayerSymbolDefinition, ByteBuffer>> symbolDefs = styleDefs.values().stream().flatMap(feature -> Stream.of((String)FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.SYMBOL.getName()), (String)FeatureUtil.getAttribute((SimpleFeature)feature, (String)CadFeatureAtts.FILL.getName()))).filter(Objects::nonNull).distinct().map(name -> {
            Pair<CadLayerSymbolDefinition, ByteBuffer> definitionAndData = redlineStore.getDefinitionAndData((String)name);
            if (definitionAndData != null) {
                return definitionAndData;
            }
            return globalStyles.getGlobalStore().getDefinitionAndData((String)name);
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        super.writeInt(1);
        super.writeInt(6);
        this.writeSymbolDefinitions(symbolDefs);
        this.writeStyleDefinitions(styleDefs);
    }
}

