/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.model.CadLayerStyleDefinition;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import de.riwagis.geotools.data.io.FeatureInputStream;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.jts.JTSSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineFeatureInputStream
extends FeatureInputStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineFeatureInputStream.class);
    private final File file;
    private int intFeaturesIgnored = 0;
    private int version = -1;

    public RedlineFeatureInputStream(File file) throws IOException {
        super((InputStream)new GZIPInputStream(new FileInputStream(file)));
        this.file = file;
    }

    public Header readHeader() throws IOException {
        Assert.isTrue((this.version == -1 ? 1 : 0) != 0, (String)"Header was read twice.");
        Header header = new Header();
        header.setVersion(super.readInt());
        header.setName(super.readUTF());
        this.version = header.getVersion();
        if (this.version >= 3) {
            header.setDescription(super.readUTF());
            header.setRenderPrio(super.readInt());
            header.setEditable(super.readBoolean());
            header.setSelectable(super.readBoolean());
            header.setVisible(super.readBoolean());
        }
        if (this.version >= 4) {
            header.setCrsKey(super.readUTF());
        }
        if (this.version >= 5) {
            header.setSymbols(this.readSymbolDefinitions());
        }
        if (this.version >= 6) {
            header.setDrawingStyles(this.readStyleDefinitions(this.version));
        }
        header.setDrawScale(super.readInt());
        return header;
    }

    public File getFile() {
        return this.file;
    }

    private Map<CadLayerSymbolDefinition, ByteBuffer> readSymbolDefinitions() throws IOException {
        HashMap<CadLayerSymbolDefinition, ByteBuffer> symbols = new HashMap<CadLayerSymbolDefinition, ByteBuffer>();
        int symbolCount = super.readInt();
        for (int i = 0; i < symbolCount; ++i) {
            this.readSymbolDefinition(symbols);
        }
        return symbols;
    }

    private void readSymbolDefinition(Map<CadLayerSymbolDefinition, ByteBuffer> symbols) throws IOException {
        CadLayerSymbolDefinition def = new CadLayerSymbolDefinition(super.readUTF(), super.readUTF());
        ByteBuffer data = ByteBuffer.wrap(super.readNBytes(super.readInt()));
        symbols.put(def, data);
    }

    private Map<String, SimpleFeature> readStyleDefinitions(int version) throws IOException {
        LinkedHashMap<String, SimpleFeature> drawingStyles = new LinkedHashMap<String, SimpleFeature>();
        int drawingStyleCount = super.readInt();
        for (int i = 0; i < drawingStyleCount; ++i) {
            Pair<String, SimpleFeature> style = this.readStyleDefinition(version);
            drawingStyles.put((String)style.getKey(), (SimpleFeature)style.getValue());
        }
        return drawingStyles;
    }

    private Pair<String, SimpleFeature> readStyleDefinition(int version) throws IOException {
        String styleName = super.readUTF();
        SimpleFeature styleDef = RedlineLayerUtils.convertRedlineFeatureByVersion(super.readFeature(), version);
        return Pair.of((Object)styleName, (Object)styleDef);
    }

    public int skipHeader() throws IOException {
        int i;
        Assert.isTrue((this.version == -1 ? 1 : 0) != 0, (String)"Header was read twice.");
        this.version = super.readInt();
        super.readUTF();
        if (this.version >= 3) {
            super.readUTF();
            super.readInt();
            super.readBoolean();
            super.readBoolean();
            super.readBoolean();
        }
        if (this.version >= 4) {
            super.readUTF();
        }
        if (this.version >= 5) {
            int symbolCount = super.readInt();
            for (i = 0; i < symbolCount; ++i) {
                super.readUTF();
                super.readUTF();
                super.readNBytes(super.readInt());
            }
        }
        if (this.version >= 6) {
            int drawingStyleCount = super.readInt();
            for (i = 0; i < drawingStyleCount; ++i) {
                super.readUTF();
                super.readFeature();
            }
        }
        super.readInt();
        return this.version;
    }

    public Collection<SimpleFeature> readFeatures(FeaturestoreMetadata fmd) throws IOException {
        Assert.isTrue((this.version != -1 ? 1 : 0) != 0, (String)"Redline Header needs to be read before features.");
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        while (super.hasNextFeature()) {
            SimpleFeature f = RedlineLayerUtils.convertRedlineFeatureByVersion(super.readFeature(), this.version);
            if (f.getDefaultGeometry() != null && !((Geometry)f.getDefaultGeometry()).isEmpty()) {
                RedlineLayerUtils.fixInvalidGeometry(f);
                Geometry geom = (Geometry)f.getDefaultGeometry();
                if (geom.getClass().equals(GeometryCollection.class)) {
                    List lstGeom = JTSSupport.splitGeometryCollections((Geometry)geom);
                    f.setDefaultGeometry(lstGeom.get(0));
                    for (int i = 0; i < lstGeom.size(); ++i) {
                        SimpleFeature fclone = FeatureUtil.cloneFeature((SimpleFeature)f, (boolean)true);
                        fclone.setDefaultGeometry(lstGeom.get(i));
                        RedlineLayerUtils.fixInvalidGeometry(fclone);
                        if (RedlineLayerUtils.ignoreFeature(fmd, fclone)) {
                            log.error("Feature was ignored when loading redline layer. Geometry : " + String.valueOf(fclone.getDefaultGeometry()));
                            ++this.intFeaturesIgnored;
                            continue;
                        }
                        lstFeatures.add(fclone);
                    }
                }
            }
            if (RedlineLayerUtils.ignoreFeature(fmd, f)) {
                log.error("Feature was ignored when loading redline layer. Geometry : " + String.valueOf(f.getDefaultGeometry()));
                ++this.intFeaturesIgnored;
                continue;
            }
            lstFeatures.add(f);
        }
        return lstFeatures;
    }

    public CadLayerStyleDefinition readStyleDefinitionStandalone() throws IOException {
        int styleVersion = super.readInt();
        int redlineVersion = super.readInt();
        Map<CadLayerSymbolDefinition, ByteBuffer> symbols = this.readSymbolDefinitions();
        Map<String, SimpleFeature> styles = this.readStyleDefinitions(redlineVersion);
        return new CadLayerStyleDefinition(styleVersion, redlineVersion, symbols, styles);
    }

    public int getNumFeaturesIgnored() {
        return this.intFeaturesIgnored;
    }

    public static final class Header {
        int version;
        String name;
        String description = null;
        int renderPrio = 2000000000;
        boolean editable = true;
        boolean selectable = true;
        boolean visible = true;
        String crsKey = null;
        int drawScale;
        Map<CadLayerSymbolDefinition, ByteBuffer> symbols = Collections.emptyMap();
        Map<String, SimpleFeature> drawingStyles = Collections.emptyMap();

        @Generated
        public Header() {
        }

        @Generated
        public int getVersion() {
            return this.version;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public int getRenderPrio() {
            return this.renderPrio;
        }

        @Generated
        public boolean isEditable() {
            return this.editable;
        }

        @Generated
        public boolean isSelectable() {
            return this.selectable;
        }

        @Generated
        public boolean isVisible() {
            return this.visible;
        }

        @Generated
        public String getCrsKey() {
            return this.crsKey;
        }

        @Generated
        public int getDrawScale() {
            return this.drawScale;
        }

        @Generated
        public Map<CadLayerSymbolDefinition, ByteBuffer> getSymbols() {
            return this.symbols;
        }

        @Generated
        public Map<String, SimpleFeature> getDrawingStyles() {
            return this.drawingStyles;
        }

        @Generated
        public void setVersion(int version) {
            this.version = version;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setRenderPrio(int renderPrio) {
            this.renderPrio = renderPrio;
        }

        @Generated
        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        @Generated
        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }

        @Generated
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Generated
        public void setCrsKey(String crsKey) {
            this.crsKey = crsKey;
        }

        @Generated
        public void setDrawScale(int drawScale) {
            this.drawScale = drawScale;
        }

        @Generated
        public void setSymbols(Map<CadLayerSymbolDefinition, ByteBuffer> symbols) {
            this.symbols = symbols;
        }

        @Generated
        public void setDrawingStyles(Map<String, SimpleFeature> drawingStyles) {
            this.drawingStyles = drawingStyles;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getRenderPrio() != other.getRenderPrio()) {
                return false;
            }
            if (this.isEditable() != other.isEditable()) {
                return false;
            }
            if (this.isSelectable() != other.isSelectable()) {
                return false;
            }
            if (this.isVisible() != other.isVisible()) {
                return false;
            }
            if (this.getDrawScale() != other.getDrawScale()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$crsKey = this.getCrsKey();
            String other$crsKey = other.getCrsKey();
            if (this$crsKey == null ? other$crsKey != null : !this$crsKey.equals(other$crsKey)) {
                return false;
            }
            Map<CadLayerSymbolDefinition, ByteBuffer> this$symbols = this.getSymbols();
            Map<CadLayerSymbolDefinition, ByteBuffer> other$symbols = other.getSymbols();
            if (this$symbols == null ? other$symbols != null : !((Object)this$symbols).equals(other$symbols)) {
                return false;
            }
            Map<String, SimpleFeature> this$drawingStyles = this.getDrawingStyles();
            Map<String, SimpleFeature> other$drawingStyles = other.getDrawingStyles();
            return !(this$drawingStyles == null ? other$drawingStyles != null : !((Object)this$drawingStyles).equals(other$drawingStyles));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            result = result * 59 + this.getRenderPrio();
            result = result * 59 + (this.isEditable() ? 79 : 97);
            result = result * 59 + (this.isSelectable() ? 79 : 97);
            result = result * 59 + (this.isVisible() ? 79 : 97);
            result = result * 59 + this.getDrawScale();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $crsKey = this.getCrsKey();
            result = result * 59 + ($crsKey == null ? 43 : $crsKey.hashCode());
            Map<CadLayerSymbolDefinition, ByteBuffer> $symbols = this.getSymbols();
            result = result * 59 + ($symbols == null ? 43 : ((Object)$symbols).hashCode());
            Map<String, SimpleFeature> $drawingStyles = this.getDrawingStyles();
            result = result * 59 + ($drawingStyles == null ? 43 : ((Object)$drawingStyles).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RedlineFeatureInputStream.Header(version=" + this.getVersion() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", renderPrio=" + this.getRenderPrio() + ", editable=" + this.isEditable() + ", selectable=" + this.isSelectable() + ", visible=" + this.isVisible() + ", crsKey=" + this.getCrsKey() + ", drawScale=" + this.getDrawScale() + ", symbols=" + String.valueOf(this.getSymbols()) + ", drawingStyles=" + String.valueOf(this.getDrawingStyles()) + ")";
        }
    }
}

