/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedlineDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param FILE = new DataAccessFactory.Param("rly_file", File.class, "rly-file for redline Layer", false);
    private static final Logger LOG = LoggerFactory.getLogger(RedlineDataStoreFactory.class);

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        LOG.debug("create RedlineDataStore with params " + String.valueOf(params));
        RedlineDataStore ds = null;
        if (params.containsKey(RedlineDataStoreFactory.FILE.key)) {
            File file = (File)FILE.lookUp(params);
            ds = new RedlineDataStore(null, file);
        } else {
            ds = new RedlineDataStore(null);
        }
        return ds;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        LOG.debug("create new RedlineDataStore with params " + String.valueOf(params));
        RedlineDataStore ds = null;
        if (params.containsKey(RedlineDataStoreFactory.FILE.key)) {
            File file = (File)FILE.lookUp(params);
            ds = new RedlineDataStore(null, file);
        } else {
            ds = new RedlineDataStore(null);
        }
        return ds;
    }

    public String getDisplayName() {
        return "redline";
    }

    public String getDescription() {
        return "datastore factory for redline layer ";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE};
    }

    public boolean isAvailable() {
        return true;
    }
}

