/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.redline.RedLineFeatureWriter;
import com.vividsolutions.jump.workbench.model.redline.RedLineFeatureWriterAppend;
import com.vividsolutions.jump.workbench.model.redline.RedlineFeatureCollection;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import de.riwagis.geotools.feature.DelegateFeatureReader;
import de.riwagis.util.gui.ExceptionDialog;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class RedlineDataStore
extends ContentDataStore {
    public static final String DATASTORE_NAME = "redline";
    private RedlineFeatureCollection collection = null;
    private RedlineLayer layer = null;
    private File file = null;
    private boolean collectionModified = false;
    private long lngFileLastModified = Long.MIN_VALUE;

    public RedlineDataStore(RedlineLayer layer) {
        this(layer, null, null);
    }

    public RedlineDataStore(RedlineLayer layer, File file) {
        this(layer, null, file);
    }

    public RedlineDataStore(RedlineLayer layer, RedlineFeatureCollection collection) {
        this(layer, collection, null);
    }

    public RedlineDataStore(RedlineLayer layer, RedlineFeatureCollection collection, File file) {
        this.layer = layer;
        this.collection = collection;
        this.file = file;
    }

    public boolean isFeatureCollectionModified() {
        return this.collectionModified;
    }

    public synchronized RedlineFeatureCollection getInternalFeatureCollection() {
        if (this.collection == null) {
            this.collection = new RedlineFeatureCollection();
            if (this.file != null && this.file.exists()) {
                try {
                    RedlineLayerUtils.readFeatures(this.layer, this.file);
                }
                catch (IOException ex) {
                    ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)ex, RedlineLayer.class);
                }
            }
            this.collectionModified = false;
        }
        return this.collection;
    }

    public void addFeatures(Collection<SimpleFeature> features) {
        this.getInternalFeatureCollection().addAll(features);
    }

    public File getFileInternal() {
        return this.file;
    }

    public void setFileInternal(File file) {
        if (file != null && file.equals(this.file)) {
            return;
        }
        if (file != null && this.file != null && this.file.exists()) {
            this.getInternalFeatureCollection();
        }
        if (file == null) {
            this.lngFileLastModified = Long.MIN_VALUE;
        } else {
            if (!file.exists()) {
                RedlineLayerUtils.saveLayerToFile(this.layer, file, null);
                this.setFeatureCollectionModified(false);
            }
            this.lngFileLastModified = file.lastModified();
        }
        this.file = file;
    }

    public RedlineLayer getLayer() {
        return this.layer;
    }

    public void setLayer(RedlineLayer layer) {
        this.layer = layer;
    }

    public long getFileLastModified() {
        return this.lngFileLastModified;
    }

    public boolean storeFeatures(boolean withModifiedFeatures) {
        if (this.file == null) {
            return false;
        }
        RedlineLayerUtils.saveLayerToFile(this.layer, this.file, null, withModifiedFeatures);
        this.lngFileLastModified = this.file.lastModified();
        if (withModifiedFeatures) {
            this.collectionModified = false;
        }
        return true;
    }

    public void resetFeatureCollection() {
        this.getInternalFeatureCollection().clear();
        if (this.file != null && this.file.exists()) {
            try {
                RedlineLayerUtils.readFeatures(this.layer, this.file);
            }
            catch (IOException ex) {
                ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)ex, RedlineLayer.class);
            }
        }
        this.collectionModified = false;
    }

    protected List<Name> createTypeNames() {
        NameImpl typeName = new NameImpl(this.layer.getDefaultFeatureType().getTypeName());
        return Collections.singletonList(typeName);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) {
        ContentFeatureStore featureStore = new ContentFeatureStore(entry, Query.ALL){

            public QueryCapabilities getQueryCapabilities() {
                if (this.queryCapabilities == null) {
                    this.queryCapabilities = new QueryCapabilities(this){

                        public boolean isUseProvidedFIDSupported() {
                            return true;
                        }
                    };
                }
                return this.queryCapabilities;
            }

            protected ReferencedEnvelope getBoundsInternal(Query query) {
                SimpleFeatureIterator iterator = RedlineDataStore.this.getInternalFeatureCollection().features();
                ReferencedEnvelope envelope = new ReferencedEnvelope();
                if (iterator.hasNext()) {
                    int count = 1;
                    Filter filter = query.getFilter();
                    SimpleFeature f = (SimpleFeature)iterator.next();
                    Geometry geom = (Geometry)f.getDefaultGeometry();
                    if (geom != null) {
                        envelope = new ReferencedEnvelope(geom.getEnvelopeInternal(), null);
                        while (iterator.hasNext() && count < query.getMaxFeatures()) {
                            SimpleFeature feature = (SimpleFeature)iterator.next();
                            if (!filter.evaluate((Object)feature)) continue;
                            ++count;
                            if (feature.getDefaultGeometry() == null) continue;
                            envelope.expandToInclude(((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal());
                        }
                    }
                }
                return envelope;
            }

            protected int getCountInternal(Query query) throws IOException {
                String featureTypeName = query.getTypeName();
                if (!RedlineDataStore.this.layer.getDefaultFeatureType().getTypeName().equals(featureTypeName)) {
                    throw new SchemaNotFoundException(featureTypeName);
                }
                int count = 0;
                SimpleFeatureIterator iterator = RedlineDataStore.this.getInternalFeatureCollection().features();
                Filter filter = query.getFilter();
                while (iterator.hasNext() && count < query.getMaxFeatures()) {
                    if (!filter.evaluate((Object)iterator.next())) continue;
                    ++count;
                }
                return count;
            }

            protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) {
                return new DelegateFeatureReader((FeatureType)this.getSchema(), (FeatureIterator)RedlineDataStore.this.getInternalFeatureCollection().features());
            }

            protected SimpleFeatureType buildFeatureType() {
                return RedlineDataStore.this.layer.getDefaultFeatureType();
            }

            protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
                String typeName = query.getTypeName();
                if (typeName != null && typeName.equals(RedlineDataStore.this.layer.getDefaultFeatureType().getTypeName())) {
                    if ((flags & 1) == 1) {
                        return new RedLineFeatureWriterAppend(RedlineDataStore.this.getInternalFeatureCollection());
                    }
                    return new RedLineFeatureWriter(RedlineDataStore.this.getInternalFeatureCollection(), query.getFilter());
                }
                throw new IOException(typeName + " not available");
            }
        };
        featureStore.addFeatureListener(featureEvent -> {
            this.collectionModified = true;
        });
        return featureStore;
    }

    public void setFeatureCollectionModified(boolean collectionModified) {
        this.collectionModified = collectionModified;
        this.getInternalFeatureCollection().setModified(collectionModified);
    }

    public void removeSchema(Name typeName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(String typeName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

