/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.redline;

import com.vividsolutions.jump.workbench.model.redline.RedlineFeatureCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class RedLineFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private FeatureIterator<SimpleFeature> iter = null;
    private SimpleFeature currFeature = null;
    private SimpleFeature copyCurrFeature = null;
    private RedlineFeatureCollection collection = null;
    private Collection<SimpleFeature> removedFeatures = new ArrayList<SimpleFeature>();

    public RedLineFeatureWriter(RedlineFeatureCollection collection, Filter filter) {
        this.collection = collection;
        this.iter = this.collection.subCollection(filter).features();
    }

    public SimpleFeatureType getFeatureType() {
        return this.collection.getSchema();
    }

    public SimpleFeature next() throws IOException {
        this.currFeature = (SimpleFeature)this.iter.next();
        this.copyCurrFeature = SimpleFeatureBuilder.copy((SimpleFeature)this.currFeature);
        return this.copyCurrFeature;
    }

    public void remove() throws IOException {
        if (this.currFeature == null) {
            throw new IllegalStateException("no current feature set, feature iterator may be not initialized");
        }
        this.removedFeatures.add(this.currFeature);
    }

    public void write() throws IOException {
        if (this.currFeature == null) {
            throw new IllegalStateException("no current feature set, feature iterator may be not initialized");
        }
        this.currFeature.setAttributes(this.copyCurrFeature.getAttributes());
    }

    public boolean hasNext() throws IOException {
        return this.iter.hasNext();
    }

    public void close() throws IOException {
        this.iter.close();
        this.iter = null;
        if (!this.removedFeatures.isEmpty()) {
            this.collection.removeAll(this.removedFeatures);
            this.removedFeatures.clear();
        }
        this.removedFeatures = null;
    }

    protected void finalize() throws Throwable {
        if (this.iter != null) {
            this.iter.close();
            this.iter = null;
        }
        if (this.removedFeatures != null && !this.removedFeatures.isEmpty()) {
            this.collection.removeAll(this.removedFeatures);
            this.removedFeatures.clear();
            this.removedFeatures = null;
        }
        super.finalize();
    }
}

