/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.io.SessionCacheDirectory;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.HasLayerContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSStyleRenderer;
import com.vividsolutions.ows.wmts.GetTileRequest;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.TileMatrix;
import com.vividsolutions.ows.wmts.TileMatrixSet;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.crs.Transformer;
import de.riwagis.gis.context.jump.WMTSLayerContextImpl;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.WMTSLayerContext;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.util.ThrowingFunction;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="wmtsLayer")
public class WMTSLayer
extends AbstractLayerable
implements HasLayerContext {
    private static final Logger LOG = LoggerFactory.getLogger(WMTSLayer.class);
    private final Blackboard blackboard = new Blackboard();
    private transient Envelope env = null;
    private transient CoordinateReferenceSystem lastTaskCrs = null;
    private transient WMTSLayerContext wmtsLayerContext = null;

    public WMTSLayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMTSLayer(String strName, LayerManager layerManager, WMTSStyleModel style) {
        super(strName, layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            SimpleStyleCollection sColDefault = new SimpleStyleCollection(this, true);
            sColDefault.addStyle((StyleModel)style);
            this.addStyleCollection(sColDefault);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        SimpleStyleCollection sColDefault = new SimpleStyleCollection(this, true);
        sColDefault.addStyle((StyleModel)new WMTSStyleModel());
        return sColDefault;
    }

    @Deprecated
    public WMTSStyleModel getValidWMTSStyle() {
        return this.getValidStyle(WMTSStyleModel.class);
    }

    @Deprecated
    public WMTSStyleModel getDefaultWMTSStyle() {
        return this.getDefaultStyle(WMTSStyleModel.class);
    }

    public BufferedImage requestTileImage(String tileMatrix, int row, int col, File tmpTile, CancelableRunnable runnable) throws IOException {
        GetTileRequest request = this.createRequest(tileMatrix, row, col);
        byte[] imageData = request.getImageData(runnable);
        if (imageData == null) {
            return null;
        }
        Files.write(tmpTile.toPath(), imageData, new OpenOption[0]);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageData);){
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            return bufferedImage;
        }
    }

    private GetTileRequest createRequest(String tileMatrix, int row, int col) throws IOException {
        WMTSStyleModel style = this.getValidWMTSStyle();
        GetTileRequest request = this.getService().createGetTileRequest();
        request.setLayer(style.getLayerName());
        request.setFormat(style.getFormat());
        request.setStyle(style.getStyle());
        request.setTileMatrixSet(style.getTileMatrixSet());
        request.setTileMatrix(tileMatrix);
        request.setTileRow(row);
        request.setTileCol(col);
        return request;
    }

    public WMTService getService() throws IOException {
        WMTSStyleModel style = this.getValidWMTSStyle();
        if (style == null) {
            throw new RuntimeException("Can't find WMTS Service for given style object");
        }
        return ((WMTSStyleRenderer)style.getIntelligence()).getWMTService();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Envelope getEnvelope() {
        CoordinateReferenceSystem crsTarget = this.getLayerManager().getTask().getCRSDefinition().getCRS();
        if (this.env != null && !this.env.isNull() && CRS.equalsIgnoreMetadata((Object)crsTarget, (Object)this.lastTaskCrs)) return this.env;
        this.lastTaskCrs = crsTarget;
        try {
            DefaultGeographicCRS crsEnv;
            WMTSStyleModel style = this.getValidWMTSStyle();
            if (style == null) {
                style = this.getDefaultWMTSStyle();
            }
            if (style == null) {
                return new Envelope();
            }
            String layerName = style.getLayerName();
            Layer layer = this.getService().getCapabilities().getLayerByName(layerName);
            ReferencedEnvelope bBox = layer.getWGS84BoundingBox();
            if (bBox == null) {
                String tileMatrixId = layer.getTileMatrixSetLinks().iterator().next();
                TileMatrixSet tileMatrixSet = this.getService().getCapabilities().getTileMatrixSetByName(tileMatrixId);
                if (tileMatrixSet == null) return new Envelope();
                crsEnv = tileMatrixSet.getCoordinateReferenceSystem();
                this.env = tileMatrixSet.getTileMatrices().stream().min((tms1, tms2) -> (int)(tms1.getScaleDenominator() - tms2.getScaleDenominator())).map(tm -> {
                    Coordinate topLeft = new Coordinate(tm.getTopLeft()[0], tm.getTopLeft()[1]);
                    double width = (double)(tm.getMatrixWidth() * tm.getTileWidth()) * tm.getScaleDenominator() * 2.8E-4;
                    double height = (double)(tm.getMatrixHeight() * tm.getTileHeight()) * tm.getScaleDenominator() * 2.8E-4;
                    return new Envelope(topLeft, new Coordinate(topLeft.x + width, topLeft.y - height));
                }).orElseGet(Envelope::new);
            } else {
                this.env = new Envelope((Envelope)bBox);
                crsEnv = DefaultGeographicCRS.WGS84;
            }
            try {
                if (crsEnv == null || crsTarget == null || CRS.equalsIgnoreMetadata((Object)crsEnv, (Object)crsTarget)) return this.env;
                Transformer trans = new Transformer((CoordinateReferenceSystem)crsEnv, crsTarget);
                trans.transform2d(this.env);
                return this.env;
            }
            catch (Exception e) {
                this.env = new Envelope();
                Assert.shouldNeverReachHere((String)String.format("error during transformation: %s", e.getMessage()));
            }
            return this.env;
        }
        catch (Exception e) {
            this.env = new Envelope();
        }
        return this.env;
    }

    public TileMatrixSet getTileMatrixSet() throws IOException {
        WMTSStyleModel style = this.getValidWMTSStyle();
        return this.getService().getCapabilities().getTileMatrixSetByName(style.getTileMatrixSet());
    }

    @Override
    public void setStyleCollections(Collection<StyleCollection> styleCollections) {
        this.env = null;
        super.setStyleCollections(styleCollections);
    }

    @Override
    public LayerContext getLayerContext() {
        return this.getWMTSLayerContext();
    }

    public WMTSLayerContext getWMTSLayerContext() {
        if (this.wmtsLayerContext == null) {
            this.wmtsLayerContext = new WMTSLayerContextImpl(this);
        }
        return this.wmtsLayerContext;
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    @Override
    public int getLayerType() {
        return 7;
    }

    public BufferedImage createImage(Layer layer, TileMatrix tm, int row, int col, CancelableRunnable runnable, ThrowingFunction<File, BufferedImage, Exception> imageGetter) throws Exception {
        String cacheDirectoryPath = SessionCacheDirectory.get();
        int serverHashCode = this.getService().isInternal() ? this.getService().getServerUrlExt().hashCode() : this.getService().getServerUrl().hashCode();
        WMTSStyleModel style = this.getValidWMTSStyle();
        File tile = new File(WMTSLayer.buildTilePath(cacheDirectoryPath, this.getService().isInternal(), serverHashCode, layer.getIdentifier(), style.getStyle(), layer.getTimestamp(), this.getTileMatrixSet().getIdentifier(), tm.getIdentifier(), row, col, style.getFormat()));
        if (tile.exists()) {
            FileUtils.touch((File)tile);
            return this.readTile(tile);
        }
        try {
            tile.getParentFile().mkdirs();
            return this.createTile(tile, runnable, imageGetter::apply);
        }
        catch (Exception ex) {
            LOG.error(String.format("error loading tile from wmts: %s", tile.getAbsolutePath()), (Throwable)ex);
            throw new IOException(ex);
        }
    }

    public BufferedImage createImage(Layer layer, TileMatrix tm, int row, int col, CancelableRunnable runnable) throws Exception {
        return this.createImage(layer, tm, row, col, runnable, tmpTile -> this.getImageOrFallback(layer, tm, row, col, runnable, (File)tmpTile));
    }

    private BufferedImage createImageSimple(Layer layer, TileMatrix tm, int row, int col, CancelableRunnable runnable) throws Exception {
        return this.createImage(layer, tm, row, col, runnable, tmpTile -> this.requestTileImage(tm.getIdentifier(), row, col, (File)tmpTile, runnable));
    }

    private BufferedImage createImageNoCacheOn404(Layer layer, TileMatrix tm, int row, int col, CancelableRunnable runnable) throws Exception {
        return this.createImage(layer, tm, row, col, runnable, targetFile -> {
            BufferedImage bufferedImage = this.requestTileImage(tm.getIdentifier(), row, col, (File)targetFile, runnable);
            if (bufferedImage == null && targetFile.exists()) {
                targetFile.delete();
            }
            return bufferedImage;
        });
    }

    private BufferedImage getImageFromCoarseLevel(Layer layer, TileMatrix tm, int finalRow, int finalCol, CancelableRunnable runnable, File tmpFile) throws Exception {
        int baseLevel;
        if (runnable.isCanceled()) {
            return null;
        }
        List<TileMatrix> tileMatrices = this.getTileMatrixSet().getTileMatricesByScaleDenominator();
        int index = baseLevel = tileMatrices.indexOf(tm);
        int factor = 1;
        LinkedList<Triple> quadrants = new LinkedList<Triple>();
        BufferedImage baseImage = null;
        while (index > 0 && baseImage == null) {
            int partialRow = finalRow / factor;
            int partialCol = finalCol / factor;
            quadrants.addFirst(Triple.of((Object)partialCol, (Object)partialRow, (Object)tileMatrices.get(--index + 1)));
            baseImage = this.createImageNoCacheOn404(layer, tileMatrices.get(index), partialRow / 2, partialCol / 2, runnable);
            factor *= 2;
        }
        if (baseImage == null) {
            return null;
        }
        BufferedImage finalImage = baseImage;
        for (Triple quadrant : quadrants) {
            BufferedImage halfImage;
            int rowOffset = (Integer)quadrant.getMiddle() % 2;
            int columnOffset = (Integer)quadrant.getLeft() % 2;
            int row = (Integer)quadrant.getMiddle();
            int column = (Integer)quadrant.getLeft();
            TileMatrix tileSet = (TileMatrix)quadrant.getRight();
            BufferedImage pImage = finalImage;
            int halfWidth = pImage.getWidth() / 2;
            int halfHeight = pImage.getHeight() / 2;
            BufferedImage bufferedImage = halfImage = halfWidth == 1 || halfHeight == 1 ? pImage : pImage.getSubimage(halfWidth * columnOffset, halfHeight * rowOffset, halfWidth, halfHeight);
            if (finalRow == row && finalCol == column) {
                finalImage = halfImage;
                this.writeAndReadImage(halfImage, tmpFile);
                continue;
            }
            finalImage = this.createImage(layer, tileSet, row, column, runnable, targetFile -> this.writeAndReadImage(halfImage, (File)targetFile));
            System.out.println(finalImage);
        }
        if (finalImage == null) {
            LOG.trace("There is no coarse level to {} for tile {}/{}", new Object[]{tm.getIdentifier(), finalRow, finalCol});
            return null;
        }
        return finalImage;
    }

    public BufferedImage writeAndReadImage(BufferedImage halfImage, File tmpFile) throws IOException {
        String filename = FilenameUtils.removeExtension((String)tmpFile.toString());
        if (!ImageIO.write((RenderedImage)halfImage, FilenameUtils.getExtension((String)filename), tmpFile)) {
            LOG.warn("There was no appropriate image writer for file '{}'", (Object)filename);
        }
        return ImageIO.read(tmpFile);
    }

    private BufferedImage readTile(File file) throws IOException {
        return ImageIO.read(file);
    }

    private BufferedImage createTile(File tile, CancelableRunnable cancelable, ThrowingFunction<File, BufferedImage, Exception> imageGetter) throws Exception {
        File tmpTile = new File(tile.getAbsolutePath() + ".tmp");
        tmpTile.getParentFile().mkdirs();
        boolean tmpTileCreated = tmpTile.createNewFile();
        if (!tmpTileCreated) {
            while (!tile.exists() && tmpTile.exists()) {
                long lastModified = tmpTile.lastModified();
                if (System.currentTimeMillis() - lastModified > 60000L) {
                    boolean deleted = tmpTile.delete();
                    if (deleted) break;
                    LOG.error("cant delete temporary tile: {}", (Object)tmpTile.getAbsolutePath());
                    break;
                }
                Thread.sleep(100L);
            }
            if (tile.exists()) {
                return this.readTile(tile);
            }
        }
        try {
            BufferedImage image = imageGetter.apply(tmpTile);
            if (cancelable != null && cancelable.isCanceled()) {
                tmpTile.delete();
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            tmpTile.delete();
            throw e;
        }
        finally {
            tmpTile.renameTo(tile);
            if (tmpTile.exists()) {
                tmpTile.delete();
            }
        }
    }

    private BufferedImage getImageOrFallback(Layer layer, TileMatrix tm, int row, int col, CancelableRunnable cancelable, File tmpTile) throws Exception {
        BufferedImage image = this.requestTileImage(tm.getIdentifier(), row, col, tmpTile, cancelable);
        if (image == null) {
            return this.getImageFromCoarseLevel(layer, tm, row, col, cancelable, tmpTile);
        }
        return image;
    }

    public static String buildTilePath(String cacheDirectoryPath, boolean internal, int serverHashCode, String layerName, String style, long timestamp, String tms, String tm, int row, int col, String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(cacheDirectoryPath);
        if (!cacheDirectoryPath.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("wmts").append(File.separator);
        if (internal) {
            sb.append("rgz").append(File.separator);
        }
        sb.append(serverHashCode).append(File.separator);
        sb.append(FileSupport.removeIllegalCharsFromFilename((String)layerName)).append(File.separator);
        sb.append(FileSupport.removeIllegalCharsFromFilename((String)style)).append(File.separator);
        sb.append(timestamp).append(File.separator);
        sb.append(FileSupport.removeIllegalCharsFromFilename((String)tms)).append(File.separator);
        sb.append(FileSupport.removeIllegalCharsFromFilename((String)tm)).append(File.separator);
        sb.append(row).append(File.separator);
        sb.append(col).append(WMTSLayer.getFileSuffix(format));
        return sb.toString();
    }

    public static String getFileSuffix(String mimetype) {
        String fileSuffix = ".jpg";
        if (StringUtils.isEmpty((CharSequence)mimetype)) {
            return fileSuffix;
        }
        if ((mimetype = mimetype.toLowerCase()).endsWith("png")) {
            fileSuffix = ".png";
        }
        if (mimetype.endsWith("tiff")) {
            fileSuffix = ".tif";
        }
        if (mimetype.endsWith("gif")) {
            fileSuffix = ".gif";
        }
        return fileSuffix;
    }

    public static String getFileFormat(String mimetype) {
        String fileSuffix = "jpg";
        if (StringUtils.isEmpty((CharSequence)mimetype)) {
            return fileSuffix;
        }
        if ((mimetype = mimetype.toLowerCase()).endsWith("png")) {
            fileSuffix = "png";
        }
        if (mimetype.endsWith("tiff")) {
            fileSuffix = "tif";
        }
        if (mimetype.endsWith("gif")) {
            fileSuffix = "gif";
        }
        return fileSuffix;
    }

    public static BufferedImage makeBufferedImage(Image im) {
        BufferedImage copy = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics2D g2d = copy.createGraphics();
        g2d.drawImage(im, 0, 0, null);
        g2d.dispose();
        return copy;
    }

    @Override
    public Collection<Layerable> reload() {
        try {
            WMTSStyleModel style = this.getValidWMTSStyle();
            if (style == null) {
                throw new IOException("Can't find WMTS Service for given style object");
            }
            WMTSStyleRenderer renderer = (WMTSStyleRenderer)style.getIntelligence();
            if (renderer != null && renderer.doesWMTServiceNeedInitialisation()) {
                renderer.getWMTService();
            } else if (renderer != null) {
                renderer.getWMTService().initialize();
            }
        }
        catch (IOException e) {
            LOG.error("WMTS could not be initialized", (Throwable)e);
        }
        return super.reload();
    }
}

