/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.HasLayerContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStyleRenderer;
import com.vividsolutions.ows.wms.BoundingBox;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.MapRequest;
import com.vividsolutions.ows.wms.WMService;
import de.riwagis.crs.Transformer;
import de.riwagis.gis.context.jump.WMSLayerContextImpl;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.WMSLayerContext;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.util.thread.Cancelable;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.GeneralDirectPosition;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.DirectPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="wmsLayer")
public class WMSLayer
extends AbstractLayerable
implements HasLayerContext {
    private static final Logger LOG = LoggerFactory.getLogger(WMSLayer.class);
    private final Blackboard blackboard = new Blackboard();
    private transient Envelope env = null;
    private transient WMSLayerContext wmsLayerContext = null;
    public static final String DEFAULT_TILE_SIZE_KEY = WMSLayer.class.getName() + "_DEFAULT_TILE_SIZE";
    public static final int DEFAULT_TILE_SIZE = 2000;

    public WMSLayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMSLayer(String strName, LayerManager layerManager, WMSStyleModel style) {
        super(strName, layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            SimpleStyleCollection sColDefault = new SimpleStyleCollection(this, true);
            sColDefault.addStyle((StyleModel)style);
            this.addStyleCollection(sColDefault);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        SimpleStyleCollection sColDefault = new SimpleStyleCollection(this, true);
        sColDefault.addStyle((StyleModel)new WMSStyleModel());
        return sColDefault;
    }

    @Deprecated
    public WMSStyleModel getValidWMSStyle() {
        return this.getValidStyle(WMSStyleModel.class);
    }

    @Deprecated
    public WMSStyleModel getDefaultWMSStyle() {
        return this.getDefaultStyle(WMSStyleModel.class);
    }

    public Image createImage(LayerView panel, Cancelable runnable) throws IOException {
        Image image = this.createRequest(panel).getImage(runnable);
        if (runnable != null && runnable.isCanceled()) {
            return null;
        }
        return this.setupTransparency(image);
    }

    public Image createImage(LayerView panel, int x, int y, int width, int height, WMSStyleModel style, CancelableRunnable runnable) throws IOException {
        if (style == null) {
            return null;
        }
        MapRequest request = this.createRequest(style, panel, x, y, width, height);
        Image image = request.getImage((Cancelable)runnable);
        if (runnable != null && runnable.isCanceled()) {
            return null;
        }
        return this.setupTransparency(image);
    }

    private MapRequest createRequest(WMSStyleModel style, LayerView panel, int x, int y, int width, int height) throws IOException {
        try {
            MapRequest request = ((WMSStyleRenderer)style.getIntelligence()).getWMService().createMapRequest();
            Viewport viewport = panel.getViewport();
            request.setBoundingBox(this.toBoundingBox(style.getSRS(), viewport.toModelEnvelope(x, x + width, y, y + height)));
            request.setFormat(style.getFormat());
            request.setImageWidth(panel.scale(width));
            request.setImageHeight(panel.scale(height));
            request.setLayerNames(style.getVisibleLayerNames());
            request.setTransparent(true);
            return request;
        }
        catch (NoninvertibleTransformException ex) {
            throw new IOException(ex);
        }
    }

    public MapRequest createRequest(LayerView panel) throws IOException {
        WMSStyleModel style = this.getValidWMSStyle();
        if (style == null) {
            return null;
        }
        return this.createRequest(style, panel, 0, 0, panel.getWidth(), panel.getHeight());
    }

    private Image setupTransparency(Image img) {
        if (img == null) {
            return null;
        }
        WMSStyleModel wmsStyle = this.getValidWMSStyle();
        if (wmsStyle == null) {
            return null;
        }
        if (!wmsStyle.isUseClearColor()) {
            return img;
        }
        BufferedImage bim = !(img instanceof BufferedImage) ? WMSLayer.makeBufferedImage(img) : (BufferedImage)img;
        ColorModel cm = bim.getColorModel();
        if (wmsStyle.getClearColor() == null) {
            return null;
        }
        int transparentColor = RiwaJumpModelUtilities.colorByColorModel(wmsStyle.getClearColor()).getRGB();
        if (!cm.hasAlpha()) {
            bim = WMSLayer.makeBufferedImage(bim);
            cm = bim.getColorModel();
        }
        LOG.debug("Current colormodel: {}", (Object)cm);
        for (int w = 0; w < bim.getWidth(); ++w) {
            for (int h = 0; h < bim.getHeight(); ++h) {
                int currentColor = bim.getRGB(w, h);
                if (currentColor != transparentColor) continue;
                ByteBuffer bbuf = ByteBuffer.allocate(4);
                bbuf.putInt(currentColor);
                byte[] arrColor = bbuf.array();
                arrColor[0] = 0;
                bbuf.clear();
                bbuf.put(arrColor);
                bbuf.flip();
                int newColor = bbuf.getInt();
                bim.setRGB(w, h, newColor);
            }
        }
        return bim;
    }

    @Override
    public Collection<Layerable> reload() {
        try {
            WMSStyleModel style = this.getValidWMSStyle();
            if (style == null) {
                throw new IOException("Can't find WMS Service for given style object");
            }
            WMSStyleRenderer renderer = (WMSStyleRenderer)style.getIntelligence();
            if (renderer != null && renderer.doesWMServiceNeedInitialisation()) {
                renderer.getWMService();
            } else if (renderer != null) {
                renderer.getWMService().initialize();
            }
        }
        catch (IOException e) {
            LOG.error("WMS could not be initialized", (Throwable)e);
        }
        return super.reload();
    }

    public String[][] getFeatureInfo(LayerViewPanel panel, Point clickPoint) throws IOException {
        int mapHeight;
        int mapWidth;
        MapRequest req;
        WMSStyleModel style = this.getValidWMSStyle();
        if (style == null) {
            return null;
        }
        int mapSize = this.determineTileSize();
        int maxWidth = ((WMSStyleRenderer)style.getIntelligence()).getWMService().getCapabilities().getMaxWidth();
        int maxHeight = ((WMSStyleRenderer)style.getIntelligence()).getWMService().getCapabilities().getMaxHeight();
        int tileWidth = maxWidth < 1 ? mapSize : Math.min(mapSize, maxWidth);
        int tileHeight = maxHeight < 1 ? mapSize : Math.min(mapSize, maxHeight);
        int xTile = 0;
        int yTile = 0;
        boolean found = false;
        for (int i = 0; i < panel.getWidth(); i += tileWidth) {
            for (int j = 0; j < panel.getHeight(); j += tileHeight) {
                if (clickPoint.x > i + tileWidth || clickPoint.y > j + tileHeight) continue;
                xTile = i;
                yTile = j;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!(req = this.createRequest(style, panel, xTile, yTile, mapWidth = Math.min(tileWidth, panel.getWidth()), mapHeight = Math.min(tileHeight, panel.getHeight()))).getQueryable()) {
            return new String[3][0];
        }
        req.setX(panel.scale(clickPoint.x - xTile));
        req.setY(panel.scale(clickPoint.y - yTile));
        String defaultCharset = style.getDefaultFeatureInfoCharset();
        if (StringUtils.isNotEmpty((CharSequence)defaultCharset)) {
            req.setDefaultFeatureInfoCharset(defaultCharset);
        }
        return req.getFeatureInfo();
    }

    private BoundingBox toBoundingBox(String srs, Envelope e) {
        return new BoundingBox(srs, e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY());
    }

    public WMService getService() throws IOException {
        WMSStyleModel style = this.getValidWMSStyle();
        if (style == null) {
            return null;
        }
        return ((WMSStyleRenderer)style.getIntelligence()).getWMService();
    }

    public int determineTileSize() {
        Blackboard bb = PersistentBlackboardPlugIn.get();
        return bb.get(DEFAULT_TILE_SIZE_KEY, 2000);
    }

    @Override
    public Envelope getEnvelope() {
        if (this.env == null || this.env.isNull()) {
            try {
                ArrayList<BoundingBox> lstBBox = new ArrayList<BoundingBox>();
                WMSStyleModel style = this.getValidWMSStyle();
                if (style == null) {
                    style = this.getDefaultWMSStyle();
                }
                if (style == null) {
                    return new Envelope();
                }
                List<MapLayer> lstAllLayers = ((WMSStyleRenderer)style.getIntelligence()).getWMService().getCapabilities().getTopLayer().getLayerList();
                List lstLayerNames = style.getVisibleLayerNames();
                for (MapLayer mapLayer : lstAllLayers) {
                    for (String strLayerName : lstLayerNames) {
                        BoundingBox bBox;
                        if (mapLayer.getName() == null || !mapLayer.getName().equals(strLayerName) || (bBox = mapLayer.getLatLonBoundingBox()) == null) continue;
                        lstBBox.add(bBox);
                    }
                }
                this.env = new Envelope();
                Transformer trans = null;
                for (BoundingBox bBox : lstBBox) {
                    String strSRS = "EPSG:4326";
                    if (!style.getSRS().equalsIgnoreCase("CRS:84")) {
                        strSRS = style.getSRS().toUpperCase();
                    }
                    if (trans == null) {
                        trans = new Transformer("EPSG:4326", strSRS);
                    }
                    Coordinate coordMin = trans.transform2d((DirectPosition)new GeneralDirectPosition(bBox.getMinX(), bBox.getMinY()));
                    Coordinate coordMax = trans.transform2d((DirectPosition)new GeneralDirectPosition(bBox.getMaxX(), bBox.getMaxY()));
                    this.env.expandToInclude(new Envelope(coordMin, coordMax));
                }
            }
            catch (Exception e) {
                this.env = new Envelope();
            }
        }
        return this.env;
    }

    @Override
    public void setStyleCollections(Collection<StyleCollection> styleCollections) {
        this.env = null;
        super.setStyleCollections(styleCollections);
    }

    @Override
    public LayerContext getLayerContext() {
        return this.getWMSLayerContext();
    }

    public WMSLayerContext getWMSLayerContext() {
        if (this.wmsLayerContext == null) {
            this.wmsLayerContext = new WMSLayerContextImpl(this);
        }
        return this.wmsLayerContext;
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    @Override
    public int getLayerType() {
        return 6;
    }

    public static BufferedImage makeBufferedImage(Image im) {
        BufferedImage copy = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics2D g2d = copy.createGraphics();
        g2d.drawImage(im, 0, 0, null);
        g2d.dispose();
        return copy;
    }

    @Override
    public boolean displayedTreeNodeContains(String searchValue) {
        if (super.displayedTreeNodeContains(searchValue)) {
            return true;
        }
        List wmsLayerStyles = this.getStyleCollections().stream().filter(styleCollection -> !styleCollection.getLayerable().isScaleDependentRenderingEnabled() || styleCollection.getLayerable().isScaleDependentRenderingEnabled() && !styleCollection.getDefault()).flatMap(sCol -> sCol.getStyles().stream()).filter(WMSStyleModel.class::isInstance).map(WMSStyleModel.class::cast).flatMap(style -> style.getLstLayerNames().stream().map(layerName -> this.getLayerTitle((WMSStyleModel)style, (String)layerName))).collect(Collectors.toList());
        return wmsLayerStyles.stream().anyMatch(layerName -> layerName != null && !layerName.isBlank() && layerName.toLowerCase().contains(searchValue.toLowerCase()));
    }

    private String getLayerTitle(WMSStyleModel wmsStyle, String strWmsLayer) {
        WMSStyleRenderer wmsRenderer = (WMSStyleRenderer)wmsStyle.getIntelligence();
        try {
            if (!wmsRenderer.doesWMServiceNeedInitialisation()) {
                return wmsRenderer.getWMService().getLayerTitle(strWmsLayer);
            }
            return strWmsLayer;
        }
        catch (Exception e) {
            return strWmsLayer;
        }
    }

    @Override
    public void executeForInitialization() throws Exception {
        super.executeForInitialization();
        WMSStyleModel styleModel = this.getValidWMSStyle();
        if (styleModel != null) {
            Task task = this.getLayerManager().getTask();
            ((WMSStyleRenderer)styleModel.getIntelligence()).getWMServiceFasterAndCache(task);
        }
    }
}

