/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import java.util.ArrayList;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.locationtech.jts.util.Assert;

public class UndoableEditReceiver {
    private final UndoManager undoManager = new UndoManager();
    private final ArrayList newUndoableEdits = new ArrayList();
    private int transactions = 0;
    private final boolean nothingToUndoReported = false;
    private boolean irreversibleChangeReported = false;
    private boolean undoManagerCouldUndoAtStart = false;
    private final ArrayList listeners = new ArrayList();

    public UndoableEditReceiver() {
        this.undoManager.setLimit(15);
    }

    public void startReceiving() {
        ++this.transactions;
        this.irreversibleChangeReported = false;
        this.undoManagerCouldUndoAtStart = this.undoManager.canUndo();
    }

    public void reportIrreversibleChange() {
        Assert.isTrue((boolean)this.isReceiving());
        this.irreversibleChangeReported = true;
    }

    public void stopReceiving() {
        --this.transactions;
        try {
            if (this.irreversibleChangeReported) {
                this.undoManager.discardAllEdits();
                return;
            }
            if (this.newUndoableEdits.isEmpty()) {
                return;
            }
            for (UndoableEdit undoableEdit : this.newUndoableEdits) {
                this.undoManager.addEdit(undoableEdit);
            }
            this.newUndoableEdits.clear();
        }
        finally {
            this.fireUndoHistoryChanged();
            if (this.undoManagerCouldUndoAtStart && !this.undoManager.canUndo()) {
                this.fireUndoHistoryTruncated();
            }
        }
    }

    private void fireUndoHistoryTruncated() {
        for (Listener listener : this.listeners) {
            listener.undoHistoryTruncated();
        }
    }

    private void fireUndoHistoryChanged() {
        for (Listener listener : this.listeners) {
            listener.undoHistoryChanged();
        }
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void receive(UndoableEdit undoableEdit) {
        Assert.isTrue((boolean)this.isReceiving());
        this.newUndoableEdits.add(undoableEdit);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean isReceiving() {
        return this.transactions > 0;
    }

    public static interface Listener {
        public void undoHistoryChanged();

        public void undoHistoryTruncated();
    }
}

