/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public abstract class UndoableCommand {
    private final String name;
    public static final UndoableCommand DUMMY = UndoableCommand.empty("Dummy");

    public UndoableCommand(String name) {
        this.name = name;
    }

    protected void dispose() {
    }

    public abstract void execute();

    public abstract void unexecute();

    public UndoableEdit toUndoableEdit() {
        return new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return UndoableCommand.this.name;
            }

            @Override
            public void redo() {
                UndoableCommand.this.execute();
                super.redo();
            }

            @Override
            public void die() {
                UndoableCommand.this.dispose();
                super.die();
            }

            @Override
            public void undo() {
                super.undo();
                UndoableCommand.this.unexecute();
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public static UndoableCommand empty(String name) {
        return new EmptyUndoableCommand(name);
    }

    private static class EmptyUndoableCommand
    extends UndoableCommand {
        public EmptyUndoableCommand(String name) {
            super(name);
        }

        @Override
        public void execute() {
        }

        @Override
        public void unexecute() {
        }
    }
}

