/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.gis3d.Gis3DContextImpl;
import com.vividsolutions.jump.workbench.ui.plugin.spatial.SpatialOperation;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.unit.UnitFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="project")
public class Task
implements LayerManagerProxy,
WithScale {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    public static final int PROJECT_VERSION = 22;
    public static final String PROGRAMM_VERSION = JUMPWorkbench.getDisplayVersion();
    public static final String UNIT_KEY = "UNIT";
    public static final String CRS_KEY = "CRS";
    public static final String NAME_KEY = "NAME";
    public static final String DESC_KEY = "DESC";
    public static final String INITIAL_VIEW_KEY = "INITIAL_VIEW";
    public static final String MIN_ZOOM = "MIN_ZOOM";
    public static final String WRAP_AROUND = "WRAP_AROUND";
    public static final String LOCAL_DATASOURCES = "LOCAL_DATASOURCES";
    public static final String LOCAL_SYMBOLSOURCES = "LOCAL_SYMBOLSOURCES";
    public static final String LOCAL_SEARCHES = "LOCAL_SEARCHES";
    public static final String SPATIAL_OPERATIONS = "SPATIAL_OPERATIONS";
    private static final String BUILDIN_DATASOURCES = "BUILDIN_DATASOURCES";
    private static final String BUILDIN_SYMBOLSOURCES = "BUILDIN_SYMBOLSOURCES";
    private static final String BUILDIN_SEARCHES = "BUILDIN_SEARCHES";
    private static final String BUILDIN_SPATIAL_OPERATIONS = "BUILDIN_SPATIAL_OPERATIONS";
    private static final String ALL_DATASOURCES = "ALL_DATASOURCES";
    private static final String ALL_SYMBOLSOURCES = "ALL_SYMBOLSOURCES";
    private static final String ALL_SEARCHES = "ALL_SEARCHES";
    private static final String ALL_SPATIAL_OPERATIONS = "ALL_SPATIAL_OPERATIONS";
    public static final String OVERVIEW_KEY = "OVERVIEW";
    public static final String DEM_KEY = "DEM";
    public static final String UTM_PROJECTION_AND_HIGHT_REDUCTION_ACTIVE = "UTM_PROJECTION_AND_HIGHT_REDUCTION_ACTIVE";
    public static final String UTM_MID_GROUND_LEVEL = "UTM_MID_GROUND_LEVEL";
    private transient List<PropertiesChangedListener> propertyListeners = new ArrayList<PropertiesChangedListener>();
    private transient File projectFile = null;
    private transient double dblScale = -1.0;
    private transient boolean modified = false;
    private String version = PROGRAMM_VERSION;
    private String javaversion = System.getProperty("java.version");
    private int prjversion = 22;
    private final LayerManager layerManager;
    private Blackboard bb = new Blackboard();
    private transient Blackboard builtInBB = new Blackboard();
    private transient Map<String, List<LabelDefInfo>> mapLabelDefs = null;
    private transient Lock labelDefLock = new ReentrantLock();

    public Task() {
        this.layerManager = new LayerManager();
        this.layerManager.setTask(this);
        this.bb.put(UNIT_KEY, UnitFactory.getKey((DrawingUnit)UnitFactory.getDefaultUnit()));
        this.bb.put(CRS_KEY, CRSDefFactory.getKey((CRSDefinition)CRSDefFactory.getDefaultCRSDefinition()));
        this.bb.put(NAME_KEY, I18N.get("ui.WorkbenchFrame.task"));
        this.bb.put(DESC_KEY, "");
        LOG.debug("Programm-Version: {}, Java-Version: {}", (Object)this.version, (Object)this.javaversion);
    }

    public void reinitCachedObjects() {
        this.builtInBB.remove(ALL_DATASOURCES);
        this.builtInBB.remove(ALL_SYMBOLSOURCES);
        this.builtInBB.remove(ALL_SEARCHES);
        this.builtInBB.remove(ALL_SPATIAL_OPERATIONS);
        this.clearCachedLabelDefs();
    }

    public void resetSymbolStores() {
        this.getSymbolStores().forEach(ss -> ss.resetSymbolStore());
    }

    public boolean isModified() {
        return this.getLayerManager().isModified() || this.modified;
    }

    public void resetModifiedObjects() {
        for (Object obj : this.getLayerManager().getModfiedObjects()) {
            if (obj instanceof Layerable) {
                Layerable ly = (Layerable)obj;
                ly.setModified(false);
                continue;
            }
            Category cat = (Category)obj;
            cat.setModified(false);
        }
        this.modified = false;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetVersion() {
        this.version = PROGRAMM_VERSION;
        this.javaversion = System.getProperty("java.version");
        this.prjversion = 22;
    }

    public Object readResolve() {
        this.builtInBB = new Blackboard();
        this.propertyListeners = new ArrayList<PropertiesChangedListener>();
        this.labelDefLock = new ReentrantLock();
        this.dblScale = -1.0;
        this.getLocalDataStores().setTask(this);
        return this;
    }

    public void dispose() {
        Gis3DContextImpl.getInstance().dispose();
        this.propertyListeners.clear();
        this.getLayerManager().setFiringEvents(false);
        this.getLayerManager().dispose();
        ((DMDCollection)this.bb.get(LOCAL_DATASOURCES, new DMDCollection(this))).disposeDatastores();
        ((DMDCollection)this.bb.get(BUILDIN_DATASOURCES, new DMDCollection(this))).disposeDatastores();
        this.setBlackboard(null);
        this.clearCachedLabelDefs();
    }

    public void makeBuildIn() {
        this.builtInBB.put(BUILDIN_DATASOURCES, this.bb.get(LOCAL_DATASOURCES));
        this.getBuildInSymbolStores().addAll(this.getLocalSymbolStores());
        this.builtInBB.put(BUILDIN_SEARCHES, this.bb.get(LOCAL_SEARCHES));
        this.builtInBB.put(BUILDIN_SPATIAL_OPERATIONS, this.bb.get(SPATIAL_OPERATIONS));
        this.bb.put(LOCAL_DATASOURCES, null);
        this.bb.put(LOCAL_SYMBOLSOURCES, null);
        this.bb.put(LOCAL_SEARCHES, null);
        this.bb.put(SPATIAL_OPERATIONS, null);
        Iterator<Category> iSubCats = this.getLayerManager().getRootCatLocal().getSubcategories().iterator();
        try {
            this.getLayerManager().setFiringEvents(false);
            while (iSubCats.hasNext()) {
                this.getLayerManager().getRootCatBuildIn().addSubcategory(iSubCats.next());
            }
        }
        finally {
            this.getLayerManager().setFiringEvents(true);
        }
        this.setProjectFile(null);
        this.setModified(true);
    }

    public Blackboard getBlackboard() {
        return this.bb;
    }

    private void setBlackboard(Blackboard bb) {
        this.bb = bb;
        if (this.bb != null) {
            this.firePropertiesChanged();
            this.modified = true;
        }
    }

    public DrawingUnit getDrawingUnit() {
        return UnitFactory.getUnit((String)((String)this.bb.get(UNIT_KEY)));
    }

    public CRSDefinition getCRSDefinition() {
        return CRSDefFactory.getCRSDefinition((String)((String)this.bb.get(CRS_KEY)));
    }

    public boolean isProjectionReductionActive() {
        return this.bb.get(UTM_PROJECTION_AND_HIGHT_REDUCTION_ACTIVE, true);
    }

    public double getHeightReduction() {
        if (this.isProjectionReductionActive()) {
            return Double.parseDouble(this.bb.get(UTM_MID_GROUND_LEVEL, "0"));
        }
        return 0.0;
    }

    public Envelope getInitialView() {
        return (Envelope)this.bb.get(INITIAL_VIEW_KEY);
    }

    public double getWrapAround() {
        return (Double)this.bb.get(WRAP_AROUND, (Object)1.0);
    }

    public double getMinZoom() {
        return (Double)this.bb.get(MIN_ZOOM, (Object)0.01);
    }

    public DMDCollection getLocalDataStores() {
        return (DMDCollection)this.bb.get(LOCAL_DATASOURCES, new DMDCollection(this));
    }

    public DMDCollection getBuildInDataStores() {
        return (DMDCollection)this.builtInBB.get(BUILDIN_DATASOURCES, new DMDCollection(this));
    }

    public synchronized DMDCollection getDataStores() {
        if (!this.builtInBB.contains(ALL_DATASOURCES)) {
            DMDCollection dmdColLocal = (DMDCollection)this.bb.get(LOCAL_DATASOURCES, new DMDCollection(this));
            DMDCollection dmdColBuildIn = (DMDCollection)this.builtInBB.get(BUILDIN_DATASOURCES, new DMDCollection(this));
            ArrayList<DatastoreMetadata> lstDMD = new ArrayList<DatastoreMetadata>();
            lstDMD.addAll(dmdColLocal.getInternalList());
            lstDMD.addAll(dmdColBuildIn.getInternalList());
            this.builtInBB.put(ALL_DATASOURCES, new DMDCollection(this, lstDMD));
        }
        return (DMDCollection)this.builtInBB.get(ALL_DATASOURCES, new DMDCollection(this));
    }

    public SMDCollection getLocalSymbolStores() {
        return (SMDCollection)this.bb.get(LOCAL_SYMBOLSOURCES, new SMDCollection());
    }

    public SMDCollection getBuildInSymbolStores() {
        return (SMDCollection)this.builtInBB.get(BUILDIN_SYMBOLSOURCES, new SMDCollection());
    }

    public synchronized SMDCollection getSymbolStores() {
        if (!this.builtInBB.contains(ALL_SYMBOLSOURCES)) {
            SMDCollection smdColLocal = (SMDCollection)this.bb.get(LOCAL_SYMBOLSOURCES, new SMDCollection());
            SMDCollection smdColBuildIn = (SMDCollection)this.builtInBB.get(BUILDIN_SYMBOLSOURCES, new SMDCollection());
            ArrayList<SymbolstoreMetadata> lstSMD = new ArrayList<SymbolstoreMetadata>();
            lstSMD.addAll(smdColLocal.getInternalList());
            lstSMD.addAll(smdColBuildIn.getInternalList());
            this.builtInBB.put(ALL_SYMBOLSOURCES, new SMDCollection(lstSMD));
        }
        return (SMDCollection)this.builtInBB.get(ALL_SYMBOLSOURCES, new SMDCollection());
    }

    public SearchCollectionModel getLocalSearches() {
        return (SearchCollectionModel)this.bb.get(LOCAL_SEARCHES, new SearchCollectionModel());
    }

    public SearchCollectionModel getBuildInSearches() {
        return (SearchCollectionModel)this.builtInBB.get(BUILDIN_SEARCHES, new SearchCollectionModel());
    }

    public synchronized SearchCollectionModel getSearches() {
        if (!this.builtInBB.contains(ALL_SEARCHES)) {
            SearchCollectionModel searchColLocal = (SearchCollectionModel)this.bb.get(LOCAL_SEARCHES, new SearchCollectionModel());
            SearchCollectionModel searchColBuildIn = (SearchCollectionModel)this.builtInBB.get(BUILDIN_SEARCHES, new SearchCollectionModel());
            ArrayList lstSearch = new ArrayList();
            lstSearch.addAll(searchColLocal.getInternalList());
            lstSearch.addAll(searchColBuildIn.getInternalList());
            SearchCollectionModel scModel = new SearchCollectionModel();
            scModel.getInternalList().addAll(lstSearch);
            this.builtInBB.put(ALL_SEARCHES, scModel);
        }
        return (SearchCollectionModel)this.builtInBB.get(ALL_SEARCHES, new SearchCollectionModel());
    }

    public List<SpatialOperation> getLocalSpatialOps() {
        return (List)this.bb.get(SPATIAL_OPERATIONS, new ArrayList());
    }

    public List<SpatialOperation> getBuildInSpatialOps() {
        return (List)this.builtInBB.get(BUILDIN_SPATIAL_OPERATIONS, new ArrayList());
    }

    public synchronized List<SpatialOperation> getSpatialOps() {
        if (!this.builtInBB.contains(ALL_SPATIAL_OPERATIONS)) {
            List spOpColLocal = (List)this.bb.get(SPATIAL_OPERATIONS, new ArrayList());
            List spOpColBuildIn = (List)this.builtInBB.get(BUILDIN_SPATIAL_OPERATIONS, new ArrayList());
            ArrayList lstSpOp = new ArrayList();
            lstSpOp.addAll(spOpColLocal);
            lstSpOp.addAll(spOpColBuildIn);
            this.builtInBB.put(ALL_SPATIAL_OPERATIONS, lstSpOp);
        }
        return (List)this.builtInBB.get(ALL_SPATIAL_OPERATIONS, new ArrayList());
    }

    public String getName() {
        return this.bb.get(NAME_KEY, "");
    }

    public void setName(String name) {
        this.bb.put(NAME_KEY, name);
        this.modified = true;
        this.firePropertiesChanged();
    }

    public void setProjectFile(File projectFile) {
        this.modified = true;
        this.projectFile = projectFile;
        this.firePropertiesChanged();
    }

    public void addPropertiesChangedListener(PropertiesChangedListener listener) {
        if (this.propertyListeners.contains(listener)) {
            return;
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertiesChangedListener(PropertiesChangedListener listener) {
        this.propertyListeners.remove(listener);
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public int getProjectVersion() {
        return this.prjversion;
    }

    public String toString() {
        return this.getName();
    }

    public void setScale(double dblScale) {
        this.dblScale = dblScale;
    }

    @Override
    public double getScale() {
        return this.dblScale;
    }

    @Override
    public int getScaleType() {
        return 1;
    }

    public void firePropertiesChanged() {
        for (PropertiesChangedListener listener : this.propertyListeners) {
            listener.propertiesChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LabelDefInfo> cacheLabelDefs(String datastoreName, DataStore dataStore, boolean useUpperCase) throws IOException {
        try {
            this.labelDefLock.lock();
            if (this.mapLabelDefs == null) {
                this.mapLabelDefs = new HashMap<String, List<LabelDefInfo>>();
            } else if (this.mapLabelDefs.containsKey(datastoreName)) {
                List<LabelDefInfo> list = this.mapLabelDefs.get(datastoreName);
                return list;
            }
            SimpleFeatureSource fsLabelDef = dataStore.getFeatureSource(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)"riwa_label_def"));
            DefaultFeatureCollection fcLabelDef = DataUtilities.collection((FeatureCollection)fsLabelDef.getFeatures());
            SimpleFeatureIterator sfi = fcLabelDef.features();
            ArrayList<LabelDefInfo> labelInfos = new ArrayList<LabelDefInfo>(fcLabelDef.size());
            while (sfi.hasNext()) {
                labelInfos.add(new LabelDefInfo((SimpleFeature)sfi.next()));
            }
            this.mapLabelDefs.put(datastoreName, labelInfos);
            List<LabelDefInfo> list = Collections.unmodifiableList(labelInfos);
            return list;
        }
        finally {
            this.labelDefLock.unlock();
        }
    }

    public void clearCachedLabelDefs() {
        try {
            this.labelDefLock.lock();
            if (this.mapLabelDefs != null) {
                this.mapLabelDefs.clear();
            }
        }
        finally {
            this.labelDefLock.unlock();
        }
    }

    public void updateBasePath(File file) {
        this.getBlackboard().put("BASE_PATH", file.getParentFile().getAbsolutePath());
    }

    public Path getBasePath() {
        File lastPath;
        File projectFile = this.getProjectFile();
        Object basePathEntry = this.getBlackboard().get("BASE_PATH");
        File file = lastPath = basePathEntry != null ? new File(basePathEntry.toString()) : null;
        if (lastPath != null) {
            return lastPath.toPath();
        }
        if (projectFile != null) {
            return projectFile.toPath().getParent();
        }
        return null;
    }

    public static interface PropertiesChangedListener {
        public void propertiesChanged(Task var1);
    }
}

