/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.renderer.style.UserDefinedTransparencyRenderer;
import de.riwagis.riwajump.model.style.StyleModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

@XStreamAlias(value="simpleSCol")
public class SimpleStyleCollection
implements StyleCollection,
Comparable<SimpleStyleCollection> {
    private ArrayList<StyleModel> lstStyles = new ArrayList();
    private Double minScale = null;
    private Double maxScale = null;
    private boolean bolDefault = true;
    private transient AbstractLayerable layerable;

    public SimpleStyleCollection() {
    }

    public SimpleStyleCollection(Layerable layerObject, boolean _bolDefault) {
        this.layerable = (AbstractLayerable)layerObject;
        this.bolDefault = _bolDefault;
    }

    public String toString() {
        if (this.bolDefault) {
            return I18N.get("model.LayerStyleCollection.default");
        }
        DecimalFormat df = new DecimalFormat(",##0");
        return df.format(this.minScale) + " - " + df.format(this.maxScale);
    }

    @Override
    public int compareTo(SimpleStyleCollection sCol) throws ClassCastException {
        if (!(sCol instanceof StyleCollection)) {
            throw new ClassCastException("A Person object expected.");
        }
        int scaleToCompare = 0;
        if (sCol.getMaxScale() != null) {
            scaleToCompare = (int)sCol.getMaxScale().doubleValue();
        }
        int scale = 0;
        if (this.getMaxScale() != null) {
            scale = (int)this.maxScale.doubleValue();
        }
        return scale - scaleToCompare;
    }

    @Override
    public Layerable getLayerable() {
        return this.layerable;
    }

    @Override
    public void setLayerable(Layerable layerObject) {
        this.layerable = (AbstractLayerable)layerObject;
    }

    @Override
    public Collection<StyleModel> getStyles() {
        return new ArrayList<StyleModel>(this.lstStyles);
    }

    @Override
    public <T extends StyleModel> T getStyle(Class<T> c) {
        for (StyleModel p : this.lstStyles) {
            if (!c.isInstance(p)) continue;
            return (T)p;
        }
        return null;
    }

    @Override
    public StyleCollection clone() {
        SimpleStyleCollection cloneStyleCollection = new SimpleStyleCollection(this.layerable, this.bolDefault);
        ArrayList styleClones = (ArrayList)this.cloneStyles();
        cloneStyleCollection.setStyles(styleClones);
        if (this.maxScale != null) {
            cloneStyleCollection.setMaxScale(this.maxScale);
        }
        if (this.minScale != null) {
            cloneStyleCollection.setMinScale(this.minScale);
        }
        return cloneStyleCollection;
    }

    @Override
    public Collection<StyleModel> cloneStyles() {
        ArrayList<StyleModel> styleClones = new ArrayList<StyleModel>();
        for (StyleModel style : this.lstStyles) {
            try {
                styleClones.add((StyleModel)style.clone());
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return styleClones;
    }

    @Override
    public void setStyles(Collection<StyleModel> newStyles) {
        for (StyleModel style : new ArrayList<StyleModel>(this.getStyles())) {
            this.removeStyle(style);
        }
        for (StyleModel style : newStyles) {
            this.addStyle(style);
        }
    }

    public void clearStyles() {
        this.lstStyles.clear();
    }

    @Override
    public void addStyle(StyleModel styleObject) {
        this.lstStyles.add(styleObject);
    }

    @Override
    public void removeStyle(StyleModel styleObject) {
        this.lstStyles.remove(styleObject);
    }

    @Override
    public boolean getDefault() {
        return this.bolDefault;
    }

    @Override
    public void setDefault(boolean _bolDefault) {
        this.bolDefault = _bolDefault;
        if (_bolDefault) {
            if (this.layerable == null) {
                return;
            }
            Collection<StyleCollection> lstStyleCollections = this.layerable.getStyleCollections();
            if (lstStyleCollections == null) {
                return;
            }
            if (!lstStyleCollections.contains(this)) {
                return;
            }
            for (StyleCollection lstStyleCollection : lstStyleCollections) {
                lstStyleCollection.setDefault(false);
            }
        }
    }

    @Override
    public Double getMaxScale() {
        return this.maxScale;
    }

    @Override
    public void setMaxScale(Double maxScale) {
        if (Objects.equals(this.maxScale, maxScale)) {
            return;
        }
        this.maxScale = maxScale;
    }

    @Override
    public Double getMinScale() {
        return this.minScale;
    }

    @Override
    public void setMinScale(Double minScale) {
        if (Objects.equals(this.minScale, minScale)) {
            return;
        }
        this.minScale = minScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        boolean bolFireEvent = this.layerable.getLayerManager().isFiringEvents();
        this.layerable.getLayerManager().setFiringEvents(false);
        try {
            for (StyleModel sty : this.getStyles()) {
                if (sty.isEnabled()) {
                    sty.cleanUp();
                    continue;
                }
                this.removeStyle(sty);
            }
        }
        finally {
            this.layerable.getLayerManager().setFiringEvents(bolFireEvent);
        }
    }

    @Override
    public Task getTask() {
        if (this.getLayerable() == null) {
            return null;
        }
        if (this.getLayerable().getLayerManager() == null) {
            return null;
        }
        return this.getLayerable().getLayerManager().getTask();
    }

    @Override
    public void setAlpha(int alpha) {
        this.transparencyRenderers().forEach(r -> r.setUserDefinedAlpha(alpha));
    }

    @Override
    public int getAlpha() {
        return this.transparencyRenderers().map(UserDefinedTransparencyRenderer::getUserDefinedAlpha).findAny().orElse(255);
    }

    @Override
    public void resetAlpha() {
        this.transparencyRenderers().forEach(UserDefinedTransparencyRenderer::resetUserDefinedAlpha);
    }

    @Override
    public boolean canUserAdjustAlpha() {
        return this.transparencyRenderers().anyMatch(UserDefinedTransparencyRenderer::canUserAdjustAlpha);
    }

    private Stream<UserDefinedTransparencyRenderer> transparencyRenderers() {
        return this.lstStyles.stream().filter(s -> s.getIntelligence() instanceof UserDefinedTransparencyRenderer).map(s -> (UserDefinedTransparencyRenderer)s.getIntelligence());
    }
}

