/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStore;
import com.vividsolutions.jump.workbench.model.redline.RedlineDataStoreFactory;
import com.vividsolutions.jump.workbench.model.redline.RedlineGlobalStyles;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.RelativePaths;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.RedlineLayerUtils;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.SaveRedlineLayerPlugIn;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.AreaLinePointFeatureIterator;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.RedlineStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.ThrowingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="redlineLayer")
public class RedlineLayer
extends AbstractCadLayer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedlineLayer.class);
    private static final long serialVersionUID = 309546527820706629L;
    private int intDrawScale = 1000;
    private DMDCollection redlineDMDCol = null;
    private transient boolean metaDataModified;
    private transient Collection<StyleCollection> lstRedlineScol = null;
    private transient LayerStyleCollection redlineScol = null;
    private transient boolean firingEvents = false;
    protected transient RedlineLayerSymbolStore symbolStore;
    private transient SymbolstoreMetadata smd;
    private transient String smdName;
    private transient CRSDefinition crsDefinition = CRSDefFactory.getDefaultCRSDefinition();
    private transient LayerListener layerListener;
    private transient Map<String, SimpleFeature> drawingStyles = new TreeMap<String, SimpleFeature>();
    public static SimpleFeatureType REDLINE_FEATURE_TYPE = RedlineLayer.createFeatureType();
    private transient Map<String, SimpleFeature> mapFeatureModified = new HashMap<String, SimpleFeature>();
    private transient Map<String, SimpleFeature> mapFeatureAdded = new HashMap<String, SimpleFeature>();
    private transient Map<String, SimpleFeature> mapFeatureDeleted = new HashMap<String, SimpleFeature>();

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder ftFac = new SimpleFeatureTypeBuilder();
        for (CadFeatureAtts att : CadFeatureAtts.values()) {
            ftFac.add(att.getName(), att.getType());
        }
        ftFac.remove(CadFeatureAtts.SYMLINECOLOR.getName());
        ftFac.remove(CadFeatureAtts.USE_SYMLINECOLOR.getName());
        ftFac.remove(CadFeatureAtts.SYMFILLCOLOR.getName());
        ftFac.remove(CadFeatureAtts.USE_SYMFILLCOLOR.getName());
        ftFac.setName("redline");
        return ftFac.buildFeatureType();
    }

    @Override
    public RedlineLayer clone() throws CloneNotSupportedException {
        try {
            RedlineLayer clonedLayer = (RedlineLayer)super.clone();
            clonedLayer.initStyleCollections();
            DatastoreMetadata dmdOld = this.getDMD();
            RedlineDataStore dsOld = (RedlineDataStore)dmdOld.getDataStore();
            this.createNewDMD(clonedLayer);
            clonedLayer.setFile(dsOld.getFileInternal());
            DatastoreMetadata dmdNew = clonedLayer.getDMD();
            dmdNew.takeProperties(dmdOld);
            clonedLayer.symbolStore = RedlineLayerSymbolStore.createWithoutGlobals();
            clonedLayer.createNewSMD();
            return clonedLayer;
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public void setName(String name) {
        if (StringUtils.equals((CharSequence)super.getName(), (CharSequence)name)) {
            return;
        }
        if (this.getLayerManager() != null && this.getLayerManager().hasLayerable(name)) {
            name = this.getLayerManager().uniqueLayerName(name);
        }
        super.setName(name);
        super.setKey(name);
        this.setMetaDataModified(true);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        super.setEditable(editable);
        this.setMetaDataModified(true);
    }

    @Override
    public void setSelectable(boolean selectable) {
        if (this.selectable == selectable) {
            return;
        }
        super.setSelectable(selectable);
        this.setMetaDataModified(true);
    }

    @Override
    public final void setRenderPrio(int renderPrio) {
        if (this.getRenderPrio() == renderPrio) {
            return;
        }
        super.setRenderPrio(renderPrio);
        this.setMetaDataModified(true);
    }

    @Override
    public void setDescription(String description) {
        if (StringUtils.equals((CharSequence)super.getDescription(), (CharSequence)description)) {
            return;
        }
        super.setDescription(description);
        this.setMetaDataModified(true);
    }

    private void createNewDMD(RedlineLayer layer) {
        try {
            RedlineDataStore colStore = (RedlineDataStore)new RedlineDataStoreFactory().createNewDataStore(new HashMap());
            colStore.setLayer(layer);
            DMDCollection dmdColl = new DMDCollection(layer.getLayerManager().getTask());
            dmdColl.addDatastore(new DatastoreMetadata("redline", (DataStore)colStore));
            layer.redlineDMDCol = dmdColl;
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)("could not create empty datastore for redlinelayer: " + layer.getName()));
        }
    }

    private static FeaturestoreMetadata createNewFMD() {
        FeaturestoreMetadata fmd = new FeaturestoreMetadata();
        fmd.setDatastoreName("redline");
        fmd.setDatatypeName("redline");
        AttributeDescriptor[] arrTypes = REDLINE_FEATURE_TYPE.getAttributeDescriptors().toArray(new AttributeDescriptor[0]);
        String[] arrStrTypes = new String[arrTypes.length];
        for (int i = 0; i < arrTypes.length; ++i) {
            arrStrTypes[i] = arrTypes[i].getLocalName();
        }
        fmd.setAttributes(arrStrTypes);
        fmd.setOriAtt("symori");
        fmd.setUseText(true);
        fmd.setTextAtt("text");
        fmd.setTextOriAtt("textori");
        fmd.setRestrictGeomType(true);
        fmd.setGeomTypes(new Class[]{Point.class, MultiPoint.class, LineString.class, MultiLineString.class, Polygon.class, MultiPolygon.class});
        return fmd;
    }

    public RedlineLayer(String name, LayerManager layerManager) {
        super(name, RedlineLayer.createNewFMD(), layerManager);
        this.editable = true;
        this.createNewDMD(this);
        this.initStyleCollections();
        this.setRenderPrio(2000000000);
        this.metaDataModified = false;
        this.firingEvents = true;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.firingEvents = false;
        this.mapFeatureModified = new HashMap<String, SimpleFeature>();
        this.mapFeatureAdded = new HashMap<String, SimpleFeature>();
        this.mapFeatureDeleted = new HashMap<String, SimpleFeature>();
        this.drawingStyles = new TreeMap<String, SimpleFeature>();
        try {
            DatastoreMetadata dmd = this.getDMD();
            RedlineDataStore ds = (RedlineDataStore)dmd.getDataStore();
            ds.setLayer(this);
            dmd.setKeepDataStore(true);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere((String)("cant find datastore for redline layer: " + this.getName()));
        }
        this.setFMD(RedlineLayer.createNewFMD());
        if (this.intDrawScale == 0) {
            this.intDrawScale = 1000;
        }
        this.initStyleCollections();
        this.metaDataModified = false;
        this.firingEvents = true;
        return this;
    }

    private void initStyleCollections() {
        this.redlineScol = new LayerStyleCollection(this, true);
        RedlineStyleModel rStyle = new RedlineStyleModel(this.getSMDName());
        this.redlineScol.addStyle((StyleModel)rStyle);
        this.lstRedlineScol = new ArrayList<StyleCollection>();
        this.lstRedlineScol.add(this.redlineScol);
    }

    @Override
    protected SimpleFeature initDefaultFeature() {
        return RedlineGlobalStyles.getInstance().getDefaultStyle();
    }

    protected SimpleFeature createDefaultWorkbenchFeature() {
        try {
            SimpleFeature feature = super.initDefaultFeature();
            feature.setAttribute(CadFeatureAtts.SYMBOL.getName(), (Object)"cross.svg");
            return feature;
        }
        catch (Exception e) {
            log.error(String.format("Error initializing defaultFeature in AbstractCadLayer: %s", this.getName()), (Throwable)e);
            return null;
        }
    }

    public int getDrawScale() {
        return this.intDrawScale;
    }

    public void setDrawScale(int intDrawScale) {
        if (this.intDrawScale == intDrawScale) {
            return;
        }
        this.intDrawScale = intDrawScale;
        this.setMetaDataModified(true);
    }

    @Override
    public DMDCollection getDMDCol() {
        return this.redlineDMDCol;
    }

    @Override
    public int getLayerType() {
        return 2;
    }

    @Override
    public boolean isFMDEditable() {
        return true;
    }

    @Override
    public SimpleFeature getFeatureByKey(String strFID) throws Exception {
        return this.getFeatureByKey(strFID, true);
    }

    @Override
    public SimpleFeature getFeatureByKey(String strFID, boolean bolQueryStore) throws Exception {
        FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.getFMD().getFeatureReader(this.getDMDCol(), FilterUtil.getFidFilter((String)strFID));
        if (fread.hasNext()) {
            return (SimpleFeature)fread.next();
        }
        return null;
    }

    @Override
    protected String isFeatureValid(SimpleFeature feat, int action) {
        boolean isDim;
        String strError = super.isFeatureValid(feat, action);
        if (strError != null) {
            return strError;
        }
        Geometry geom = (Geometry)feat.getDefaultGeometry();
        if (geom == null || geom.isEmpty()) {
            return I18N.get("model.RedlineLayer.no-empty-geometries");
        }
        if ((action == 1 || action == 2) && (isDim = FeatureUtil.getBooleanAttribute((SimpleFeature)feat, (String)CadFeatureAtts.ISDIM.getName())) && !DimLayer.isDimensionValid(feat)) {
            return I18N.get("model.DimLayer.invalid-geometry-for-dimension");
        }
        return null;
    }

    public synchronized boolean saveHeaderToFile() {
        return this.commitChanges(false);
    }

    private synchronized boolean saveToFile(boolean withModifiedFeatures) throws IOException {
        if (!this.fileExistsAndIsNotNewer()) {
            return false;
        }
        return this.commitChanges(withModifiedFeatures);
    }

    private boolean commitChanges(boolean withModifiedFeatures) {
        boolean saved = this.getDataStore().storeFeatures(withModifiedFeatures);
        if (saved) {
            this.metaDataModified = false;
        }
        return saved;
    }

    private boolean fileExistsAndIsNotNewer() throws IOException {
        RedlineDataStore ds = this.getDataStore();
        File file = this.getRedlineFile();
        if (file != null) {
            File tmpFile = new File(file.getAbsolutePath());
            long lastModified = tmpFile.lastModified();
            if (ds.getFileLastModified() != Long.MIN_VALUE && lastModified > ds.getFileLastModified()) {
                int ret = JOptionPane.showConfirmDialog(WorkbenchContext.getFrame(), I18N.get("ui.plugin.io.layer.SaveRedlineLayerPlugIn.file-lastmodified-warning"), I18N.get("common.message"), 0);
                return ret != 1;
            }
        } else {
            String strFile = SaveRedlineLayerPlugIn.chooseFile(this);
            if (StringUtils.isEmpty((CharSequence)strFile)) {
                return false;
            }
            File newFileName = new File(strFile);
            this.setFile(newFileName);
            if (this.getName().equals(I18N.get("ui.plugin.layer.redline.AddRedlineLayerPlugIn.default-layername"))) {
                this.setName(StringUtils.substringBefore((String)newFileName.getName(), (String)".rly"));
            }
        }
        return true;
    }

    private File getRedlineFile() {
        RedlineDataStore dataStore = this.getDataStore();
        File fileInternal = dataStore.getFileInternal();
        if (fileInternal == null) {
            return null;
        }
        File file = this.getMagicFileIfPossible(fileInternal);
        dataStore.setFileInternal(file);
        return file;
    }

    @Override
    public int commitEditedFeatures(boolean bolAdded, boolean bolModified, boolean bolDeleted) throws Exception {
        this.mapFeatureAdded.clear();
        this.mapFeatureDeleted.clear();
        this.mapFeatureModified.clear();
        if (bolAdded && bolModified && bolDeleted) {
            boolean saved = this.saveToFile(true);
            return saved ? 1 : 0;
        }
        return 0;
    }

    @Override
    public void rollbackEditedFeatures() {
        RedlineDataStore ds = this.getDataStore();
        try {
            this.resetStylesAndSymbols();
            RedlineLayerUtils.readHeader(this, this.getRedlineFile());
            this.mapFeatureAdded.clear();
            this.mapFeatureDeleted.clear();
            this.mapFeatureModified.clear();
        }
        catch (IOException ex) {
            log.error("Could not rollback changes on redline layer!", (Throwable)ex);
        }
        ds.resetFeatureCollection();
        this.metaDataModified = false;
    }

    private void resetStylesAndSymbols() {
        this.drawingStyles.clear();
        this.getRedlineSymbolStore().clear();
        this.getDrawingStyles().keySet().stream().findFirst().ifPresent(this::copyOverActiveFeatureFromStyle);
    }

    @Override
    public synchronized void editFeature(Collection<SimpleFeature> col, int action) {
        super.editFeature(col, action);
        this.clearFeatureCache();
    }

    @Override
    protected void editFeature(SimpleFeature feat, int action, Collection<SimpleFeature> oldFeatures) throws Exception {
        String strError = this.isFeatureValid(feat, action);
        if (strError != null) {
            throw new Exception(strError);
        }
        RedlineDataStore ds = this.getDataStore();
        SimpleFeatureStore featureSource = (SimpleFeatureStore)ds.getFeatureSource(this.getDefaultFeatureType().getTypeName());
        if (action == 1) {
            if (this.getUseDefaultFeature() && !this.featureWantsToKeepAttributes(feat)) {
                this.copyDefaultStyleToFeature(feat);
            }
            if (this.getDrawDimension()) {
                FeatureUtil.setAttribute((SimpleFeature)feat, (String)CadFeatureAtts.ISDIM.getName(), (Object)1);
            }
            RedlineGlobalStyles.getInstance().copyOverGlobalSymbolsIfRequired(this, feat);
            feat.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
            featureSource.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feat));
            this.mapFeatureAdded.put(feat.getID(), feat);
        } else if (action == 2) {
            oldFeatures.add(this.getFeatureByKey(feat.getID()));
            featureSource.modifyFeatures(DataUtilities.attributeNames((SimpleFeatureType)this.getDefaultFeatureType()), feat.getAttributes().toArray(), FilterUtil.getFidFilter((String)feat.getID()));
            if (this.mapFeatureAdded.containsKey(feat.getID())) {
                oldFeatures.add(this.mapFeatureAdded.get(feat.getID()));
                this.mapFeatureAdded.put(feat.getID(), feat);
            } else {
                this.mapFeatureModified.put(feat.getID(), feat);
            }
        } else if (action == 3) {
            oldFeatures.add(feat);
            featureSource.removeFeatures(FilterUtil.getFidFilter((String)feat.getID()));
            if (this.mapFeatureAdded.containsKey(feat.getID())) {
                this.mapFeatureAdded.remove(feat.getID());
            } else {
                if (this.mapFeatureModified.containsKey(feat.getID())) {
                    this.mapFeatureModified.remove(feat.getID());
                }
                this.mapFeatureDeleted.put(feat.getID(), feat);
            }
        } else {
            throw new UnsupportedOperationException("Invalid edit feature action: " + action);
        }
    }

    private boolean featureWantsToKeepAttributes(SimpleFeature feat) {
        return Boolean.TRUE.equals(feat.getUserData().get("RL_KEEP_ATTRIBUTES"));
    }

    @Override
    public boolean hasEditedFeatures() {
        if (this.isEditable()) {
            RedlineDataStore ds = this.getDataStore();
            return ds.isFeatureCollectionModified();
        }
        return false;
    }

    public void setMetaDataModified(boolean dataModified) {
        boolean oldValue = this.metaDataModified;
        this.metaDataModified = dataModified;
        if (this.firingEvents && oldValue != dataModified) {
            this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        }
    }

    public boolean isMetaDataModified() {
        return this.metaDataModified;
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    public boolean isFiringEvents() {
        return this.firingEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void updateSilently(ThrowingRunnable<E> action) throws E {
        boolean isFiringEvents = this.isFiringEvents();
        boolean isMetaDataModified = this.isMetaDataModified();
        try {
            this.setFiringEvents(false);
            action.run();
        }
        finally {
            this.setMetaDataModified(isMetaDataModified);
            this.setFiringEvents(isFiringEvents);
        }
    }

    @Override
    public int getNumEditedFeatures() {
        return this.hasEditedFeatures() ? 1 : 0;
    }

    @Override
    public FeatureIterator<SimpleFeature> getRenderIterator(Envelope env) throws Exception {
        env = this.getRenderEnvelope(env);
        FeatureIterator<SimpleFeature> i = super.getRenderIterator(env);
        return new AreaLinePointFeatureIterator(i);
    }

    @Override
    public LayerStyleCollection getDefaultLayerStyleCollection() {
        return this.redlineScol;
    }

    @Override
    public LayerStyleCollection getValidLayerStyleCollection() {
        return this.redlineScol;
    }

    @Override
    public Collection<StyleCollection> cloneStyleCollections() {
        ArrayList<StyleCollection> lstSCol = new ArrayList<StyleCollection>();
        lstSCol.add(this.redlineScol.clone());
        return lstSCol;
    }

    @Override
    public StyleCollection getDefaultStyleCollection() {
        return this.redlineScol;
    }

    @Override
    public StyleCollection getStyleCollectionByScale(double dblScale) {
        return this.redlineScol;
    }

    @Override
    public Collection<StyleCollection> getStyleCollections() {
        return new ArrayList<StyleCollection>(this.lstRedlineScol);
    }

    @Override
    public StyleCollection getValidStyleCollection() {
        return this.redlineScol;
    }

    public void setFile(File file) {
        DatastoreMetadata dmd = this.redlineDMDCol.getByName("redline");
        try {
            RedlineDataStore ds = (RedlineDataStore)dmd.getDataStore();
            if (file == null) {
                ds.setFileInternal(null);
                dmd.getParameters().remove(RedlineDataStoreFactory.FILE.key);
            } else {
                File absoluteFile = this.getMagicFileIfPossible(file);
                ds.setFileInternal(absoluteFile);
                dmd.getParameters().put(RedlineDataStoreFactory.FILE.key, absoluteFile);
            }
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere((String)"cant find datastore for redline layer");
        }
    }

    private File getMagicFileIfPossible(File file) {
        if (this.getLayerManager() != null) {
            return RelativePaths.getFileRelativeToProject(file.toPath(), this.getLayerManager().getTask());
        }
        return file;
    }

    public RedlineDataStore getDataStore() {
        try {
            DatastoreMetadata dmd = this.redlineDMDCol.getByName("redline");
            return (RedlineDataStore)dmd.getDataStore();
        }
        catch (IOException ex) {
            log.error("cant find datastore for redline layer: {}", (Object)this.getName());
            throw new IllegalStateException("Redline DMD should always contain a RedlineDataStore");
        }
    }

    public CRSDefinition getCRSDefinition() {
        return this.crsDefinition;
    }

    public void setCRSDefinition(CRSDefinition crsDefinition) {
        this.crsDefinition = crsDefinition;
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        super.setLayerManager(layerManager);
        if (layerManager != null && layerManager.getTask() != null) {
            this.setCRSDefinition(layerManager.getTask().getCRSDefinition());
            if (this.smd == null) {
                this.createNewSMD();
            }
            try {
                if (this.getDMDCol() != null && this.getDataStore() != null) {
                    RedlineLayerUtils.readHeader(this, this.getRedlineFile());
                }
            }
            catch (IOException ex) {
                log.error("Could not read symbols and styles from redline file", (Throwable)ex);
            }
        }
    }

    private void createNewSMD() {
        LayerManager layerManager = this.getLayerManager();
        Objects.requireNonNull(layerManager);
        final Task task = layerManager.getTask();
        if (task == null) {
            return;
        }
        if (this.smd != null) {
            Assert.shouldNeverReachHere((String)"Redline SMD was already initialized!");
        }
        this.smd = new SymbolstoreMetadata(){
            private static final long serialVersionUID = -3888960117259736081L;

            @Override
            public SymbolStore getSymbolStore() {
                return RedlineLayer.this.getSymbolStore();
            }
        };
        this.smd.setName(this.getSMDName());
        this.smd.setURL("redline-symbols://fake");
        task.getBuildInSymbolStores().addSymbolstore(this.smd);
        task.reinitCachedObjects();
        this.layerListener = new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getLayerable() == RedlineLayer.this) {
                    SMDCollection symbolStores = task.getBuildInSymbolStores();
                    if (e.getType() == LayerEventType.REMOVED) {
                        symbolStores.removeSymbolstore(RedlineLayer.this.smd);
                        task.reinitCachedObjects();
                    } else if (e.getType() == LayerEventType.ADDED && !symbolStores.getInternalList().contains(RedlineLayer.this.smd)) {
                        symbolStores.addSymbolstore(RedlineLayer.this.smd);
                        task.reinitCachedObjects();
                    }
                }
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        };
        layerManager.addLayerListener(this.layerListener);
    }

    @Override
    public SymbolStore getSymbolStore() {
        return this.getRedlineSymbolStore();
    }

    public RedlineLayerSymbolStore getRedlineSymbolStore() {
        if (this.symbolStore == null) {
            this.symbolStore = RedlineLayerSymbolStore.createWithoutGlobals();
        }
        return this.symbolStore;
    }

    private String getSMDName() {
        if (this.smdName == null) {
            this.smdName = "redline_" + UUID.randomUUID().toString();
        }
        return this.smdName;
    }

    @Override
    public void dispose() {
        this.getLayerManager().removeLayerListener(this.layerListener);
        super.dispose();
    }

    public boolean createDrawingStyle(String name) {
        Assert.isTrue((!this.drawingStyles.containsKey(name) ? 1 : 0) != 0);
        SimpleFeature clonedFeature = FeatureUtil.cloneFeature((SimpleFeature)this.getDefaultFeature());
        boolean wasChanged = this.drawingStyles.putIfAbsent(name, clonedFeature) == null;
        RedlineGlobalStyles.getInstance().copyOverGlobalSymbolsIfRequired(this, clonedFeature);
        if (wasChanged) {
            this.setMetaDataModified(true);
        }
        return wasChanged;
    }

    public boolean addDrawingStyle(String name, SimpleFeature style) {
        boolean wasChanged;
        Assert.isTrue((!this.drawingStyles.containsKey(name) ? 1 : 0) != 0);
        boolean bl = wasChanged = this.drawingStyles.putIfAbsent(name, style) == null;
        if (wasChanged) {
            this.setMetaDataModified(true);
        }
        return wasChanged;
    }

    public boolean addOrReplaceDrawingStyle(String name, SimpleFeature style) {
        boolean wasChanged;
        boolean bl = wasChanged = this.drawingStyles.put(name, style) != style;
        if (wasChanged) {
            this.setMetaDataModified(true);
        }
        return wasChanged;
    }

    public boolean removeDrawingStyle(String name) {
        boolean wasChanged;
        Assert.isTrue((boolean)this.drawingStyles.containsKey(name));
        boolean bl = wasChanged = this.drawingStyles.remove(name) != null;
        if (wasChanged) {
            this.setMetaDataModified(true);
        }
        return wasChanged;
    }

    public void updateStyle(String styleToUpdate) {
        this.addOrReplaceDrawingStyle(styleToUpdate, this.getDefaultFeature());
        RedlineGlobalStyles.getInstance().copyOverGlobalSymbolsIfRequired(this, this.getDefaultFeature());
    }

    public void clearDrawingStyles() {
        if (!this.drawingStyles.isEmpty()) {
            this.drawingStyles.clear();
            this.setMetaDataModified(true);
        }
    }

    public void copyOverActiveFeatureFromStyle(String drawingStyleName) {
        this.defaultFeature = FeatureUtil.cloneFeature((SimpleFeature)RedlineGlobalStyles.getInstance().getStyle(this, drawingStyleName));
    }

    public Map<String, SimpleFeature> getDrawingStyles() {
        return Collections.unmodifiableMap(this.drawingStyles);
    }

    public boolean containsDrawingStyle(String name) {
        return this.drawingStyles.containsKey(name);
    }

    public SimpleFeature getDrawingStyle(String name) {
        return this.drawingStyles.get(name);
    }

    public boolean isSymbolRequiredByStyle(String symbolName) {
        return this.drawingStyles.values().stream().anyMatch(f -> {
            String symbol = (String)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.SYMBOL.getName());
            String fill = (String)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.FILL.getName());
            return symbolName.equals(symbol) || symbolName.equals(fill);
        });
    }

    @Override
    public SimpleFeatureType getDefaultFeatureType() {
        return REDLINE_FEATURE_TYPE;
    }

    @Override
    public boolean hasNonPersistedChanges() {
        return super.hasNonPersistedChanges() || this.isMetaDataModified();
    }

    @Override
    public boolean isSelectionClearingNeeded(boolean added, boolean modified, boolean deleted) {
        return added && modified && deleted;
    }

    @Override
    public String getNameForExport() {
        return "redline_" + this.getName();
    }

    public DatastoreMetadata getDMD() {
        return this.redlineDMDCol.getByName("redline");
    }

    @Override
    public boolean isAddedFeature(String fid) {
        return this.mapFeatureAdded.containsKey(fid);
    }

    @Override
    public boolean isModifiedFeature(String fid) {
        return this.mapFeatureModified.containsKey(fid);
    }

    @Override
    public boolean isDeletedFeature(String fid) {
        return this.mapFeatureDeleted.containsKey(fid);
    }

    @Override
    public boolean hasAddedFeatures() {
        return !this.mapFeatureAdded.isEmpty();
    }

    @Override
    public boolean hasModifiedFeatures() {
        return !this.mapFeatureModified.isEmpty();
    }

    @Override
    public boolean hasDeletedFeatures() {
        return !this.mapFeatureDeleted.isEmpty();
    }
}

