/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.raster.GeoTiffDataLocation;
import de.riwagis.riwajump.model.style.RasterStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.io.File;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="rasterLayer")
public class RasterImageLayer
extends AbstractLayerable {
    private static final Logger LOG = LoggerFactory.getLogger(RasterImageLayer.class);
    private static Blackboard blackboard = null;
    private transient AbstractGridCoverage2DReader gcread = null;
    private DataLocation rDataLoc = new GeoTiffDataLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImageLayer(String name, LayerManager layerManager, DataLocation rDataLoc) {
        super(name, layerManager);
        this.rDataLoc = rDataLoc;
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            SimpleStyleCollection styleCollection = new SimpleStyleCollection(this, true);
            styleCollection.addStyle((StyleModel)new RasterStyleModel());
            this.addStyleCollection(styleCollection);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        SimpleStyleCollection styleCollection = new SimpleStyleCollection(this, true);
        styleCollection.addStyle((StyleModel)new RasterStyleModel());
        return styleCollection;
    }

    private Object readResolve() {
        return this;
    }

    @Override
    public Collection<Layerable> reload() {
        this.clearCaches();
        return super.reload();
    }

    @Override
    public boolean isVisibleOnScreen() {
        boolean visibleOnScreen = super.isVisibleOnScreen();
        if (!visibleOnScreen && this.isVisible()) {
            this.clearCaches();
        }
        return visibleOnScreen;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.clearCaches();
        }
        super.setVisible(visible);
    }

    public DataLocation getDataLocation() {
        this.setRootDir2DataLocation(this.rDataLoc);
        return this.rDataLoc;
    }

    public void setDataLocation(DataLocation rDataLoc) {
        this.clearCaches();
        this.rDataLoc = rDataLoc;
        this.setRootDir2DataLocation(rDataLoc);
    }

    public RasterStyleModel getValidRasterStyle() {
        SimpleStyleCollection sCol = (SimpleStyleCollection)this.getValidStyleCollection();
        if (sCol == null) {
            return null;
        }
        RasterStyleModel rStyle = sCol.getStyle(RasterStyleModel.class);
        return rStyle;
    }

    @Override
    public Blackboard getBlackboard() {
        if (blackboard == null) {
            blackboard = new Blackboard();
        }
        return blackboard;
    }

    public void clearCaches() {
        if (this.gcread != null) {
            this.gcread.dispose();
        }
        this.gcread = null;
    }

    public void setRootDir2DataLocation(DataLocation dLoc) {
        File prjFile;
        if (this.getLayerManager() != null && this.getLayerManager().getTask() != null && (prjFile = this.getLayerManager().getTask().getProjectFile()) != null && dLoc != null) {
            dLoc.setRootDir(prjFile.getParentFile());
        }
    }

    public AbstractGridCoverage2DReader getGridCoverageReader() throws Exception {
        if (this.gcread == null) {
            this.gcread = (AbstractGridCoverage2DReader)this.getDataLocation().getDataLocationObject();
        }
        return this.gcread;
    }

    @Override
    public Envelope getEnvelope() {
        try {
            CoordinateReferenceSystem crsSource;
            GeneralEnvelope env = this.getGridCoverageReader().getOriginalEnvelope();
            Envelope envCov = new Envelope(env.getLowerCorner().getCoordinate()[0], env.getUpperCorner().getCoordinate()[0], env.getLowerCorner().getCoordinate()[1], env.getUpperCorner().getCoordinate()[1]);
            CRSDefinition crsTargetDef = this.getLayerManager().getTask().getCRSDefinition();
            CoordinateReferenceSystem crsTarget = null;
            if (crsTargetDef != null) {
                crsTarget = crsTargetDef.getCRS();
            }
            if (!((crsSource = this.getGridCoverageReader().getCoordinateReferenceSystem()) == null || crsSource.getName().getCode().equalsIgnoreCase("Wildcard 2D cartesian plane in metric unit") || crsTarget == null || crsTarget.getName().getCode().equalsIgnoreCase("Wildcard 2D cartesian plane in metric unit") || StringUtils.equals((CharSequence)crsSource.getName().getCode(), (CharSequence)crsTarget.getName().getCode()) && StringUtils.equalsIgnoreCase((CharSequence)crsSource.getName().getCodeSpace(), (CharSequence)crsTarget.getName().getCodeSpace()))) {
                Transformer trans = new Transformer(crsSource, crsTarget);
                trans.transform2d(envCov);
            }
            return envCov;
        }
        catch (Exception e) {
            LOG.error("Error retrieving Envelope from GridCoverage.", (Throwable)e);
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCaches();
    }

    @Override
    public int getLayerType() {
        return 5;
    }
}

