/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import de.riwagis.util.Config;
import java.text.Collator;
import java.util.Comparator;

public class LayerableComparator
implements Comparator<Layerable> {
    private final boolean compareWithCategory;
    private static final Collator COLLATOR = Collator.getInstance(Config.LOCALE);

    public LayerableComparator() {
        this(false);
    }

    public LayerableComparator(boolean compareWithCategory) {
        this.compareWithCategory = compareWithCategory;
    }

    @Override
    public final int compare(Layerable _a, Layerable _b) {
        if (this.compareWithCategory) {
            String strB;
            String strA = this.getLayerCategoryName(_a);
            int categoryCompare = COLLATOR.compare(strA, strB = this.getLayerCategoryName(_b));
            if (categoryCompare == 0) {
                return COLLATOR.compare(LayerableComparator.getName(_a), LayerableComparator.getName(_b));
            }
            return categoryCompare;
        }
        return COLLATOR.compare(LayerableComparator.getName(_a), LayerableComparator.getName(_b));
    }

    private static String getName(Layerable _a) {
        return _a.getName().toLowerCase(Config.LOCALE);
    }

    private String getLayerCategoryName(Layerable ly) {
        StringBuilder sb = new StringBuilder();
        this.appendCategoryNames(sb, ly.getCategory());
        return sb.toString();
    }

    private void appendCategoryNames(StringBuilder sb, Category cat) {
        sb.insert(0, cat.getName().toLowerCase(Config.LOCALE) + "_");
        if (cat.getParentCategory() != null) {
            this.appendCategoryNames(sb, cat.getParentCategory());
        }
    }
}

