/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.HasName;
import com.vividsolutions.jump.workbench.model.HasVisibility;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.tree.TreePath;
import org.locationtech.jts.geom.Envelope;

public interface Layerable
extends Comparable<Layerable>,
HasVisibility,
HasName {
    public static final Comparator<Layerable> COMPARE_LAYERABLE_BYPRIORITY = Comparator.comparingInt(Layerable::getRenderPrio);

    public void setKey(String var1) throws Exception;

    public String getKey();

    public void setName(String var1);

    public void setDescription(String var1);

    public Collection<Layerable> reload();

    public boolean isBuildIn();

    public String getDescription();

    public boolean isVisibleOnScreen();

    public boolean isVisibleOnScreen(boolean var1);

    public void setVisibleOnScreen();

    public boolean isVisibleInViewerTree();

    public void setVisibleInViewerTree(boolean var1);

    public void setLayerManager(LayerManager var1);

    public LayerManager getLayerManager();

    public void setCategory(int var1, Category var2);

    public void setCategory(Category var1);

    public Category getCategory();

    public int getRenderPrio();

    public void setRenderPrio(int var1);

    public String getRenderError();

    public void setRenderError(String var1);

    public Blackboard getBlackboard();

    public boolean withinVisibleScaleRange();

    public boolean isScaleDependentRenderingEnabled();

    public Layerable setScaleDependentRenderingEnabled(boolean var1);

    public Collection<StyleCollection> getStyleCollections();

    public StyleCollection getStyleCollectionByScale(double var1);

    public Collection<StyleCollection> cloneStyleCollections();

    public StyleCollection createNewDefaultStyleCollection();

    public void setStyleCollections(Collection<StyleCollection> var1);

    public Envelope getEnvelope();

    public boolean isModified();

    public void setModified(boolean var1);

    public TreePath getTreePath();

    public void cleanUp();

    public void dispose();

    public boolean isDisposed();

    public boolean isExportable();

    public void setExportable(boolean var1);

    public int getLayerType();

    public boolean displayedTreeNodeContains(String var1);

    public void executeForInitialization() throws Exception;

    public boolean isLayerInitialized();

    default public int getDepthInTree() {
        Category category = this.getCategory();
        int depth = 1;
        while (category != null) {
            category = category.getParentCategory();
            ++depth;
        }
        return depth;
    }
}

