/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Color;
import java.util.Collection;

@XStreamAlias(value="layerSCol")
public class LayerStyleCollection
extends SimpleStyleCollection
implements StyleCollection {
    public LayerStyleCollection() {
    }

    public LayerStyleCollection(Layer layerObject, boolean _bolDefault) {
        super(layerObject, _bolDefault);
    }

    public void initializeDefault(Color fillColor) {
        this.clearStyles();
        BasicStyleModel basStyle = new BasicStyleModel();
        basStyle.setFillColor(RiwaJumpModelUtilities.colorModelByColor(fillColor));
        basStyle.getLineBase().setLineColor(RiwaJumpModelUtilities.colorModelByColor(LayerStyleCollection.defaultLineColor(fillColor)));
        basStyle.setIntAlpha(150);
        this.addStyle((StyleModel)basStyle);
    }

    public static Color defaultLineColor(Color fillColor) {
        return fillColor.darker();
    }

    public Layer getLayer() {
        return (Layer)this.getLayerable();
    }

    public void setLayer(Layer layerObject) {
        this.setLayerable(layerObject);
    }

    @Override
    public StyleCollection clone() {
        LayerStyleCollection cloneStyleCollection = new LayerStyleCollection(this.getLayer(), this.getDefault());
        Collection<StyleModel> styleClones = this.cloneStyles();
        cloneStyleCollection.setStyles(styleClones);
        if (this.getMaxScale() != null) {
            cloneStyleCollection.setMaxScale(this.getMaxScale());
        }
        if (this.getMinScale() != null) {
            cloneStyleCollection.setMinScale(this.getMinScale());
        }
        return cloneStyleCollection;
    }

    public BasicStyleModel getBasicStyle() {
        return this.getStyle(BasicStyleModel.class);
    }

    @Override
    public void cleanUp() {
        for (StyleModel sty : this.getStyles()) {
            if (sty.isEnabled()) {
                sty.cleanUp();
                continue;
            }
            if (sty instanceof BasicStyleModel) {
                sty.cleanUp();
                continue;
            }
            this.removeStyle(sty);
        }
    }
}

