/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import de.riwagis.gis.context.jump.MapContextImpl;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.util.ThrowingRunnable;
import de.riwagis.util.ThrowingSupplier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="layerManager")
public class LayerManager
implements Iterable<Layer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayerManager.class);
    private static int layerManagerCount = 0;
    private Blackboard blackboard = new Blackboard();
    private Category rootcat = null;
    private transient Category rootcat_buildin = null;
    private transient Task task = null;
    private transient UndoableEditReceiver undoableEditReceiver = new UndoableEditReceiver();
    private transient boolean firingEvents = true;
    private transient Collection<LayerListener> layerListeners = new HashSet<LayerListener>();
    private transient Iterator<Color> firstColors = this.firstColors().iterator();
    private transient MapContext mapContext = null;
    public static final LayerManager dummyLayerManager = new LayerManager();
    private static final Comparator<Layerable> DEFAULT_LAYER_COMPARATOR;

    public LayerManager() {
        ++layerManagerCount;
        this.rootcat = new Category();
        this.rootcat.setFiringEvents(false);
        this.rootcat.setName("_ROOTCAT");
        this.rootcat.setLayerManager(this);
        this.rootcat_buildin = new Category();
        this.rootcat_buildin.setFiringEvents(false);
        this.rootcat_buildin.setName("_ROOTCAT_BUILDIN");
        this.rootcat_buildin.setLayerManager(this);
    }

    private Object readResolve() {
        this.firingEvents = true;
        this.undoableEditReceiver = new UndoableEditReceiver();
        this.layerListeners = new ArrayList<LayerListener>();
        this.firstColors = this.firstColors().iterator();
        ++layerManagerCount;
        this.firingEvents = false;
        this.rootcat_buildin = new Category();
        this.rootcat_buildin.setFiringEvents(false);
        this.rootcat_buildin.setName("_ROOTCAT_BUILDIN");
        this.rootcat_buildin.setLayerManager(this);
        return this;
    }

    public MapContext getMapContext() {
        if (this.mapContext == null) {
            this.mapContext = new MapContextImpl(this);
        }
        return this.mapContext;
    }

    public boolean isRootCat(Category cat) {
        return cat == this.rootcat || cat == this.rootcat_buildin;
    }

    public Category getRootCatLocal() {
        return this.rootcat;
    }

    public Category getRootCatBuildIn() {
        return this.rootcat_buildin;
    }

    public void setTask(Task _task) {
        this.task = _task;
    }

    public Task getTask() {
        return this.task;
    }

    public double getScreenScale() {
        if (this.task == null) {
            return -1.0;
        }
        return this.task.getScale();
    }

    public UndoableEditReceiver getUndoableEditReceiver() {
        return this.undoableEditReceiver;
    }

    public void deferFiringEvents(Runnable r) {
        boolean lFiringEvents = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            r.run();
        }
        finally {
            this.setFiringEvents(lFiringEvents);
        }
    }

    private Collection<Color> firstColors() {
        ArrayList<Color> lFirstColors = new ArrayList<Color>();
        for (BasicStyleModel basicStyle : AbstractPalettePanel.basicStyles()) {
            if (!basicStyle.isRenderingFill()) continue;
            lFirstColors.add(RiwaJumpModelUtilities.colorByColorModel(basicStyle.getFillColor()));
        }
        return lFirstColors;
    }

    public Color generateLayerFillColor() {
        Color color = this.firstColors.hasNext() ? this.firstColors.next() : new Color((int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0));
        color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return color;
    }

    public Layer addLayer(String categoryName, Layer layer) {
        this.addLayerable(categoryName, (Layerable)layer);
        return layer;
    }

    public void addLayerable(Category category, Layerable layerable) {
        Objects.requireNonNull(category, "Category should not be null");
        if (this.hasLayerable(layerable.getKey())) {
            throw new IllegalArgumentException("A layer width key:" + layerable.getKey() + " already exists");
        }
        category.add(0, layerable);
        this.fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
        this.fireCategoryChanged(category, CategoryEventType.METADATA_CHANGED);
    }

    public void addLayerable(String categoryName, Layerable layerable) {
        Category cat = layerable instanceof RedlineLayer ? this.getCategory(categoryName) : this.getCategoryLocal(categoryName);
        if (cat == null) {
            cat = this.addCategory(this.uniqueCategoryName(categoryName));
        }
        this.addLayerable(cat, layerable);
    }

    public boolean isBuildIn(Object obj) {
        if (obj instanceof Category) {
            Category cat = (Category)obj;
            while (cat.getParentCategory() != null) {
                cat = cat.getParentCategory();
            }
            return cat == this.rootcat_buildin;
        }
        if (obj instanceof Layerable) {
            Category cat = ((Layerable)obj).getCategory();
            if (cat == null) {
                return false;
            }
            while (cat.getParentCategory() != null) {
                cat = cat.getParentCategory();
            }
            return cat == this.rootcat_buildin;
        }
        Assert.shouldNeverReachHere();
        return false;
    }

    public Set<Category> getAllSubcategories() {
        HashSet<Category> lstCat = new HashSet<Category>();
        lstCat.addAll(this.rootcat.getAllSubcategories());
        lstCat.addAll(this.rootcat_buildin.getAllSubcategories());
        return lstCat;
    }

    public List<Category> getSubcategories() {
        List<Category> lstCat = this.rootcat.getSubcategories();
        lstCat.addAll(this.rootcat_buildin.getSubcategories());
        return lstCat;
    }

    public Set<Category> getAllSubcategoriesBuildIn() {
        return this.rootcat_buildin.getAllSubcategories();
    }

    public Set<Category> getAllSubcategoriesLocal() {
        return this.rootcat.getAllSubcategories();
    }

    public Category addCategory(String categoryName) {
        Category category = this.getCategoryLocal(categoryName);
        if (category != null) {
            return category;
        }
        category = new Category();
        category.setName(categoryName);
        return this.addCategory(category, this.rootcat.getNumSubcategories());
    }

    public Category addCategory(Category subcat) {
        if (this.getCategoryLocal(subcat.getName()) != null) {
            return subcat;
        }
        return this.addCategory(subcat, this.rootcat.getNumSubcategories());
    }

    public Category addCategory(Category category, int index) {
        category.setLayerManager(this);
        if (this.rootcat != null) {
            this.rootcat.add(index, category);
        }
        return category;
    }

    public Category addCategoryBuildIn(Category subcat) {
        if (this.getCategoryBuildIn(subcat.getName()) != null) {
            return subcat;
        }
        return this.addCategoryBuildIn(subcat, this.rootcat.getNumSubcategories());
    }

    public Category addCategoryBuildIn(Category category, int index) {
        category.setLayerManager(this);
        if (this.rootcat_buildin != null) {
            this.rootcat_buildin.add(index, category);
        }
        return category;
    }

    public Category getCategory(String name) {
        for (Category category : this.getAllSubcategories()) {
            if (!category.getName().equals(name)) continue;
            return category;
        }
        return null;
    }

    public Category getCategoryBuildIn(String name) {
        for (Category category : this.getAllSubcategoriesBuildIn()) {
            if (!category.getName().equals(name)) continue;
            return category;
        }
        return null;
    }

    public Category getCategoryLocal(String name) {
        for (Category category : this.getAllSubcategoriesLocal()) {
            if (!category.getName().equals(name)) continue;
            return category;
        }
        return null;
    }

    public String uniqueLayerKey(String key) {
        String newKey;
        if (!this.hasLayerable(key)) {
            return key;
        }
        int i = 2;
        do {
            newKey = key + " (" + i + ")";
            ++i;
        } while (this.hasLayerable(newKey));
        return newKey;
    }

    public String uniqueLayerName(String name) {
        String newName;
        if (!this.isExistingLayerableName(name)) {
            return name;
        }
        int i = 2;
        do {
            newName = name + " (" + i + ")";
            ++i;
        } while (this.isExistingLayerableName(newName));
        return newName;
    }

    private boolean isExistingLayerableName(String name) {
        for (Layerable layerable : this.getLayerables(Layerable.class)) {
            if (!layerable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String uniqueCategoryName(String name) {
        String newName;
        if (!this.isExistingCategoryName(name)) {
            return name;
        }
        int i = 2;
        do {
            newName = name + " (" + i + ")";
            ++i;
        } while (this.isExistingCategoryName(newName));
        return newName;
    }

    private boolean isExistingCategoryName(String name) {
        return this.getCategory(name) != null;
    }

    public void remove(Layerable layerable) {
        layerable.setCategory(null);
    }

    public void removeIfEmpty(Category category) {
        if (!category.isEmpty()) {
            return;
        }
        category.setParentCategory(null);
    }

    public void fireCategoryChanged(Category category, CategoryEventType type) {
        if (!this.firingEvents) {
            return;
        }
        CategoryEvent catEvent = new CategoryEvent(category, category.getParentCategory(), type);
        for (LayerListener layerListener : this.layerListeners) {
            this.fireLayerEvent(() -> layerListener.categoryChanged(catEvent));
        }
    }

    public void fireFeaturesChanged(Collection<SimpleFeature> features, FeatureEventType type, Layer layer) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, null);
    }

    public void fireGeometryModified(Collection<SimpleFeature> features, Layer layer, Collection<SimpleFeature> oldFeatureClones) {
        Assert.isTrue((oldFeatureClones != null ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, FeatureEventType.GEOMETRY_MODIFIED, layer, oldFeatureClones);
    }

    private void fireFeaturesChanged(Collection<SimpleFeature> features, FeatureEventType type, Layer layer, Collection<SimpleFeature> oldFeatureClones) {
        if (!this.firingEvents) {
            return;
        }
        for (LayerListener layerListener : new ArrayList<LayerListener>(this.layerListeners)) {
            this.fireLayerEvent(() -> layerListener.featuresChanged(new FeatureEvent(features, type, layer, oldFeatureClones)));
        }
    }

    private void fireLayerEvent(Runnable eventFirer) {
        GUIUtil.invokeOnEventThreadLater(eventFirer);
    }

    private void fireLayerChanged(Layerable layerable, LayerEventType layerChangeType, Category category, int layerIndex) {
        if (!this.firingEvents) {
            return;
        }
        for (LayerListener layerListener : new ArrayList<LayerListener>(this.layerListeners)) {
            this.fireLayerEvent(() -> layerListener.layerChanged(new LayerEvent(layerable, layerChangeType, category, layerIndex)));
        }
    }

    public void fireLayerChanged(Layerable layerable, LayerEventType type) {
        if (!this.firingEvents) {
            return;
        }
        Category cat = LayerManager.getCategory(layerable);
        if (cat == null) {
            Assert.isTrue((!this.isFiringEvents() ? 1 : 0) != 0, (String)("If this event is being fired because you are constructing a Layer, cat will be null because you haven't yet added the Layer to the LayerManager. While constructing a layer, you should set firingEvents to false. (Layerable = " + layerable.getName() + ")"));
            return;
        }
        this.fireLayerChanged(layerable, type, cat, cat.treeIndexOf(layerable));
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    public boolean isFiringEvents() {
        return this.firingEvents;
    }

    public <T extends Layerable> Iterator<T> reverseIterator(Class<T> layerableClass, boolean bolOnlyVisible) {
        return this.getFilteredLayerStream(layerableClass).filter(l -> !bolOnlyVisible || l.isVisibleOnScreen()).sorted(DEFAULT_LAYER_COMPARATOR).collect(Collectors.toUnmodifiableList()).iterator();
    }

    public static void moveLayersDrawnLastToEnd(Collection<Layerable> layerables) {
        ArrayList<Layer> layersDrawnLast = new ArrayList<Layer>();
        Iterator<Layerable> i = layerables.iterator();
        while (i.hasNext()) {
            Layer layer;
            Layerable layerable = i.next();
            if (!(layerable instanceof Layer) || !(layer = (Layer)layerable).isDrawingLast()) continue;
            layersDrawnLast.add(layer);
            i.remove();
        }
        layerables.addAll(layersDrawnLast);
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.getLayers().iterator();
    }

    public Layer getLayerByKey(String key) {
        for (Layer layer : this) {
            if (!layer.getKey().equals(key)) continue;
            return layer;
        }
        return null;
    }

    public Layerable getLayerableByKey(String key) {
        for (Layerable lyr : this.getLayerables()) {
            if (!lyr.getKey().equals(key)) continue;
            return lyr;
        }
        return null;
    }

    public boolean hasLayerable(String key) {
        return this.getLayerableByKey(key) != null;
    }

    public void addLayerListener(LayerListener layerListener) {
        Assert.isTrue((!this.layerListeners.contains(layerListener) ? 1 : 0) != 0);
        this.layerListeners.add(layerListener);
    }

    public void removeLayerListener(LayerListener layerListener) {
        this.layerListeners.remove(layerListener);
    }

    public Collection<LayerListener> getLayerListeners() {
        return Collections.unmodifiableCollection(this.layerListeners);
    }

    public int size() {
        return this.getLayers().size();
    }

    public Envelope getEnvelopeOfAllLayers() {
        return this.getEnvelopeOfAllLayers(false);
    }

    public Envelope getEnvelopeOfAllLayers(boolean visibleLayersOnly) {
        Envelope envelope = new Envelope();
        for (Layerable layerable : this.getLayerables(Layerable.class)) {
            if (visibleLayersOnly && !layerable.isVisible()) continue;
            Envelope env = layerable.getEnvelope();
            envelope.expandToInclude(env);
        }
        return envelope;
    }

    public boolean containsLayerable(Layerable lyr) {
        for (Category c : this.getAllSubcategories()) {
            for (Layerable l : new ArrayList<Layerable>(c.getLayerables())) {
                if (l != lyr) continue;
                return true;
            }
        }
        return false;
    }

    public static Category getCategory(Layerable layerable) {
        return layerable.getCategory();
    }

    public Collection<Layer> getLayers() {
        return this.getLayerables(Layer.class);
    }

    public Collection<Layerable> getLayerables() {
        return this.getLayerables(Layerable.class);
    }

    public <T extends Layerable> Collection<T> getLayerables(Class<T> layerableClass) {
        return this.getFilteredLayerStream(layerableClass).sorted(DEFAULT_LAYER_COMPARATOR.reversed()).collect(Collectors.toUnmodifiableList());
    }

    private <T extends Layerable> Stream<T> getFilteredLayerStream(Class<T> layerableClass) {
        if (!Layerable.class.isAssignableFrom(layerableClass)) {
            throw new ClassCastException("Requested layerable list of incompatible type");
        }
        return this.getAllSubcategories().stream().filter(sc -> sc != null).flatMap(sc -> sc.getLayerables().stream()).filter(l -> layerableClass.isInstance(l)).map(l -> l);
    }

    public <T extends Layerable> Set<T> getLayerablesUnordered(Class<T> layerableClass) {
        return this.getFilteredLayerStream(layerableClass).collect(Collectors.toUnmodifiableSet());
    }

    private static int isDrawnLastToInt(Layerable layerable) {
        if (layerable instanceof Layer && ((Layer)layerable).isDrawingLast()) {
            return 1;
        }
        return 0;
    }

    public List<Layer> getVisibleLayers(boolean includeFence) {
        ArrayList<Layer> visibleLayers = new ArrayList<Layer>(this.getLayers());
        Iterator i = visibleLayers.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (layer.isVisible()) continue;
            i.remove();
        }
        return visibleLayers;
    }

    public static void dispose(Layerable layerable) {
        layerable.setCategory(null);
        layerable.dispose();
    }

    public void dispose() {
        for (Layerable ly : this.getLayerables()) {
            if (ly == null) continue;
            ly.dispose();
        }
        this.layerListeners.clear();
        this.blackboard = null;
        --layerManagerCount;
        this.undoableEditReceiver.getUndoManager().discardAllEdits();
    }

    public static int layerManagerCount() {
        return layerManagerCount;
    }

    public Collection<Layer> getEditableLayers() {
        ArrayList<Layer> editableLayers = new ArrayList<Layer>();
        for (Layer layer : this.getLayers()) {
            if (!layer.isEditable()) continue;
            editableLayers.add(layer);
        }
        return editableLayers;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public boolean isModified() {
        for (Layerable ly : this.rootcat.getAllLayerables()) {
            if (!ly.isModified()) continue;
            return true;
        }
        for (Category cat : this.rootcat.getAllSubcategories()) {
            if (!cat.isModified()) continue;
            return true;
        }
        return false;
    }

    public Collection<Object> getModfiedObjects() {
        ArrayList<Object> modifiedObjs = new ArrayList<Object>();
        for (Layerable ly : this.rootcat.getAllLayerables()) {
            if (!ly.isModified()) continue;
            modifiedObjs.add(ly);
        }
        for (Category cat : this.rootcat.getAllSubcategories()) {
            if (!cat.isModified()) continue;
            modifiedObjs.add(cat);
        }
        return modifiedObjs;
    }

    public Collection<Layer> getModifiedLayers() {
        ArrayList<Layer> modifiedLayers = new ArrayList<Layer>();
        for (Layer layer : this) {
            if ((!layer.isEditable() || !layer.hasEditedFeatures()) && (!(layer instanceof RedlineLayer) || !((RedlineLayer)layer).isMetaDataModified())) continue;
            modifiedLayers.add(layer);
        }
        return modifiedLayers;
    }

    public void fireFeaturesAttChanged(Collection<SimpleFeature> features, FeatureEventType type, Layer layer, Collection<SimpleFeature> oldFeatureClones) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, oldFeatureClones);
    }

    public void cleanUp() {
        for (Layerable ly : this.getLayerables(Layerable.class)) {
            ly.cleanUp();
        }
    }

    public final Collection<Layerable> getContentIDsDescending() {
        return this.getContentIDsDescending(Layerable.class);
    }

    public final <T extends Layerable> Collection<T> getContentIDsDescending(Class<T> clazz) {
        ArrayList<Layerable> contentIDs = new ArrayList<Layerable>();
        Iterator<T> i = this.reverseIterator(clazz, true);
        while (i.hasNext()) {
            contentIDs.add((Layerable)i.next());
        }
        return contentIDs;
    }

    public <E extends Exception> void updateSilently(ThrowingRunnable<E> action) throws E {
        boolean isFiringEvents = this.isFiringEvents();
        try {
            this.setFiringEvents(false);
            action.run();
        }
        finally {
            this.setFiringEvents(isFiringEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T updateSilently(ThrowingSupplier<T, E> supplier) throws E {
        boolean isFiringEvents = this.isFiringEvents();
        try {
            this.setFiringEvents(false);
            T t = supplier.get();
            return t;
        }
        finally {
            this.setFiringEvents(isFiringEvents);
        }
    }

    static {
        dummyLayerManager.setFiringEvents(false);
        DEFAULT_LAYER_COMPARATOR = Comparator.comparing(LayerManager::isDrawnLastToInt).thenComparing(Layerable.COMPARE_LAYERABLE_BYPRIORITY).thenComparing(Layerable::getKey);
    }
}

