/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.google.common.collect.Sets;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.FeatureIteratorProxy;
import com.vividsolutions.jump.workbench.model.HasLayerContext;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.FeatureMapWriter;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.geotools.feature.CollectionFeatureIterator;
import de.riwagis.geotools.feature.EmptyFeatureIterator;
import de.riwagis.geotools.feature.FeatureReaderIterator;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.TransformingFeatureIterator;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.gis.context.jump.VectorLayerContextImpl;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.data.model.TransformationService;
import de.riwagis.riwajump.feature.ModifiedFeatureIterator;
import de.riwagis.riwajump.feature.WhiteListFeatureIterator;
import de.riwagis.riwajump.model.attribute.AttributeProperty;
import de.riwagis.riwajump.model.attribute.AttributeTableModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.theme.BasicStaticThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import de.riwagis.util.exception.SystemException;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureReader;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="layer")
public class Layer
extends AbstractLayerable
implements LayerManagerProxy,
FeatureIteratorProxy,
HasLayerContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)Layer.class.getName());
    public static final int FEATURE_ADD = 1;
    public static final int FEATURE_MODIFY = 2;
    public static final int FEATURE_DELETE = 3;
    private boolean drawingLast = false;
    private FeaturestoreMetadata fmd = new FeaturestoreMetadata();
    private AttributeTableModel attributeTable = new AttributeTableModel();
    private final Blackboard blackboard = new Blackboard();
    protected boolean editable = false;
    protected boolean selectable = true;
    private boolean bolRender2SaveMemory = false;
    private boolean bolCacheAll = false;
    private boolean bolCacheMinEnv = false;
    private double dblCacheEnvSize = 0.0;
    private String labelLayerKey = null;
    private transient boolean bolReloadAll = true;
    private transient STRtree featIndex = new STRtree();
    private transient Map<String, SimpleFeature> keyIndex = new HashMap<String, SimpleFeature>();
    private transient Boolean bolFMDEditable = null;
    private transient ShapeFeatureSTRtree renderIndex = new ShapeFeatureSTRtree();
    private transient Envelope lastEnv = null;
    private transient int lastCount = -1;
    private transient Map<String, SimpleFeature> mapFeatureModified = new HashMap<String, SimpleFeature>();
    private transient Map<String, SimpleFeature> mapFeatureAdded = new HashMap<String, SimpleFeature>();
    private transient Map<String, SimpleFeature> mapFeatureDeleted = new HashMap<String, SimpleFeature>();
    private transient VectorLayerContext vectorLayerContext = null;
    private transient Lock idxLock = new ReentrantLock();
    private transient ReadWriteLock editLock = new ReentrantReadWriteLock();
    private transient Collection<String> fidFilterWhiteList = null;
    private transient TransformationService transformer = new TransformationService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer(String name, Color fillColor, FeaturestoreMetadata _fmd, LayerManager layerManager) {
        super(name, layerManager);
        Assert.isTrue((_fmd != null ? 1 : 0) != 0);
        this.fmd = _fmd;
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
            styleCollection.initializeDefault(fillColor);
            this.addStyleCollection(styleCollection);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    protected Layer(String name, FeaturestoreMetadata _fmd, LayerManager layerManager) {
        super(name, layerManager);
        Assert.isTrue((_fmd != null ? 1 : 0) != 0);
        this.fmd = _fmd;
    }

    protected Object readResolve() {
        this.featIndex = new STRtree();
        this.keyIndex = new HashMap<String, SimpleFeature>();
        this.renderIndex = new ShapeFeatureSTRtree();
        this.lastCount = -1;
        this.mapFeatureModified = new HashMap<String, SimpleFeature>();
        this.mapFeatureAdded = new HashMap<String, SimpleFeature>();
        this.mapFeatureDeleted = new HashMap<String, SimpleFeature>();
        this.idxLock = new ReentrantLock();
        this.editLock = new ReentrantReadWriteLock();
        this.bolReloadAll = true;
        this.transformer = new TransformationService();
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.idxLock.lock();
            this.renderIndex = null;
            this.featIndex = null;
        }
        finally {
            this.idxLock.unlock();
        }
        this.keyIndex = null;
        this.mapFeatureModified = Collections.emptyMap();
        this.mapFeatureAdded = Collections.emptyMap();
        this.mapFeatureDeleted = Collections.emptyMap();
        this.fmd = null;
        this.setCategory(null);
    }

    @Override
    public int getLayerType() {
        return 0;
    }

    public boolean getRender2SaveMemory() {
        return this.bolRender2SaveMemory;
    }

    public void setRender2SaveMemory(boolean _bolRender2SaveMemory) {
        this.bolRender2SaveMemory = _bolRender2SaveMemory;
        if (this.bolRender2SaveMemory) {
            this.bolReloadAll = true;
        }
    }

    public boolean getCacheAll() {
        return this.bolCacheAll;
    }

    public void setCacheAll(boolean _bolCacheAll) {
        this.bolCacheAll = _bolCacheAll;
        if (this.bolCacheAll) {
            this.bolReloadAll = true;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.clearFeatureCache();
        }
        super.setVisible(visible);
    }

    public boolean getCacheMinEnv() {
        return this.bolCacheMinEnv;
    }

    public void setCacheMinEnv(boolean _bolUseMinEnv) {
        this.bolCacheMinEnv = _bolUseMinEnv;
    }

    public double getCacheEnvSize() {
        return this.dblCacheEnvSize;
    }

    public void setCacheEnvSize(double _dblMinEnvSize) {
        this.dblCacheEnvSize = _dblMinEnvSize;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    private boolean isGeometryAllowed(Geometry geom) {
        if (geom == null) {
            return true;
        }
        if (!geom.isValid()) {
            LOG.warn("Invalid geometry in isGeometryAllowed");
            return false;
        }
        return geom.isEmpty() || this.fmd.isGeometryAllowed(geom.getClass());
    }

    @Override
    public LayerContext getLayerContext() {
        return this.getVectorLayerContext();
    }

    public VectorLayerContext getVectorLayerContext() {
        if (this.vectorLayerContext == null) {
            this.vectorLayerContext = new VectorLayerContextImpl(this);
        }
        return this.vectorLayerContext;
    }

    public FeatureIterator<SimpleFeature> getSelectedFeatures() {
        TaskFrame frmTask = JUMPWorkbench.getFrame().getTaskFrameByTask(this.getLayerManager().getTask());
        return new CollectionFeatureIterator(frmTask.getSelectionManager().getFeaturesWithSelectedItems(this));
    }

    public Iterator<String> getSelectedFeatureKeys() {
        FeatureIterator<SimpleFeature> fi = this.getSelectedFeatures();
        ArrayList<String> lstKeys = new ArrayList<String>();
        while (fi.hasNext()) {
            lstKeys.add(((SimpleFeature)fi.next()).getID());
        }
        return lstKeys.iterator();
    }

    public int getFeatureCount(boolean useCache) throws Exception {
        if (this.lastCount != -1 && useCache) {
            return this.lastCount;
        }
        this.lastCount = this.fmd.getCount(this.getDMDCol());
        return this.lastCount;
    }

    public int getFeatureCountForFilter(Filter filter) throws Exception {
        return this.fmd.getCount(this.getDMDCol(), filter);
    }

    public DMDCollection getDMDCol() {
        if (this.getLayerManager() == null) {
            return null;
        }
        if (this.getLayerManager().getTask() == null) {
            return null;
        }
        return this.getLayerManager().getTask().getDataStores();
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Envelope env) throws Exception {
        return this.getFeatureIterator(this.getEnvelopeFilter(env));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeaturesToIndex(Iterable<SimpleFeature> features) {
        try {
            this.idxLock.lock();
            for (SimpleFeature feature : features) {
                this.keyIndex.putIfAbsent(feature.getID(), feature);
            }
        }
        finally {
            this.idxLock.unlock();
        }
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Filter andFilter) throws Exception {
        return this.getFeatureIterator(andFilter, Integer.MAX_VALUE);
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Filter andFilter, int limit) throws Exception {
        return this.getWhiteListFeatureIterator(this.getEditableIterator(this.getTransIterator((FeatureIterator<SimpleFeature>)new FeatureReaderIterator(this.fmd.getFeatureReader(this.getDMDCol(), andFilter, limit))), andFilter));
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Filter andFilter, Set<String> attributes) throws Exception {
        return this.getFeatureIterator(andFilter, attributes, Integer.MAX_VALUE);
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Filter andFilter, Set<String> attributes, int limit) throws Exception {
        return this.getWhiteListFeatureIterator(this.getEditableIterator(this.getTransIterator((FeatureIterator<SimpleFeature>)new FeatureReaderIterator(this.fmd.getFeatureReader(this.getDMDCol(), andFilter, (String[])attributes.toArray(String[]::new), limit))), this.fmd.getFilter(andFilter)));
    }

    protected Envelope getRenderEnvelope(Envelope env) {
        if (this.getLayerManager().getBlackboard().contains("print_envelope")) {
            env = new Envelope((Envelope)this.getLayerManager().getBlackboard().get("print_envelope"));
            env.expandBy(this.getLayerManager().getTask().getWrapAround());
            return env;
        }
        env = new Envelope(env);
        env.expandBy(this.getLayerManager().getTask().getWrapAround());
        return env;
    }

    @Override
    public FeatureIterator<SimpleFeature> getRenderIterator(Envelope env) throws Exception {
        try {
            this.idxLock.lock();
            if (env == null) {
                DefaultFeatureCollection fc = new DefaultFeatureCollection(null, null);
                FeatureIterator featureIterator = fc.features();
                return featureIterator;
            }
            if (this.getValidLayerStyleCollection() != null) {
                env = this.getRenderEnvelope(env);
            }
            if (this.bolCacheAll) {
                if (this.bolReloadAll) {
                    this.rebuildIndex(this.getEnvelopeFilter(null));
                    this.bolReloadAll = false;
                }
                this.lastEnv = env;
                FeatureIterator<SimpleFeature> fc = this.getLastFeatureIterator(env);
                return fc;
            }
            if (this.lastEnv == null || !this.lastEnv.contains(env)) {
                long timestart = System.currentTimeMillis();
                if (this.bolCacheMinEnv) {
                    double dblExpand;
                    if (env.getWidth() < this.dblCacheEnvSize) {
                        dblExpand = this.dblCacheEnvSize - env.getWidth();
                        env.expandBy(dblExpand / 2.0, 0.0);
                    }
                    if (env.getHeight() < this.dblCacheEnvSize) {
                        dblExpand = this.dblCacheEnvSize - env.getHeight();
                        env.expandBy(0.0, dblExpand / 2.0);
                    }
                }
                this.lastEnv = env;
                this.rebuildIndex(this.getEnvelopeFilter(env));
                long timeend = System.currentTimeMillis();
                LOG.debug("Loading Data - Layer: " + this.getName() + " - " + (timeend - timestart));
            }
            FeatureIterator<SimpleFeature> timestart = this.getLastFeatureIterator(env);
            return timestart;
        }
        catch (Exception e) {
            try {
                this.clearFeatureCache();
            }
            catch (Exception e1) {
                LOG.error("could not clear feature cache", (Throwable)e1);
            }
            throw e;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    private FeatureIterator<SimpleFeature> getTransIterator(FeatureIterator<SimpleFeature> fi) throws Exception {
        if (!this.transformer.hasTransformation(this.fmd, this.getDMDCol())) {
            return fi;
        }
        return new TransformingFeatureIterator(fi, this.transformer.getTransformer(this.fmd, this.getDMDCol()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureIterator<SimpleFeature> getEditableIterator(FeatureIterator<SimpleFeature> fi, Filter filter) {
        if (!this.isEditableInternal() || !this.hasUncommitedData()) {
            return fi;
        }
        try {
            this.editLock.readLock().lock();
            ModifiedFeatureIterator modifiedFeatureIterator = new ModifiedFeatureIterator(this.fmd, fi, new HashMap<Object, SimpleFeature>(this.mapFeatureDeleted), new HashMap<Object, SimpleFeature>(this.mapFeatureAdded), new HashMap<Object, SimpleFeature>(this.mapFeatureModified), filter);
            return modifiedFeatureIterator;
        }
        finally {
            this.editLock.readLock().unlock();
        }
    }

    private FeatureIterator<SimpleFeature> getWhiteListFeatureIterator(FeatureIterator<SimpleFeature> fi) {
        if (this.fidFilterWhiteList == null) {
            return fi;
        }
        String whiteListKeyAtt = WhiteListFeatureIterator.getWhiteListAttribute(this.fmd);
        return new WhiteListFeatureIterator(fi, this.fidFilterWhiteList, whiteListKeyAtt);
    }

    public boolean hasUncommitedData() {
        try {
            this.editLock.readLock().lock();
            boolean bl = this.mapFeatureAdded.size() > 0 || this.mapFeatureDeleted.size() > 0 || this.mapFeatureModified.size() > 0;
            return bl;
        }
        finally {
            this.editLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureIterator<SimpleFeature> getLastFeatureIterator(Envelope env) throws Exception {
        try {
            this.idxLock.lock();
            if (env == null) {
                env = this.lastEnv;
            }
            if (this.featIndex.size() == 0 && !this.isEditable()) {
                EmptyFeatureIterator emptyFeatureIterator = new EmptyFeatureIterator();
                return emptyFeatureIterator;
            }
            List results = this.featIndex.query(env);
            CollectionFeatureIterator fi = new CollectionFeatureIterator((Collection)results);
            FeatureIterator<SimpleFeature> featureIterator = this.getWhiteListFeatureIterator(this.getEditableIterator((FeatureIterator<SimpleFeature>)fi, this.fmd.getFilter(this.getEnvelopeFilter(env, false))));
            return featureIterator;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    private void rebuildIndex(Filter andFilter) throws Exception {
        FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.fmd.getFeatureReader(this.getDMDCol(), andFilter);
        Objects.requireNonNull(fread, "NULL FeatureReader returned from datastore.");
        FeatureIterator<SimpleFeature> i = this.getTransIterator((FeatureIterator<SimpleFeature>)new FeatureReaderIterator(fread));
        SimpleFeature f = null;
        String strLastID = "";
        try (FeatureIterator<SimpleFeature> featureIterator = i;){
            this.idxLock.lock();
            this.featIndex = new STRtree();
            this.keyIndex.clear();
            while (i.hasNext()) {
                f = (SimpleFeature)i.next();
                if (f == null) {
                    throw new SystemException("Feature returned from datastore was null. Please check logs.");
                }
                Geometry geom = (Geometry)f.getDefaultGeometry();
                if (geom != null && !geom.isEmpty()) {
                    Envelope env = ((Geometry)f.getDefaultGeometry()).getEnvelopeInternal();
                    this.featIndex.insert(env, (Object)f);
                }
                this.keyIndex.put(f.getID(), f);
                strLastID = f.getID();
            }
        }
        catch (Exception e) {
            if (f != null) {
                LOG.error("Error building index for layer: " + this.getKey() + " at feature FID:" + f.getID(), (Throwable)e);
            } else {
                LOG.error("Unknown error building index for layer: " + this.getKey() + ". Feature is null. Last feature that could be read from datastore was feature FID:" + strLastID, (Throwable)e);
            }
            throw e;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    public ShapeFeatureSTRtree createEmptyRenderIndex() {
        return new ShapeFeatureSTRtree();
    }

    public Iterator<Object> getRenderedIndexIterator(Rectangle2D env) {
        return this.getRenderedIndex(env).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getRenderedIndex(Rectangle2D env) {
        boolean lockAquired = false;
        try {
            lockAquired = this.idxLock.tryLock();
            if (lockAquired) {
                List list = this.renderIndex.query(env);
                return list;
            }
            List<Object> list = Collections.emptyList();
            return list;
        }
        finally {
            if (lockAquired) {
                this.idxLock.unlock();
            }
        }
    }

    public synchronized void setRenderIndex(ShapeFeatureSTRtree _renderIndex) {
        try {
            this.idxLock.lock();
            this.renderIndex = _renderIndex;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    public SimpleFeatureType getFeatureType() {
        try {
            if (this.fmd == null || Objects.toString(this.fmd.getDatatypeName(), "").isEmpty()) {
                LOG.debug("Layer " + this.getKey() + " has no feature type.");
                return FeatureUtil.getEmptyFeatureType();
            }
            return this.fmd.getQuerySchema(this.getDMDCol());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            Assert.shouldNeverReachHere((String)(this.getName() + " - Error creating FeatureType."));
            return FeatureUtil.getEmptyFeatureType();
        }
    }

    public Filter getEnvelopeFilter(Envelope env) throws Exception {
        return this.getEnvelopeFilter(env, true);
    }

    public Filter getEnvelopeFilter(Envelope env, boolean transformToFMD) throws Exception {
        if (env == null || env.isNull()) {
            return Filter.INCLUDE;
        }
        Envelope tmpenv = new Envelope(env);
        if (transformToFMD && this.transformer.hasTransformation(this.fmd, this.getDMDCol())) {
            this.transformer.getTransformer(this.fmd, this.getDMDCol()).invtransform2d(tmpenv);
            tmpenv.expandBy(tmpenv.getWidth() * 0.1);
        }
        SimpleFeatureType fType = this.fmd.getSchema(this.getDMDCol());
        return FilterUtil.getEnvelopeFilter((Envelope)tmpenv, (SimpleFeatureType)fType);
    }

    private Filter getFidFilter(String fid) throws Exception {
        return FilterUtil.getFidFilter((String)fid);
    }

    public void setDrawingLast(boolean drawingLast) {
        this.drawingLast = drawingLast;
        this.fireAppearanceChanged();
    }

    public void setFMD(FeaturestoreMetadata _fmd) {
        this.fmd = _fmd;
    }

    public FeaturestoreMetadata getFMD() {
        return this.fmd;
    }

    public void setAttributeTable(AttributeTableModel attributeTable) {
        this.attributeTable = attributeTable;
    }

    public AttributeTableModel getAttributeTable() {
        this.synchronizeAttributeTableWithFMD();
        return this.attributeTable;
    }

    private void synchronizeAttributeTableWithFMD() {
        if (this.getFMD() == null || this.getFMD().getAttributes() == null) {
            return;
        }
        String[] attributes = this.getFMD().getAttributes();
        List attributeProperties = this.attributeTable.getAttributeProperties();
        Set currentAttributes = attributeProperties.stream().map(p -> p.getName()).collect(Collectors.toSet());
        HashSet<String> newAttributes = new HashSet<String>(Arrays.asList(attributes));
        Sets.SetView attributes2Add = Sets.difference(newAttributes, currentAttributes);
        Sets.SetView attributes2Delete = Sets.difference(currentAttributes, newAttributes);
        attributeProperties.removeIf(arg_0 -> Layer.lambda$synchronizeAttributeTableWithFMD$2((Set)attributes2Delete, arg_0));
        for (String attributeName : attributes2Add) {
            AttributeProperty property = new AttributeProperty();
            property.setName(attributeName);
            property.setVisible(true);
            attributeProperties.add(property);
        }
    }

    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public boolean isEditableInternal() {
        return this.editable;
    }

    public boolean isEditable() {
        if (!this.editable || this.getRenderError() != null) {
            return false;
        }
        if (!this.isFMDEditable()) {
            return false;
        }
        return this.editable;
    }

    public boolean isFMDEditable() {
        try {
            if (this.bolFMDEditable == null) {
                DMDCollection dmdCol = this.getDMDCol();
                if (dmdCol == null) {
                    return false;
                }
                this.bolFMDEditable = this.fmd.isWriteable(dmdCol);
            }
            return this.bolFMDEditable;
        }
        catch (IOException | RuntimeException e) {
            this.setRenderError(String.format("Error on checking r/w permission: %s", e.getMessage()));
            return false;
        }
    }

    public SimpleFeature getFeatureByKey(String strFID) throws Exception {
        return this.getFeatureByKey(strFID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature getFeatureByKey(String strFID, boolean bolQueryStore) throws Exception {
        try {
            SimpleFeature feat;
            block24: {
                this.idxLock.lock();
                Object strFIDIndex = strFID = FeatureUtil.getFeatureIDWithoutTable((String)strFID);
                if (this.getFMD().getKeyAtt() == null) {
                    strFIDIndex = this.getFMD().getDatatypeName() + "." + (String)strFID;
                }
                if (this.mapFeatureDeleted.containsKey(strFIDIndex)) {
                    SimpleFeature simpleFeature = null;
                    return simpleFeature;
                }
                feat = this.getFeatureByKeyFromIndex((String)strFIDIndex);
                if (feat == null && bolQueryStore) {
                    if (this.getFMD().getKeyAtt() != null) {
                        Filter filt = FilterUtil.getCQLFilter((String)(this.getFMD().getKeyAtt() + "=" + (String)strFID));
                        try (FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.getFMD().getFeatureReader(this.getDMDCol(), filt);){
                            if (fread.hasNext()) {
                                SimpleFeature simpleFeature = (SimpleFeature)fread.next();
                                return simpleFeature;
                            }
                            break block24;
                        }
                    }
                    strFID = this.getFMD().getDatatypeName() + "." + (String)strFID;
                    try (FeatureReader<SimpleFeatureType, SimpleFeature> fread = this.getFMD().getFeatureReader(this.getDMDCol(), this.getFidFilter((String)strFID));){
                        if (fread.hasNext()) {
                            SimpleFeature simpleFeature = (SimpleFeature)fread.next();
                            return simpleFeature;
                        }
                    }
                }
            }
            SimpleFeature simpleFeature = feat;
            return simpleFeature;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    protected void fireFeatureChanged(Collection<SimpleFeature> features, Collection<SimpleFeature> oldFeatureClones, int action) {
        if (this.getLayerManager() == null) {
            return;
        }
        if (action == 1) {
            this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.ADDED, this);
        }
        if (action == 2) {
            this.getLayerManager().fireFeaturesAttChanged(features, FeatureEventType.ATTRIBUTES_MODIFIED, this, oldFeatureClones);
        }
        if (action == 3) {
            this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.DELETED, this);
        }
    }

    protected String isFeatureValid(SimpleFeature feat, int action) {
        if (feat.getFeatureType().getAttributeCount() != this.getFeatureType().getAttributeCount() && !this.isSubsetOfSchema(feat)) {
            return "Invalid feature type.";
        }
        if (action != 1 && action != 3 && action != 2) {
            return "Invalid edit feature action: " + action;
        }
        if (action == 3) {
            return null;
        }
        Geometry geom = (Geometry)feat.getDefaultGeometry();
        if (geom != null && !geom.isValid()) {
            return I18N.get("model.Layer.no-invalid-geometries");
        }
        Geometry simplified = Layer.trySimplifyToSingleGeometry(geom);
        if (simplified != geom) {
            feat.setDefaultGeometry((Object)simplified);
        }
        if (!this.isGeometryAllowed(simplified)) {
            return I18N.get("model.Layer.wrong-type") + String.valueOf(this) + ".";
        }
        return null;
    }

    private static Geometry trySimplifyToSingleGeometry(Geometry source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        Geometry singleGeometry = source;
        while (singleGeometry.getNumGeometries() == 1 && singleGeometry instanceof GeometryCollection) {
            singleGeometry = singleGeometry.getGeometryN(0);
        }
        return singleGeometry;
    }

    private boolean isSubsetOfSchema(SimpleFeature feat) {
        try {
            SimpleFeatureType maybeSubset = feat.getFeatureType();
            SimpleFeatureType fullSchema = this.getFMD().getWriteableSchema(this.getLayerManager().getTask().getDataStores());
            for (AttributeDescriptor attributeDescriptor : maybeSubset.getAttributeDescriptors()) {
                if (fullSchema.getDescriptor(attributeDescriptor.getName()) != null) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.error("Could not determine full schema for layer '{}'", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void editFeature(SimpleFeature feat, int action, Collection<SimpleFeature> oldFeatures) throws Exception {
        try {
            this.editLock.writeLock().lock();
            String strError = this.isFeatureValid(feat, action);
            if (strError != null) {
                throw new Exception(strError);
            }
            switch (action) {
                case 1: {
                    if (!this.fmd.isInsertAllowed()) {
                        throw new Exception(I18N.get("model.Layer.no-insert") + String.valueOf(this) + ".");
                    }
                    this.mapFeatureAdded.put(feat.getID(), feat);
                    return;
                }
                case 2: {
                    if (this.mapFeatureAdded.containsKey(feat.getID())) {
                        oldFeatures.add(this.mapFeatureAdded.get(feat.getID()));
                        this.mapFeatureAdded.put(feat.getID(), feat);
                        return;
                    }
                    String strFID = feat.getID();
                    if (this.mapFeatureModified.containsKey(strFID)) {
                        oldFeatures.add(this.mapFeatureModified.get(strFID));
                    } else {
                        SimpleFeature oldFeature = this.getFeatureByKey(strFID);
                        if (oldFeature != null) {
                            oldFeatures.add(oldFeature);
                        }
                    }
                    this.mapFeatureModified.put(strFID, feat);
                    return;
                }
                case 3: {
                    SimpleFeature oldFeature;
                    if (!this.fmd.isDeleteAllowed()) {
                        throw new Exception(I18N.get("model.Layer.no-delete") + String.valueOf(this) + ".");
                    }
                    if (this.mapFeatureAdded.containsKey(feat.getID())) {
                        this.mapFeatureAdded.remove(feat.getID());
                        return;
                    }
                    if (this.mapFeatureModified.containsKey(feat.getID())) {
                        this.mapFeatureModified.remove(feat.getID());
                    }
                    if ((oldFeature = this.getFeatureByKey(feat.getID())) != null) {
                        oldFeatures.add(oldFeature);
                    }
                    this.mapFeatureDeleted.put(feat.getID(), feat);
                    return;
                }
            }
            return;
        }
        finally {
            this.editLock.writeLock().unlock();
        }
    }

    public SimpleFeature getFeatureAddedByKey(String strID) {
        if (this.mapFeatureAdded.containsKey(strID)) {
            return this.mapFeatureAdded.get(strID);
        }
        return null;
    }

    private SimpleFeature getFeatureByKeyFromIndex(String strID) {
        this.editLock.readLock().lock();
        try {
            if (this.mapFeatureAdded.containsKey(strID)) {
                SimpleFeature simpleFeature = this.mapFeatureAdded.get(strID);
                return simpleFeature;
            }
            if (this.mapFeatureModified.containsKey(strID)) {
                SimpleFeature simpleFeature = this.mapFeatureModified.get(strID);
                return simpleFeature;
            }
            SimpleFeature simpleFeature = this.keyIndex.get(strID);
            return simpleFeature;
        }
        finally {
            this.editLock.readLock().unlock();
        }
    }

    public synchronized void editFeature(Collection<SimpleFeature> col, int action) {
        try {
            if (!this.isEditableInternal()) {
                throw new Exception("Layer " + String.valueOf(this) + " is not editable.");
            }
            Iterator<SimpleFeature> iter = col.iterator();
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            HashMap<String, SimpleFeature> mapFeatureAddedSnapshot = null;
            HashMap<String, SimpleFeature> mapFeatureModifiedSnapshot = null;
            HashMap<String, SimpleFeature> mapFeatureDeletedSnapshot = null;
            try {
                this.editLock.writeLock().lock();
                mapFeatureAddedSnapshot = new HashMap<String, SimpleFeature>(this.mapFeatureAdded);
                mapFeatureModifiedSnapshot = new HashMap<String, SimpleFeature>(this.mapFeatureModified);
                mapFeatureDeletedSnapshot = new HashMap<String, SimpleFeature>(this.mapFeatureDeleted);
                while (iter.hasNext()) {
                    this.editFeature(iter.next(), action, lstOldFeatures);
                }
            }
            catch (Exception ex) {
                if (mapFeatureAddedSnapshot != null) {
                    this.mapFeatureAdded = mapFeatureAddedSnapshot;
                }
                if (mapFeatureModifiedSnapshot != null) {
                    this.mapFeatureModified = mapFeatureModifiedSnapshot;
                }
                if (mapFeatureDeletedSnapshot != null) {
                    this.mapFeatureDeleted = mapFeatureDeletedSnapshot;
                }
                throw ex;
            }
            finally {
                this.editLock.writeLock().unlock();
            }
            this.fireFeatureChanged(col, lstOldFeatures, action);
            if (!this.isVisibleOnScreen()) {
                this.setVisibleOnScreen();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean hasEditedFeatures() {
        try {
            this.editLock.readLock().lock();
            if (this.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.mapFeatureAdded.isEmpty() || !this.mapFeatureModified.isEmpty() || !this.mapFeatureDeleted.isEmpty();
            return bl;
        }
        finally {
            this.editLock.readLock().unlock();
        }
    }

    public boolean isAddedFeature(String fid) {
        return this.mapFeatureAdded.containsKey(fid);
    }

    public boolean isModifiedFeature(String fid) {
        return this.mapFeatureModified.containsKey(fid);
    }

    public boolean isDeletedFeature(String fid) {
        return this.mapFeatureDeleted.containsKey(fid);
    }

    public boolean hasAddedFeatures() {
        return !this.mapFeatureAdded.isEmpty();
    }

    public boolean hasModifiedFeatures() {
        return !this.mapFeatureModified.isEmpty();
    }

    public boolean hasDeletedFeatures() {
        return !this.mapFeatureDeleted.isEmpty();
    }

    public int commitEditedFeatures() throws Exception {
        return this.commitEditedFeatures(true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commitEditedFeatures(boolean bolAdded, boolean bolModified, boolean bolDeleted) throws Exception {
        LabelLayer labelLayer;
        int n;
        try {
            this.editLock.writeLock().lock();
            if (!this.isEditableInternal()) {
                throw new Exception(I18N.getMessage("model.Layer.not-editable", this.toString()));
            }
            FeatureMapWriter mapWriter = new FeatureMapWriter(this.getDMDCol(), this.getFMD());
            if (bolAdded) {
                mapWriter.setFeatureAddedMap(this.mapFeatureAdded);
            } else {
                mapWriter.setFeatureAddedMap(new HashMap<String, SimpleFeature>());
            }
            if (bolDeleted) {
                mapWriter.setFeatureDeletedMap(this.mapFeatureDeleted);
            } else {
                mapWriter.setFeatureDeletedMap(new HashMap<String, SimpleFeature>());
            }
            if (bolModified) {
                mapWriter.setFeatureModifiedMap(this.mapFeatureModified);
            } else {
                mapWriter.setFeatureModifiedMap(new HashMap<String, SimpleFeature>());
            }
            int commitedFeatures = mapWriter.commitFeatures();
            if (commitedFeatures == 0) {
                throw new IOException("No features committed for layer '" + this.getName() + "'");
            }
            n = commitedFeatures;
            this.editLock.writeLock().unlock();
            labelLayer = this.getLabelLayer();
        }
        catch (Throwable throwable) {
            this.editLock.writeLock().unlock();
            LabelLayer labelLayer2 = this.getLabelLayer();
            try {
                this.clearFeatureCache();
                if (labelLayer2 != null) {
                    labelLayer2.clearFeatureCache();
                }
            }
            catch (Exception eatit) {
                LOG.error(String.format("Error clearing feature cache of layer with key '%s' after commit of changes.", this.getKey()), (Throwable)eatit);
            }
            this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
            this.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
            if (labelLayer2 != null) {
                labelLayer2.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
                labelLayer2.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
            }
            throw throwable;
        }
        try {
            this.clearFeatureCache();
            if (labelLayer != null) {
                labelLayer.clearFeatureCache();
            }
        }
        catch (Exception eatit) {
            LOG.error(String.format("Error clearing feature cache of layer with key '%s' after commit of changes.", this.getKey()), (Throwable)eatit);
        }
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
        this.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
        if (labelLayer != null) {
            labelLayer.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
            labelLayer.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
        }
        return n;
    }

    public int getNumEditedFeatures() {
        try {
            this.editLock.readLock().lock();
            int n = this.mapFeatureAdded.size() + this.mapFeatureModified.size() + this.mapFeatureDeleted.size();
            return n;
        }
        finally {
            this.editLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackEditedFeatures() {
        Collection<SimpleFeature> lstModifiedOld;
        Collection<SimpleFeature> lstAdded;
        Collection<SimpleFeature> lstRemoved;
        try {
            this.editLock.writeLock().lock();
            lstRemoved = this.getFeaturesAsList(this.mapFeatureAdded);
            this.mapFeatureAdded.clear();
            lstAdded = this.getFeaturesAsList(this.mapFeatureDeleted);
            this.mapFeatureDeleted.clear();
            lstModifiedOld = this.getFeaturesAsList(this.mapFeatureModified);
            this.mapFeatureModified.clear();
        }
        finally {
            this.editLock.writeLock().unlock();
        }
        ArrayList<SimpleFeature> lstModified = new ArrayList<SimpleFeature>();
        for (SimpleFeature fOld : lstModifiedOld) {
            try {
                SimpleFeature feat = this.getFeatureByKey(fOld.getID(), false);
                if (feat == null) continue;
                lstModified.add(feat);
            }
            catch (Exception ex) {
                LOG.error("Error at rollbackEditedFeatures", (Throwable)ex);
            }
        }
        if (lstAdded.size() > 0) {
            this.fireFeatureChanged(lstAdded, new ArrayList<SimpleFeature>(), 1);
        }
        if (lstRemoved.size() > 0) {
            this.fireFeatureChanged(lstRemoved, lstRemoved, 3);
        }
        if (lstModifiedOld.size() > 0) {
            this.fireFeatureChanged(lstModified, lstModifiedOld, 2);
        }
    }

    private Collection<SimpleFeature> getFeaturesAsList(Map<String, SimpleFeature> mapFeatures) {
        return Collections.unmodifiableCollection(mapFeatures.values());
    }

    public void clearFeatureCache() {
        try {
            this.idxLock.lock();
            this.bolFMDEditable = null;
            this.bolReloadAll = true;
            this.lastEnv = new Envelope();
            this.featIndex = new STRtree();
            this.keyIndex = new HashMap<String, SimpleFeature>();
            this.renderIndex = new ShapeFeatureSTRtree();
            this.lastCount = -1;
        }
        finally {
            this.idxLock.unlock();
        }
    }

    @Override
    public Collection<Layerable> reload() {
        this.clearRendererCache();
        this.clearFeatureCache();
        if (this.doesStyleModelsContainDynamicThemeSource()) {
            this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        }
        try {
            if (this.getFMD().getDataStore(this.getDMDCol()) instanceof WFSDataStore) {
                this.getFMD().resetDataStore(this.getDMDCol());
            }
        }
        catch (IOException e) {
            LOG.debug("Unable to dispose WFSDataStore {}: {}", (Object)this.getNameForExport(), (Object)e);
        }
        LabelLayer labelLayer = this.getLabelLayer();
        ArrayList<Layerable> retList = new ArrayList<Layerable>();
        if (labelLayer != null) {
            retList.addAll(labelLayer.reload());
        }
        retList.addAll(super.reload());
        return retList;
    }

    @Override
    public Layer clone() throws CloneNotSupportedException {
        Layer cloneLy = (Layer)super.clone();
        cloneLy.mapFeatureModified = new HashMap<String, SimpleFeature>();
        cloneLy.mapFeatureAdded = new HashMap<String, SimpleFeature>();
        cloneLy.mapFeatureDeleted = new HashMap<String, SimpleFeature>();
        cloneLy.fmd = this.fmd.clone();
        cloneLy.labelLayerKey = null;
        cloneLy.vectorLayerContext = null;
        cloneLy.idxLock = new ReentrantLock();
        cloneLy.editLock = new ReentrantReadWriteLock();
        cloneLy.clearFeatureCache();
        cloneLy.rollbackEditedFeatures();
        cloneLy.transformer = new TransformationService();
        try {
            cloneLy.setEditable(false);
        }
        catch (Exception eatit) {
            LOG.warn("Editability could not be cloned", (Throwable)eatit);
        }
        return cloneLy;
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
        styleCollection.initializeDefault(this.getLayerManager().generateLayerFillColor());
        return styleCollection;
    }

    public LayerStyleCollection getDefaultLayerStyleCollection() {
        return (LayerStyleCollection)this.getDefaultStyleCollection();
    }

    public LayerStyleCollection getValidLayerStyleCollection() {
        return (LayerStyleCollection)this.getValidStyleCollection();
    }

    @Override
    public Envelope getEnvelope() {
        try {
            Envelope env = this.fmd.getBounds(this.getDMDCol());
            if (this.transformer.hasTransformation(this.fmd, this.getDMDCol()) && env != null) {
                this.transformer.getTransformer(this.fmd, this.getDMDCol()).transform2d(env);
            }
            if (env == null) {
                return new Envelope();
            }
            return env;
        }
        catch (Exception e) {
            return new Envelope();
        }
    }

    public boolean isDrawingLast() {
        return this.drawingLast;
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public String getLabelLayerKey() {
        return this.labelLayerKey;
    }

    public void setLabelLayerKey(String labelLayerKey) {
        this.labelLayerKey = labelLayerKey;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public LabelLayer getLabelLayer() {
        if (this.labelLayerKey == null) {
            return null;
        }
        return (LabelLayer)this.getLayerManager().getLayerByKey(this.labelLayerKey);
    }

    public void setLabelLayer(LabelLayer labelLayer) {
        this.labelLayerKey = labelLayer == null ? null : labelLayer.getKey();
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    @Override
    public void setCategory(int index, Category cat) {
        if (cat != null && cat.getLayerManager() != this.getLayerManager()) {
            this.clearFeatureCache();
            this.rollbackEditedFeatures();
        }
        super.setCategory(index, cat);
    }

    public Collection<String> getFidFilterWhiteList() {
        return this.fidFilterWhiteList;
    }

    public void setFidFilterWhiteList(Collection<String> fidFilterWhiteList) {
        this.fidFilterWhiteList = fidFilterWhiteList;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public boolean isDataFiltered() {
        return this.fidFilterWhiteList != null;
    }

    public boolean hasNonPersistedChanges() {
        return this.isEditable() && this.hasEditedFeatures();
    }

    public boolean isSelectionClearingNeeded(boolean added, boolean modified, boolean deleted) {
        return true;
    }

    public String getNameForExport() {
        FeaturestoreMetadata fmd = this.getFMD();
        return fmd.getDatastoreName() + "_" + fmd.getDatatypeName();
    }

    public boolean canBeDigiLayer() {
        try {
            return this.isEditable() && this.getFMD().isInsertAllowed();
        }
        catch (RuntimeException e) {
            this.setRenderError(String.format("Error on checking editing permission: %s", e.getMessage()));
            return false;
        }
    }

    public static void removeDependentLayer(Layerable layerable) {
        LabelLayer labelLayer;
        if (layerable instanceof Layer && (labelLayer = ((Layer)layerable).getLabelLayer()) != null) {
            LayerManager.dispose(labelLayer);
        }
    }

    public void clearRendererCache() {
        this.getColorThemingStyleModels().forEach(ColorThemingRenderer::clearCaches);
    }

    private Stream<ColorThemingRenderer> getColorThemingStyleModels() {
        return this.getStyleCollections().stream().flatMap(sCol -> sCol.getStyles().stream()).filter(styleModel -> styleModel instanceof ColorThemingStyleModel).map(styleModel -> (ColorThemingStyleModel)styleModel).map(themeStyleModel -> RenderUtil.getRenderer(themeStyleModel));
    }

    @Override
    public boolean displayedTreeNodeContains(String searchValue) {
        if (super.displayedTreeNodeContains(searchValue)) {
            return true;
        }
        return this.getLayerThemingStyleModels().filter(thStyleModel -> thStyleModel != null).anyMatch(thStyleModel -> this.doesStyleModelContainStringValue(searchValue, (ColorThemingStyleModel)thStyleModel));
    }

    private boolean doesStyleModelContainStringValue(String searchValue, ColorThemingStyleModel thStyleModel) {
        if (thStyleModel == null) {
            return false;
        }
        ThemeSourceModel themeSourceModel = thStyleModel.getThemeSource();
        if (themeSourceModel instanceof BasicStaticThemeSourceModel) {
            BasicStaticThemeSourceModel source = (BasicStaticThemeSourceModel)themeSourceModel;
            return source.getThemes().stream().anyMatch(theme -> StringUtils.containsIgnoreCase((CharSequence)theme.getLabel(), (CharSequence)searchValue));
        }
        themeSourceModel = thStyleModel.getThemeSource();
        if (themeSourceModel instanceof DynamicThemeSourceModel) {
            DynamicThemeSourceModel source = (DynamicThemeSourceModel)themeSourceModel;
            try {
                return ((ThemeRetriever)source.getIntelligence()).getThemes(this).stream().anyMatch(theme -> StringUtils.containsIgnoreCase((CharSequence)((ThemeModel)theme).getLabel(), (CharSequence)searchValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void executeForInitialization() throws Exception {
        super.executeForInitialization();
        this.getLayerThemingStyleModels().forEach(model -> {
            ThemeSourceModel patt0$temp = model.getThemeSource();
            if (patt0$temp instanceof DynamicThemeSourceModel) {
                DynamicThemeSourceModel source = (DynamicThemeSourceModel)patt0$temp;
                ((ThemeRetriever)source.getIntelligence()).getThemes(this);
            }
        });
    }

    private boolean doesStyleModelsContainDynamicThemeSource() {
        return this.getLayerThemingStyleModels().anyMatch(model -> model.getThemeSource() instanceof DynamicThemeSourceModel);
    }

    private Stream<ColorThemingStyleModel> getLayerThemingStyleModels() {
        return this.getStyleCollections().stream().filter(styleCollection -> !styleCollection.getLayerable().isScaleDependentRenderingEnabled() || styleCollection.getLayerable().isScaleDependentRenderingEnabled() && !styleCollection.getDefault()).flatMap(sCol -> sCol.getStyles().stream()).filter(ColorThemingStyleModel.class::isInstance).map(ColorThemingStyleModel.class::cast);
    }

    private static /* synthetic */ boolean lambda$synchronizeAttributeTableWithFMD$2(Set attributes2Delete, AttributeProperty prop) {
        return attributes2Delete.contains(prop.getName());
    }
}

