/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="labelLayer")
public class LabelLayer
extends Layer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelLayer.class);
    public static final String TBL_SUFFIX = "_tbl";
    private boolean labelTextEditable = false;
    private transient Layer parentLayer = null;

    public LabelLayer(String name, FeaturestoreMetadata _fmd, LayerManager layerManager, Layer parentLayer) {
        super(name, _fmd, layerManager);
        this.parentLayer = parentLayer;
    }

    public Layer getParentLayer() {
        if (this.parentLayer == null) {
            log.debug("No parent layer for label layer {} defined. Searching in layer tree for parent", (Object)this.getLabelLayerKey());
            for (Layer parentLayer : this.getLayerManager().getLayers()) {
                if (parentLayer.getLabelLayer() != this) continue;
                this.parentLayer = parentLayer;
                log.debug("Parent {} found for label layer {}", (Object)parentLayer.getLabelLayerKey(), (Object)this.getLabelLayerKey());
                break;
            }
        }
        return this.parentLayer;
    }

    public boolean isLabelTextEditable() {
        return this.labelTextEditable;
    }

    public void setLabelTextEditable(boolean labelTextEditable) {
        this.labelTextEditable = labelTextEditable;
    }

    @Override
    public int getLayerType() {
        return 4;
    }

    public List<LabelDefInfo> cacheLabelDefs() throws IOException {
        return this.getLayerManager().getTask().cacheLabelDefs(this.getFMD().getDatastoreName(), this.getDMDCol().getByName(this.getFMD().getDatastoreName()).getDataStore(), StringUtils.isAllUpperCase((CharSequence)this.getFMD().getDatastoreName()));
    }

    @Override
    public void setKey(String _key) {
        Layer parentLayer = !_key.equals(this.getKey()) && this.getLayerManager() != null ? this.getParentLayer() : null;
        super.setKey(_key);
        if (parentLayer != null) {
            parentLayer.setLabelLayer(this);
        }
    }

    public static void removeReferenceFromParentLayer(Layerable layerable) {
        Layer parentLayer;
        if (layerable instanceof LabelLayer && (parentLayer = ((LabelLayer)layerable).getParentLayer()) != null) {
            parentLayer.setLabelLayer(null);
        }
    }

    @Override
    public boolean canBeDigiLayer() {
        return false;
    }

    @Override
    public boolean displayedTreeNodeContains(String searchValue) {
        return StringUtils.containsIgnoreCase((CharSequence)this.getName(), (CharSequence)searchValue);
    }
}

