/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureEvent {
    private final Layer layer;
    private final FeatureEventType type;
    private final Collection<SimpleFeature> features;
    private final Collection<SimpleFeature> oldFeatureClones;
    private final Collection<SimpleFeature> oldFeatureAttClones;

    public FeatureEvent(Collection<SimpleFeature> features, FeatureEventType type, Layer layer, Collection<SimpleFeature> _oldFeatureClones) {
        Assert.isTrue((layer != null ? 1 : 0) != 0);
        Assert.isTrue((type != null ? 1 : 0) != 0);
        Assert.isTrue((type == FeatureEventType.GEOMETRY_MODIFIED && _oldFeatureClones != null || type != FeatureEventType.GEOMETRY_MODIFIED && _oldFeatureClones == null || type == FeatureEventType.ATTRIBUTES_MODIFIED && _oldFeatureClones != null ? 1 : 0) != 0);
        this.layer = layer;
        this.type = type;
        this.features = features;
        if (this.type == FeatureEventType.GEOMETRY_MODIFIED) {
            this.oldFeatureClones = _oldFeatureClones;
            this.oldFeatureAttClones = null;
        } else if (this.type == FeatureEventType.ATTRIBUTES_MODIFIED) {
            this.oldFeatureClones = null;
            this.oldFeatureAttClones = _oldFeatureClones;
        } else {
            this.oldFeatureClones = null;
            this.oldFeatureAttClones = null;
        }
    }

    public Layer getLayer() {
        return this.layer;
    }

    public FeatureEventType getType() {
        return this.type;
    }

    public Collection<SimpleFeature> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    public Collection<SimpleFeature> getOldFeatureClones() {
        return Collections.unmodifiableCollection(this.oldFeatureClones);
    }

    public Collection<SimpleFeature> getOldFeatureAttClones() {
        return Collections.unmodifiableCollection(this.oldFeatureAttClones);
    }
}

