/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.DimStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@XStreamAlias(value="DimLayer")
public class DimLayer
extends Layer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimLayer(String name, FeaturestoreMetadata _fmd, LayerManager layerManager) {
        super(name, _fmd, layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
            styleCollection.addStyle((StyleModel)new DimStyleModel());
            styleCollection.setDefault(true);
            this.addStyleCollection(styleCollection);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
        styleCollection.addStyle((StyleModel)new DimStyleModel());
        return styleCollection;
    }

    @Override
    public int getLayerType() {
        return 1;
    }

    @Override
    protected String isFeatureValid(SimpleFeature feat, int action) {
        String strError = super.isFeatureValid(feat, action);
        if (strError != null) {
            return strError;
        }
        if (!(action != 1 && action != 2 || DimLayer.isDimensionValid(feat))) {
            return I18N.get("model.DimLayer.invalid-geometry-for-dimension");
        }
        return null;
    }

    public static boolean isDimensionValid(SimpleFeature feat) {
        Geometry newGeom = (Geometry)feat.getDefaultGeometry();
        if (newGeom == null || newGeom.isEmpty()) {
            return true;
        }
        Number intDimType = (Number)FeatureUtil.getAttribute((SimpleFeature)feat, (String)DimFeatureAtts.MTYPE.getName());
        if (intDimType == null) {
            intDimType = 0;
        }
        switch (intDimType.intValue()) {
            case 0: {
                if (newGeom.getCoordinates().length >= 4 && newGeom instanceof MultiPoint) break;
                return false;
            }
            case 3: {
                if (newGeom.getCoordinates().length >= 2 && newGeom instanceof MultiPoint) break;
                return false;
            }
            case 1: {
                if (newGeom.getCoordinates().length == 6 && newGeom instanceof MultiPoint) break;
                return false;
            }
            case 2: {
                if (newGeom.getCoordinates().length == 5 && newGeom instanceof MultiPoint) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void editFeature(SimpleFeature feat, int action, Collection<SimpleFeature> oldFeatures) throws Exception {
        if (action == 1 && FeatureUtil.hasAttribute((SimpleFeature)feat, (String)DimFeatureAtts.ISDIM.getName())) {
            AttributeDescriptor attType = FeatureUtil.getAttributeDescriptor((SimpleFeatureType)feat.getFeatureType(), (String)DimFeatureAtts.ISDIM.getName());
            if (Number.class.isAssignableFrom(attType.getType().getBinding())) {
                FeatureUtil.setAttribute((SimpleFeature)feat, (String)DimFeatureAtts.ISDIM.getName(), (Object)new Integer(1));
            } else if (Boolean.class.isAssignableFrom(attType.getType().getBinding())) {
                FeatureUtil.setAttribute((SimpleFeature)feat, (String)DimFeatureAtts.ISDIM.getName(), (Object)new Boolean(true));
            }
        }
        super.editFeature(feat, action, oldFeatures);
    }
}

